/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.applet.util;

import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JNLPAppletLauncher
extends Applet {
    public static boolean VERBOSE = false;
    public static boolean DEBUG = false;
    private boolean isInitOk = false;
    private boolean firstStart = true;
    private boolean appletStarted = false;
    private Applet subApplet;
    private String subAppletClassName;
    private String subAppletDisplayName;
    private URL subAppletImageURL;
    private JPanel loaderPanel;
    private static final String JRE_PREFIX = "deployment.javapi.jre.";
    private static final String NODDRAW_PROP = "-Dsun.java2d.noddraw=true";
    private static final String DONT_ASK = ".dont_ask";
    private JProgressBar progressBar = null;
    private static boolean firstApplet = true;
    private static List jnlpExtensions = null;
    private static URL codeBase;
    private static String archive;
    private static File cacheDir;
    private static Set jarFiles;
    private static Set nativeJars;
    private static String nativePrefix;
    private static String nativeSuffix;
    private static Map nativeLibMap;
    private static boolean staticInitError;
    private static File tmpBaseDir;
    private static String tmpRootPropValue;
    private static File tmpRootDir;
    private static File nativeTmpDir;
    static /* synthetic */ Class class$0;

    static {
        archive = null;
        staticInitError = false;
        System.err.println("JNLPAppletLauncher: static initializer");
        String systemOsName = System.getProperty("os.name").toLowerCase();
        if (systemOsName.startsWith("mac")) {
            nativePrefix = "lib";
            nativeSuffix = ".jnilib";
        } else if (systemOsName.startsWith("windows")) {
            nativePrefix = "";
            nativeSuffix = ".dll";
        } else {
            nativePrefix = "lib";
            nativeSuffix = ".so";
        }
        if (DEBUG) {
            System.err.println("os.name = " + systemOsName);
            System.err.println("nativePrefix = " + nativePrefix + "  nativeSuffix = " + nativeSuffix);
        }
        try {
            JNLPAppletLauncher.initTmpRoot();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            staticInitError = true;
        }
    }

    public void init() {
        if (VERBOSE) {
            System.err.println();
            System.err.println("===========================================================================");
        }
        if (DEBUG) {
            System.err.println("Applet.init");
        }
        if (staticInitError) {
            return;
        }
        this.subAppletClassName = this.getParameter("subapplet.classname");
        if (this.subAppletClassName == null) {
            this.displayError("Init failed : Missing subapplet.classname parameter");
            return;
        }
        this.subAppletDisplayName = this.getParameter("subapplet.displayname");
        if (this.subAppletDisplayName == null) {
            this.subAppletDisplayName = "Applet";
        }
        this.subAppletImageURL = null;
        try {
            String subAppletImageStr = this.getParameter("subapplet.image");
            if (subAppletImageStr != null && subAppletImageStr.length() > 0) {
                this.subAppletImageURL = new URL(subAppletImageStr);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (DEBUG) {
            System.err.println("subapplet.classname = " + this.subAppletClassName);
            System.err.println("subapplet.displayname = " + this.subAppletDisplayName);
            if (this.subAppletImageURL != null) {
                System.err.println("subapplet.image = " + this.subAppletImageURL.toExternalForm());
            }
        }
        this.initLoaderLayout();
        this.isInitOk = true;
    }

    public void start() {
        if (DEBUG) {
            System.err.println("Applet.start");
        }
        if (this.isInitOk) {
            if (this.firstStart) {
                this.firstStart = false;
                Thread startupThread = new Thread(){

                    public void run() {
                        JNLPAppletLauncher.this.initAndStartApplet();
                    }
                };
                startupThread.setName("AppletLauncher-Startup");
                startupThread.setPriority(4);
                startupThread.start();
            } else if (this.appletStarted) {
                this.checkNoDDrawAndUpdateDeploymentProperties();
                this.subApplet.start();
            }
        }
    }

    public void stop() {
        if (this.subApplet != null) {
            this.subApplet.stop();
        }
    }

    public void destroy() {
        if (this.subApplet != null) {
            this.subApplet.destroy();
        }
    }

    public Applet getSubApplet() {
        return this.subApplet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initTmpRoot() throws IOException {
        if (VERBOSE) {
            System.err.println("---------------------------------------------------");
        }
        PrintStream printStream = System.out;
        synchronized (printStream) {
            String tmpBaseName = String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + "jnlp-applet";
            tmpBaseDir = new File(tmpBaseName);
            tmpRootPropValue = System.getProperty("jnlp.applet.launcher.tmproot");
            if (tmpRootPropValue == null) {
                tmpBaseDir.mkdir();
                if (!tmpBaseDir.isDirectory()) {
                    throw new IOException("Cannot create directory " + tmpBaseDir);
                }
                File tmpFile = File.createTempFile("jln", ".tmp", tmpBaseDir);
                if (VERBOSE) {
                    System.err.println("tmpFile = " + tmpFile.getAbsolutePath());
                }
                final FileOutputStream tmpOut = new FileOutputStream(tmpFile);
                FileChannel tmpChannel = tmpOut.getChannel();
                final FileLock tmpLock = tmpChannel.lock();
                String tmpFileName = tmpFile.getAbsolutePath();
                String tmpRootName = tmpFileName.substring(0, tmpFileName.lastIndexOf(".tmp"));
                String lckFileName = String.valueOf(tmpRootName) + ".lck";
                File lckFile = new File(lckFileName);
                if (VERBOSE) {
                    System.err.println("lckFile = " + lckFile.getAbsolutePath());
                }
                lckFile.createNewFile();
                final FileOutputStream lckOut = new FileOutputStream(lckFile);
                FileChannel lckChannel = lckOut.getChannel();
                final FileLock lckLock = lckChannel.lock();
                tmpRootDir = new File(tmpRootName);
                if (DEBUG) {
                    System.err.println("tmpRootDir = " + tmpRootDir.getAbsolutePath());
                }
                if (!tmpRootDir.mkdir()) {
                    throw new IOException("Cannot create " + tmpRootDir);
                }
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    public void run() {
                        try {
                            tmpOut.close();
                            tmpLock.release();
                            lckOut.close();
                            lckLock.release();
                        }
                        catch (IOException iOException) {}
                    }
                });
                tmpRootPropValue = tmpRootName.substring(tmpRootName.lastIndexOf(File.separator) + 1);
                System.setProperty("jnlp.applet.launcher.tmproot", tmpRootPropValue);
                if (VERBOSE) {
                    System.err.println("Setting jnlp.applet.launcher.tmproot=" + tmpRootPropValue);
                }
                Thread reaperThread = new Thread(){

                    public void run() {
                        JNLPAppletLauncher.deleteOldTempDirs();
                    }
                };
                reaperThread.setName("AppletLauncher-Reaper");
                reaperThread.start();
            } else {
                if (tmpRootPropValue.indexOf(47) >= 0 || tmpRootPropValue.indexOf(File.separatorChar) >= 0) {
                    throw new IOException("Illegal value of: jnlp.applet.launcher.tmproot");
                }
                if (VERBOSE) {
                    System.err.println("Using existing value of: jnlp.applet.launcher.tmproot=" + tmpRootPropValue);
                }
                tmpRootDir = new File(tmpBaseDir, tmpRootPropValue);
                if (DEBUG) {
                    System.err.println("tmpRootDir = " + tmpRootDir.getAbsolutePath());
                }
                if (!tmpRootDir.isDirectory()) {
                    throw new IOException("Cannot access " + tmpRootDir);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void deleteOldTempDirs() {
        block20: {
            String ourLockFile;
            FilenameFilter lckFilter;
            String[] fileNames;
            if (VERBOSE) {
                System.err.println("*** Reaper: deleteOldTempDirs in " + tmpBaseDir.getAbsolutePath());
            }
            if ((fileNames = tmpBaseDir.list(lckFilter = new FilenameFilter(ourLockFile = String.valueOf(tmpRootPropValue) + ".lck"){
                private final /* synthetic */ String val$ourLockFile;
                {
                    this.val$ourLockFile = string;
                }

                public boolean accept(File dir, String name) {
                    return name.endsWith(".lck") && !name.equals(this.val$ourLockFile);
                }
            })) == null) break block20;
            int i = 0;
            while (i < fileNames.length) {
                block19: {
                    File tmpDir;
                    block21: {
                        FileLock lckLock;
                        FileOutputStream lckOut;
                        FileLock tmpLock;
                        FileOutputStream tmpOut;
                        File tmpFile;
                        File lckFile;
                        block18: {
                            block17: {
                                String lckFileName = fileNames[i];
                                String tmpDirName = lckFileName.substring(0, lckFileName.lastIndexOf(".lck"));
                                String tmpFileName = String.valueOf(tmpDirName) + ".tmp";
                                lckFile = new File(tmpBaseDir, lckFileName);
                                tmpFile = new File(tmpBaseDir, tmpFileName);
                                tmpDir = new File(tmpBaseDir, tmpDirName);
                                if (!lckFile.exists() || !tmpFile.exists() || !tmpDir.isDirectory()) break block21;
                                tmpOut = null;
                                FileChannel tmpChannel = null;
                                tmpLock = null;
                                try {
                                    tmpOut = new FileOutputStream(tmpFile);
                                    tmpChannel = tmpOut.getChannel();
                                    tmpLock = tmpChannel.tryLock();
                                }
                                catch (Exception ex) {
                                    if (!DEBUG) break block17;
                                    ex.printStackTrace();
                                }
                            }
                            if (tmpLock == null) break block19;
                            lckOut = null;
                            FileChannel lckChannel = null;
                            lckLock = null;
                            try {
                                lckOut = new FileOutputStream(lckFile);
                                lckChannel = lckOut.getChannel();
                                lckLock = lckChannel.tryLock();
                            }
                            catch (Exception ex) {
                                if (!DEBUG) break block18;
                                ex.printStackTrace();
                            }
                        }
                        if (lckLock != null) {
                            JNLPAppletLauncher.removeAll(tmpDir);
                            try {
                                lckOut.close();
                            }
                            catch (IOException iOException) {}
                            lckFile.delete();
                            try {
                                tmpOut.close();
                            }
                            catch (IOException iOException) {}
                            tmpFile.delete();
                            break block19;
                        } else {
                            try {
                                if (lckOut != null) {
                                    lckOut.close();
                                }
                                tmpOut.close();
                                tmpLock.release();
                            }
                            catch (IOException ex) {
                                if (DEBUG) {
                                    ex.printStackTrace();
                                }
                                break block19;
                            }
                        }
                    }
                    if (VERBOSE) {
                        System.err.println("    Skipping: " + tmpDir.getAbsolutePath());
                    }
                }
                ++i;
            }
        }
    }

    private static void removeAll(File path) {
        File[] list;
        if (VERBOSE) {
            System.err.println("removeAll(" + path + ")");
        }
        if (path.isDirectory() && (list = path.listFiles()) != null) {
            int i = 0;
            while (i < list.length) {
                JNLPAppletLauncher.removeAll(list[i]);
                ++i;
            }
        }
        path.delete();
    }

    private void initAndStartApplet() {
        try {
            this.initResources();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.displayError(JNLPAppletLauncher.toErrorString(ex));
            return;
        }
        this.displayMessage("Starting applet " + this.subAppletDisplayName);
        this.setProgress(0);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JNLPAppletLauncher.this.startSubApplet();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initResources() throws IOException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jdesktop.applet.util.JNLPAppletLauncher");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (firstApplet) {
                codeBase = this.getCodeBase();
                archive = this.getParameter("archive");
                if (archive == null || archive.length() == 0) {
                    throw new IllegalArgumentException("Missing archive parameter");
                }
                jarFiles = new HashSet();
                nativeJars = new HashSet();
                nativeLibMap = new HashMap();
            }
            int jnlpNumExt = -1;
            String numParamString = this.getParameter("jnlpNumExtensions");
            if (numParamString != null) {
                try {
                    jnlpNumExt = Integer.parseInt(numParamString);
                }
                catch (NumberFormatException numberFormatException) {}
                if (jnlpNumExt <= 0) {
                    throw new IllegalArgumentException("Missing or invalid jnlpNumExtensions parameter");
                }
            }
            ArrayList<URL> urls = new ArrayList<URL>();
            int i = 1;
            while (i <= jnlpNumExt) {
                String paramName = "jnlpExtension" + i;
                String urlString = this.getParameter(paramName);
                if (urlString == null || urlString.length() == 0) {
                    throw new IllegalArgumentException("Missing " + paramName + " parameter");
                }
                URL url = new URL(urlString);
                urls.add(url);
                ++i;
            }
            if (firstApplet) {
                jnlpExtensions = urls;
                this.parseJNLPExtensions(urls);
                if (VERBOSE) {
                    System.err.println();
                    System.err.println("All files successfully parsed");
                    JNLPAppletLauncher.printResources();
                }
                if (nativeJars.size() > 0) {
                    this.createCacheDir();
                    this.createTmpDir();
                    Iterator iter = nativeJars.iterator();
                    while (iter.hasNext()) {
                        URL url = (URL)iter.next();
                        this.processNativeJar(url);
                    }
                }
                System.setProperty("sun.jnlp.applet.launcher", "true");
            } else if (!jnlpExtensions.equals(urls)) {
                throw new IllegalArgumentException("jnlpExtension parameters do not match previously loaded applet");
            }
            firstApplet = false;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void createCacheDir() throws IOException {
        StringBuffer cacheBaseName = new StringBuffer();
        cacheBaseName.append(System.getProperty("user.home")).append(File.separator).append(".jnlp-applet").append(File.separator).append("cache");
        File cacheBaseDir = new File(cacheBaseName.toString());
        if (VERBOSE) {
            System.err.println("cacheBaseDir = " + cacheBaseDir.getAbsolutePath());
        }
        cacheDir = new File(cacheBaseDir, this.getCacheDirName());
        if (VERBOSE) {
            System.err.println("cacheDir = " + cacheDir.getAbsolutePath());
        }
        if (!cacheDir.isDirectory() && !cacheDir.mkdirs()) {
            throw new IOException("Cannot create directory " + cacheDir);
        }
    }

    private String getCacheDirName() {
        String codeBasePath = this.getCodeBase().toExternalForm();
        int hostIdx1 = -1;
        int hostIdx2 = -1;
        String hostNameDir = "UNKNOWN";
        hostIdx1 = codeBasePath.indexOf("://");
        if (hostIdx1 >= 0 && (hostIdx1 += 3) < codeBasePath.length() && codeBasePath.charAt(hostIdx1) != '/' && (hostIdx2 = codeBasePath.indexOf(47, hostIdx1)) > hostIdx1) {
            hostNameDir = codeBasePath.substring(hostIdx1, hostIdx2).replace('.', '_').replace(':', '_').replace('\\', '_').replace('[', '_').replace(']', '_');
        }
        StringBuffer key = new StringBuffer();
        key.append(codeBasePath).append("\n").append(this.getParameter("archive"));
        if (VERBOSE) {
            System.err.println("key = " + key);
        }
        StringBuffer result2 = new StringBuffer();
        result2.append(hostNameDir).append(File.separator).append(JNLPAppletLauncher.sha1Hash(key.toString()));
        if (VERBOSE) {
            System.err.println("result = " + result2);
        }
        return result2.toString();
    }

    private static String sha1Hash(String str) {
        MessageDigest sha1 = null;
        try {
            sha1 = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
        byte[] digest = sha1.digest(str.getBytes());
        if (digest == null || digest.length == 0) {
            throw new RuntimeException("Error reading message digest");
        }
        StringBuffer res = new StringBuffer();
        int i = 0;
        while (i < digest.length) {
            int val = digest[i] & 0xFF;
            if (val < 16) {
                res.append("0");
            }
            res.append(Integer.toHexString(val));
            ++i;
        }
        return res.toString();
    }

    private void createTmpDir() throws IOException {
        if (VERBOSE) {
            System.err.println("---------------------------------------------------");
        }
        File tmpFile = File.createTempFile("jln", ".tmp", tmpRootDir);
        String tmpFileName = tmpFile.getAbsolutePath();
        String tmpDirName = tmpFileName.substring(0, tmpFileName.lastIndexOf(".tmp"));
        nativeTmpDir = new File(tmpDirName);
        if (VERBOSE) {
            System.err.println("tmpFile = " + tmpFile.getAbsolutePath() + "  tmpDir = " + nativeTmpDir.getAbsolutePath());
        }
        if (!nativeTmpDir.mkdir()) {
            throw new IOException("Cannot create " + nativeTmpDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNativeJar(URL url) throws IOException {
        Object iter;
        String urlString = url.toExternalForm().replace('\\', '/');
        String nativeFileName = urlString.substring(urlString.lastIndexOf("/") + 1);
        File nativeFile = new File(cacheDir, nativeFileName);
        if (nativeFile.isDirectory()) {
            throw new IOException(nativeFile + " is a directory");
        }
        String tmpStr = nativeFileName;
        int idx = nativeFileName.lastIndexOf(".");
        if (idx > 0) {
            tmpStr = nativeFileName.substring(0, idx);
        }
        String indexFileName = String.valueOf(tmpStr) + ".idx";
        File indexFile = new File(cacheDir, indexFileName);
        if (VERBOSE) {
            System.err.println("nativeFile = " + nativeFile);
            System.err.println("indexFile = " + indexFile);
        }
        this.displayMessage("Loading: " + nativeFileName);
        this.setProgress(0);
        URLConnection conn = url.openConnection();
        conn.connect();
        Map<String, List<String>> headerFields = conn.getHeaderFields();
        if (VERBOSE) {
            iter = headerFields.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry e = (Map.Entry)iter.next();
                Iterator iter2 = ((List)e.getValue()).iterator();
                while (iter2.hasNext()) {
                    String s2 = (String)iter2.next();
                    if (e.getKey() != null) {
                        System.err.print(e.getKey() + ": ");
                    }
                    System.err.print(String.valueOf(s2) + " ");
                }
                System.err.println();
            }
            System.err.println();
        }
        iter = System.out;
        synchronized (iter) {
            this.validateCache(conn, nativeFile, indexFile);
        }
        this.displayMessage("Unpacking: " + nativeFileName);
        this.setProgress(0);
        JarFile jarFile = new JarFile(nativeFile);
        Set nativeLibNames = this.getNativeLibNames(jarFile);
        this.validateCertificates(jarFile, nativeLibNames);
        this.extractNativeLibs(jarFile, nativeLibNames);
        if (VERBOSE) {
            System.err.println();
        }
    }

    private void validateCache(URLConnection conn, File nativeFile, File indexFile) throws IOException {
        File lckFile = new File(cacheDir, "cache.lck");
        lckFile.createNewFile();
        FileOutputStream lckOut = new FileOutputStream(lckFile);
        FileChannel lckChannel = lckOut.getChannel();
        FileLock lckLock = lckChannel.lock();
        try {
            boolean valid = false;
            long urlTimeStamp = conn.getLastModified();
            if (nativeFile.exists() && urlTimeStamp > 0L && urlTimeStamp == this.readTimeStamp(indexFile)) {
                valid = true;
            }
            if (!valid) {
                if (VERBOSE) {
                    System.err.println("processNativeJar: downloading " + nativeFile.getAbsolutePath());
                }
                indexFile.delete();
                nativeFile.delete();
                int len = conn.getContentLength();
                if (VERBOSE) {
                    System.err.println("Content length = " + len + " bytes");
                }
                int totalNumBytes = this.copyURLToFile(conn, nativeFile);
                if (DEBUG) {
                    System.err.println("processNativeJar: " + conn.getURL().toString() + " --> " + nativeFile.getAbsolutePath() + " : " + totalNumBytes + " bytes written");
                }
                this.writeTimeStamp(indexFile, urlTimeStamp);
            } else if (DEBUG) {
                System.err.println("processNativeJar: using previously cached: " + nativeFile.getAbsolutePath());
            }
        }
        finally {
            lckLock.release();
        }
    }

    private long readTimeStamp(File indexFile) {
        long l;
        BufferedReader reader = new BufferedReader(new FileReader(indexFile));
        try {
            String str = reader.readLine();
            l = Long.parseLong(str);
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (Exception exception) {
                return -1L;
            }
        }
        reader.close();
        return l;
    }

    private void writeTimeStamp(File indexFile, long timestamp) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(indexFile));
            try {
                writer.write(timestamp + "\n");
                writer.flush();
            }
            finally {
                writer.close();
            }
        }
        catch (Exception exception) {
            this.displayError("Error writing time stamp for native libraries");
        }
    }

    private int copyURLToFile(URLConnection inConnection, File outFile) throws IOException {
        int totalNumBytes = 0;
        BufferedInputStream in = new BufferedInputStream(inConnection.getInputStream());
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outFile));
            try {
                totalNumBytes = this.copyStream(in, out, inConnection.getContentLength());
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        finally {
            ((InputStream)in).close();
        }
        return totalNumBytes;
    }

    private int copyStream(InputStream in, OutputStream out, int totalNumBytes) throws IOException {
        int count2;
        int numBytes = 0;
        float pctScale = 100.0f / (float)totalNumBytes;
        byte[] buf = new byte[1000];
        this.setProgress(0);
        while ((count2 = in.read(buf)) != -1) {
            out.write(buf, 0, count2);
            numBytes += count2;
            if (totalNumBytes <= 0) continue;
            this.setProgress(Math.round((float)numBytes * pctScale));
        }
        this.setProgress(100);
        return numBytes;
    }

    private Set getNativeLibNames(JarFile jarFile) {
        if (VERBOSE) {
            System.err.println("getNativeLibNames:");
        }
        HashSet<String> names = new HashSet<String>();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            String lowerCaseName;
            JarEntry entry = entries.nextElement();
            String nativeLibName = entry.getName();
            if (VERBOSE) {
                System.err.println("JarEntry : " + nativeLibName);
            }
            if (nativeLibName.indexOf(47) != -1 || nativeLibName.indexOf(File.separatorChar) != -1 || !(lowerCaseName = nativeLibName.toLowerCase()).startsWith(nativePrefix) || !nativeLibName.toLowerCase().endsWith(nativeSuffix)) continue;
            names.add(nativeLibName);
        }
        return names;
    }

    private void validateCertificates(JarFile jarFile, Set nativeLibNames) throws IOException {
        if (DEBUG) {
            System.err.println("validateCertificates:");
        }
        byte[] buf = new byte[1000];
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (VERBOSE) {
                System.err.println("JarEntry : " + entryName);
            }
            if (!nativeLibNames.contains(entryName)) continue;
            if (DEBUG) {
                System.err.println("VALIDATE: " + entryName);
            }
            if (this.checkNativeCertificates(jarFile, entry, buf)) continue;
            throw new IOException("Cannot validate certificate for " + entryName);
        }
    }

    private boolean checkNativeCertificates(JarFile jar, JarEntry entry, byte[] buf) throws IOException {
        Certificate[] appletLauncherCerts;
        InputStream is = jar.getInputStream(entry);
        entry.getSize();
        while (is.read(buf) > 0) {
        }
        is.close();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jdesktop.applet.util.JNLPAppletLauncher");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((appletLauncherCerts = clazz.getProtectionDomain().getCodeSource().getCertificates()) == null || appletLauncherCerts.length == 0) {
            throw new IOException("Cannot find certificates for JNLPAppletLauncher class");
        }
        Certificate[] nativeCerts = entry.getCertificates();
        if (nativeCerts == null || nativeCerts.length == 0) {
            return false;
        }
        int checked = 0;
        int i = 0;
        while (i < appletLauncherCerts.length) {
            int j = 0;
            while (j < nativeCerts.length) {
                if (nativeCerts[j].equals(appletLauncherCerts[i])) {
                    ++checked;
                    break;
                }
                ++j;
            }
            ++i;
        }
        return checked == appletLauncherCerts.length;
    }

    private void extractNativeLibs(JarFile jarFile, Set nativeLibNames) throws IOException {
        if (DEBUG) {
            System.err.println("extractNativeLibs:");
        }
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (VERBOSE) {
                System.err.println("JarEntry : " + entryName);
            }
            if (!nativeLibNames.contains(entryName)) continue;
            String libName = entryName.substring(nativePrefix.length(), entryName.length() - nativeSuffix.length());
            if (DEBUG) {
                System.err.println("EXTRACT: " + entryName + "(" + libName + ")");
            }
            File nativeLib = new File(nativeTmpDir, entryName);
            BufferedInputStream in = new BufferedInputStream(jarFile.getInputStream(entry));
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(nativeLib));
            this.copyStream(in, out, -1);
            ((InputStream)in).close();
            ((OutputStream)out).close();
            nativeLibMap.put(libName, nativeLib.getAbsolutePath());
        }
    }

    private void startSubApplet() {
        try {
            this.subApplet = (Applet)Class.forName(this.subAppletClassName).newInstance();
            this.subApplet.setStub(new AppletStubProxy());
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            this.displayError("Class not found: " + this.subAppletClassName);
            return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.displayError("Unable to start " + this.subAppletDisplayName);
            return;
        }
        this.add((Component)this.subApplet, "Center");
        try {
            this.subApplet.init();
            this.remove(this.loaderPanel);
            this.validate();
            this.checkNoDDrawAndUpdateDeploymentProperties();
            this.subApplet.start();
            this.appletStarted = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void loadLibrary(String libraryName, LibraryLoader loader) {
        String fullLibraryName;
        if (VERBOSE) {
            System.err.println("-----------");
            Thread.dumpStack();
        }
        if (DEBUG) {
            System.err.println("JNLPAppletLauncher.loadLibrary(\"" + libraryName + "\")");
        }
        if ((fullLibraryName = (String)nativeLibMap.get(libraryName)) == null) {
            throw new UnsatisfiedLinkError(libraryName);
        }
        if (DEBUG) {
            System.err.println("    loading: " + fullLibraryName);
        }
        if (loader != null) {
            loader.loadLibrary(fullLibraryName);
        } else {
            System.load(fullLibraryName);
        }
    }

    private static String toErrorString(Throwable throwable) {
        StringBuffer errStr = new StringBuffer(throwable.toString());
        Throwable cause = throwable.getCause();
        while (cause != null) {
            errStr.append(": ").append(cause);
            cause = cause.getCause();
        }
        return errStr.toString();
    }

    private void displayMessage(final String message) {
        if (this.progressBar != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JNLPAppletLauncher.this.progressBar.setString(message);
                }
            });
        }
    }

    private void displayError(final String errorMessage) {
        Logger.getLogger("global").severe(errorMessage);
        if (this.progressBar != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JNLPAppletLauncher.this.progressBar.setString("Error : " + errorMessage);
                }
            });
        }
    }

    private void setProgress(final int value2) {
        if (this.progressBar != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JNLPAppletLauncher.this.progressBar.setValue(value2);
                }
            });
        }
    }

    private void initLoaderLayout() {
        this.setLayout(new BorderLayout());
        this.loaderPanel = new JPanel(new BorderLayout());
        if (this.getBooleanParameter("progressbar")) {
            this.progressBar = new JProgressBar(0, 100);
            this.progressBar.setBorderPainted(true);
            this.progressBar.setStringPainted(true);
            this.progressBar.setString("Loading...");
        }
        boolean includeImage = false;
        ImageIcon image = null;
        if (this.subAppletImageURL != null) {
            image = new ImageIcon(this.subAppletImageURL);
            includeImage = true;
        }
        this.add((Component)this.loaderPanel, "South");
        if (includeImage) {
            this.loaderPanel.add((Component)new JLabel(image), "Center");
            if (this.progressBar != null) {
                this.loaderPanel.add((Component)this.progressBar, "South");
            }
        } else if (this.progressBar != null) {
            this.loaderPanel.add((Component)this.progressBar, "Center");
        }
    }

    private void parseJNLPExtensions(List urls) throws IOException {
        Iterator iter = urls.iterator();
        while (iter.hasNext()) {
            URL url = (URL)iter.next();
            JNLPParser parser = new JNLPParser(this, url);
            parser.parse();
        }
    }

    private void addJarFile(URL jarFile) {
        jarFiles.add(jarFile);
    }

    private void addNativeJar(URL nativeJar) {
        nativeJars.add(nativeJar);
    }

    private static void printResources() {
        System.err.println("  Resources:");
        System.err.println("    Class Jars:");
        JNLPAppletLauncher.doPrint(jarFiles);
        System.err.println();
        System.err.println("    Native Jars:");
        JNLPAppletLauncher.doPrint(nativeJars);
    }

    private static void doPrint(Collection urls) {
        Iterator iter = urls.iterator();
        while (iter.hasNext()) {
            URL url = (URL)iter.next();
            String urlString = url.toExternalForm();
            System.err.println("      " + urlString);
        }
    }

    private boolean getBooleanParameter(String parameterName) {
        return Boolean.valueOf(this.getParameter(parameterName));
    }

    private String getDeploymentPropsDir() {
        String osName = System.getProperty("os.name").toLowerCase();
        StringBuffer result2 = new StringBuffer();
        result2.append(System.getProperty("user.home"));
        if (osName.startsWith("windows")) {
            if (osName.indexOf("vista") != -1) {
                result2.append(File.separator).append("AppData").append(File.separator).append("LocalLow");
            } else {
                result2.append(File.separator).append("Application Data");
            }
            result2.append(File.separator).append("Sun").append(File.separator).append("Java").append(File.separator).append("Deployment");
        } else if (osName.startsWith("mac")) {
            result2.append(File.separator).append("Library").append(File.separator).append("Caches").append(File.separator).append("Java");
        } else {
            result2.append(File.separator).append(".java").append(File.separator).append("deployment");
        }
        return result2.toString();
    }

    private void checkNoDDrawAndUpdateDeploymentProperties() {
        if (!this.getBooleanParameter("noddraw.check")) {
            return;
        }
        if (System.getProperty("os.name").toLowerCase().startsWith("windows") && !"true".equalsIgnoreCase(System.getProperty("sun.java2d.noddraw"))) {
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            JNLPAppletLauncher.this.updateDeploymentPropertiesImpl();
                        }
                    });
                }
                catch (Exception exception) {}
            } else {
                this.updateDeploymentPropertiesImpl();
            }
        }
    }

    private void updateDeploymentPropertiesImpl() {
        String userHome = System.getProperty("user.home");
        File dontAskFile = new File(String.valueOf(userHome) + File.separator + ".jnlp-applet" + File.separator + DONT_ASK);
        if (dontAskFile.exists()) {
            return;
        }
        int option = 0;
        if (!this.getBooleanParameter("noddraw.check.silent")) {
            option = JOptionPane.showOptionDialog(null, "For best robustness of OpenGL applets on Windows,\nwe recommend disabling Java2D's use of DirectDraw.\nThis setting will affect all applets, but is unlikely\nto slow other applets down significantly. May we update\nyour deployment.properties to turn off DirectDraw for\napplets? You can change this back later if necessary\nusing the Java Control Panel, Java tab, under Java\nApplet Runtime Settings.", "Update deployment.properties?", 1, 3, null, new Object[]{"Yes", "No", "No, Don't Ask Again"}, "Yes");
        }
        if (option < 0 || option == 1) {
            return;
        }
        if (option == 2) {
            try {
                dontAskFile.createNewFile();
            }
            catch (IOException iOException) {}
            return;
        }
        try {
            File propsDir = new File(this.getDeploymentPropsDir());
            if (!propsDir.exists()) {
                return;
            }
            File propsFile = new File(propsDir, "deployment.properties");
            if (!propsFile.exists()) {
                return;
            }
            Properties props = new Properties();
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(propsFile));
            props.load(input);
            ((InputStream)input).close();
            HashSet<String> jreVersions = new HashSet<String>();
            Iterator<Object> iter = props.keySet().iterator();
            while (iter.hasNext()) {
                int idx;
                String key = (String)iter.next();
                if (!key.startsWith(JRE_PREFIX) || (idx = key.lastIndexOf(".")) < 0 || idx <= JRE_PREFIX.length()) continue;
                String jreVersion = key.substring(JRE_PREFIX.length(), idx);
                jreVersions.add(jreVersion);
            }
            jreVersions.add(System.getProperty("java.version"));
            iter = jreVersions.iterator();
            while (iter.hasNext()) {
                String version = (String)iter.next();
                String argKey = JRE_PREFIX + version + ".args";
                String argVal = props.getProperty(argKey);
                if (argVal == null) {
                    argVal = NODDRAW_PROP;
                } else if (argVal.indexOf(NODDRAW_PROP) < 0) {
                    argVal = String.valueOf(argVal) + " " + NODDRAW_PROP;
                }
                props.setProperty(argKey, argVal);
            }
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(propsFile));
            props.store(output, null);
            ((OutputStream)output).close();
            if (!this.getBooleanParameter("noddraw.check.silent")) {
                JOptionPane.showMessageDialog(null, "For best robustness, we recommend you now exit and\nrestart your web browser. (Note: clicking \"OK\" will\nnot exit your browser.)", "Browser Restart Recommended", 1);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private class AppletStubProxy
    implements AppletStub {
        private AppletStubProxy() {
        }

        public boolean isActive() {
            return JNLPAppletLauncher.this.isActive();
        }

        public URL getDocumentBase() {
            return JNLPAppletLauncher.this.getDocumentBase();
        }

        public URL getCodeBase() {
            return JNLPAppletLauncher.this.getCodeBase();
        }

        public String getParameter(String name) {
            return JNLPAppletLauncher.this.getParameter(name);
        }

        public AppletContext getAppletContext() {
            return JNLPAppletLauncher.this.getAppletContext();
        }

        public void appletResize(int width, int height) {
            JNLPAppletLauncher.this.resize(width, height);
        }
    }

    private static class JNLPParser {
        private static final int INITIAL = 1;
        private static final int STARTED = 2;
        private static final int IN_JNLP = 3;
        private static final int IN_RESOURCES = 4;
        private static final int SKIP_ELEMENT = 5;
        private static SAXParserFactory factory = SAXParserFactory.newInstance();
        private static String systemOsName = System.getProperty("os.name").toLowerCase();
        private static String systemOsArch = System.getProperty("os.arch").toLowerCase();
        private JNLPAppletLauncher launcher;
        private URL url;
        private JNLPHandler handler;
        private String codebase = "";
        private int state = 1;
        private int prevState = 1;
        private int depth = 0;
        private int skipDepth = -1;

        static {
            if (DEBUG) {
                System.err.println("os.name = " + systemOsName);
                System.err.println("os.arch = " + systemOsArch);
            }
        }

        private JNLPParser(JNLPAppletLauncher launcher, URL url) {
            this.launcher = launcher;
            this.url = url;
            this.handler = new JNLPHandler();
        }

        private void parse() throws IOException {
            if (VERBOSE) {
                System.err.println("JNLPParser: " + this.url.toString());
            }
            try {
                URLConnection conn = this.url.openConnection();
                conn.connect();
                BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
                SAXParser parser = factory.newSAXParser();
                parser.parse((InputStream)in, (DefaultHandler)this.handler);
                ((InputStream)in).close();
            }
            catch (ParserConfigurationException ex) {
                throw (IOException)new IOException().initCause(ex);
            }
            catch (SAXException ex) {
                throw (IOException)new IOException().initCause(ex);
            }
        }

        private class JNLPHandler
        extends DefaultHandler {
            JNLPHandler() {
            }

            public void startDocument() {
                if (VERBOSE) {
                    System.err.println("START DOCUMENT: " + JNLPParser.this.url);
                }
                JNLPParser.this.state = 2;
                if (VERBOSE) {
                    System.err.println("state = " + JNLPParser.this.state);
                }
            }

            public void endDocument() {
                if (VERBOSE) {
                    System.err.println("END DOCUMENT");
                }
                JNLPParser.this.state = 1;
                if (VERBOSE) {
                    System.err.println("state = " + JNLPParser.this.state);
                }
            }

            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                JNLPParser jNLPParser = JNLPParser.this;
                jNLPParser.depth = jNLPParser.depth + 1;
                if (VERBOSE) {
                    System.err.println("<" + qName + ">" + " : depth=" + JNLPParser.this.depth);
                    int i = 0;
                    while (i < attributes.getLength()) {
                        System.err.println("    [" + i + "]  " + attributes.getQName(i) + " = \"" + attributes.getValue(i) + "\"");
                        ++i;
                    }
                }
                switch (JNLPParser.this.state) {
                    case 2: {
                        if (qName.equals("jnlp")) {
                            JNLPParser.this.state = 3;
                            JNLPParser.this.codebase = attributes.getValue("codebase");
                            if (JNLPParser.this.codebase == null) {
                                throw new SAXException("<jnlp> unable to determine codebase");
                            }
                            if (JNLPParser.this.codebase.lastIndexOf(47) != JNLPParser.this.codebase.length() - 1) {
                                JNLPParser jNLPParser2 = JNLPParser.this;
                                jNLPParser2.codebase = String.valueOf(jNLPParser2.codebase) + "/";
                            }
                            if (VERBOSE) {
                                System.err.println("JNLP : codebase=" + JNLPParser.this.codebase);
                            }
                            if (!VERBOSE) break;
                            System.err.println("state = " + JNLPParser.this.state);
                            break;
                        }
                        if (!qName.equals("resources")) break;
                        throw new SAXException("<resources> tag not within <jnlp> tag");
                    }
                    case 3: {
                        if (qName.equals("jnlp")) {
                            throw new SAXException("Nested <jnlp> tags");
                        }
                        if (!qName.equals("resources")) break;
                        String osName = attributes.getValue("os");
                        String osArch = attributes.getValue("arch");
                        if ((osName == null || systemOsName.startsWith(osName.toLowerCase())) && (osArch == null || systemOsArch.startsWith(osArch.toLowerCase()))) {
                            if (VERBOSE) {
                                System.err.println("Loading resources : os=" + osName + "  arch=" + osArch);
                            }
                            JNLPParser.this.state = 4;
                        } else {
                            JNLPParser.this.prevState = JNLPParser.this.state;
                            JNLPParser.this.skipDepth = JNLPParser.this.depth - 1;
                            JNLPParser.this.state = 5;
                        }
                        if (!VERBOSE) break;
                        System.err.println("Resources : os=" + osName + "  arch=" + osArch + "  state = " + JNLPParser.this.state);
                        break;
                    }
                    case 4: {
                        try {
                            if (qName.equals("jnlp")) {
                                throw new SAXException("Nested <jnlp> tags");
                            }
                            if (qName.equals("resources")) {
                                throw new SAXException("Nested <resources> tags");
                            }
                            if (qName.equals("jar")) {
                                String str = attributes.getValue("href");
                                if (str == null || str.length() == 0) {
                                    throw new SAXException("<jar> tag missing href attribute");
                                }
                                String jarFileStr = String.valueOf(JNLPParser.this.codebase) + str;
                                if (VERBOSE) {
                                    System.err.println("Jar: " + jarFileStr);
                                }
                                URL jarFile = new URL(jarFileStr);
                                JNLPParser.this.launcher.addJarFile(jarFile);
                                break;
                            }
                            if (qName.equals("nativelib")) {
                                String str = attributes.getValue("href");
                                if (str == null || str.length() == 0) {
                                    throw new SAXException("<nativelib> tag missing href attribute");
                                }
                                String nativeLibStr = String.valueOf(JNLPParser.this.codebase) + str;
                                if (VERBOSE) {
                                    System.err.println("Native Lib: " + nativeLibStr);
                                }
                                URL nativeLib = new URL(nativeLibStr);
                                JNLPParser.this.launcher.addNativeJar(nativeLib);
                                break;
                            }
                            if (qName.equals("extension")) {
                                String extensionURLString = attributes.getValue("href");
                                if (extensionURLString == null || extensionURLString.length() == 0) {
                                    throw new SAXException("<extension> tag missing href attribute");
                                }
                                if (VERBOSE) {
                                    System.err.println("Extension: " + extensionURLString);
                                }
                                URL extensionURL = new URL(extensionURLString);
                                JNLPParser parser = new JNLPParser(JNLPParser.this.launcher, extensionURL);
                                parser.parse();
                                break;
                            }
                            JNLPParser.this.prevState = JNLPParser.this.state;
                            JNLPParser.this.skipDepth = JNLPParser.this.depth - 1;
                            JNLPParser.this.state = 5;
                            if (!VERBOSE) break;
                            System.err.println("state = " + JNLPParser.this.state);
                            break;
                        }
                        catch (IOException ex) {
                            throw (SAXException)new SAXException(ex).initCause(ex);
                        }
                    }
                }
            }

            public void endElement(String uri, String localName, String qName) throws SAXException {
                JNLPParser jNLPParser = JNLPParser.this;
                jNLPParser.depth = jNLPParser.depth - 1;
                if (VERBOSE) {
                    System.err.println("</" + qName + ">");
                }
                switch (JNLPParser.this.state) {
                    case 3: {
                        if (!qName.equals("jnlp")) break;
                        JNLPParser.this.state = 2;
                        if (!VERBOSE) break;
                        System.err.println("state = " + JNLPParser.this.state);
                        break;
                    }
                    case 4: {
                        if (!qName.equals("resources")) break;
                        JNLPParser.this.state = 3;
                        if (!VERBOSE) break;
                        System.err.println("state = " + JNLPParser.this.state);
                        break;
                    }
                    case 5: {
                        if (JNLPParser.this.depth != JNLPParser.this.skipDepth) break;
                        JNLPParser.this.state = JNLPParser.this.prevState;
                        JNLPParser.this.skipDepth = -1;
                        if (!VERBOSE) break;
                        System.err.println("state = " + JNLPParser.this.state);
                        break;
                    }
                }
            }
        }
    }

    public static interface LibraryLoader {
        public void loadLibrary(String var1) throws UnsatisfiedLinkError;
    }
}

