/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.artifex.utils;

public class DoubleAccumulator {
    private double[] values = new double[2];
    private int index = 0;

    private void expand() {
        double[] values2 = new double[this.values.length << 1];
        System.arraycopy(this.values, 0, values2, 0, this.values.length);
        this.values = values2;
    }

    public DoubleAccumulator add(double[] ns) {
        while (this.index > this.values.length - ns.length) {
            this.expand();
        }
        System.arraycopy(ns, 0, this.values, this.index, ns.length);
        this.index += ns.length;
        return this;
    }

    public DoubleAccumulator add(double n) {
        if (this.index > this.values.length - 1) {
            this.expand();
        }
        this.values[this.index++] = n;
        return this;
    }

    public DoubleAccumulator add(double a2, double b) {
        if (this.index > this.values.length - 2) {
            this.expand();
        }
        this.values[this.index++] = a2;
        this.values[this.index++] = b;
        return this;
    }

    public void pop(int num) {
        this.index -= num;
    }

    public void clear() {
        this.index = 0;
    }

    public int size() {
        return this.index;
    }

    public double get(int index) {
        return this.values[index];
    }

    public double last() {
        return this.values[this.index - 1];
    }

    public void set(int index, double n) {
        this.values[index] = n;
    }

    public double[] toArray() {
        double[] result2 = new double[this.size()];
        System.arraycopy(this.values, 0, result2, 0, this.size());
        return result2;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[");
        for (int i = 0; i < this.index; ++i) {
            if (i != 0) {
                b.append(", ");
            }
            b.append(this.values[i]);
        }
        b.append("]");
        return b.toString();
    }
}

