/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.artifex.utils;

import io.lacuna.artifex.Bezier2;
import io.lacuna.artifex.Matrix4;
import io.lacuna.artifex.Vec;
import io.lacuna.artifex.Vec2;
import io.lacuna.artifex.Vec3;
import io.lacuna.artifex.Vec4;

public class Cubics {
    public static Vec3 coefficients(Bezier2.CubicBezier2 c) {
        Vec2 p0 = c.p0;
        Vec2 p1 = c.p1;
        Vec2 p2 = c.p2;
        Vec2 p3 = c.p3;
        double a1 = p0.y * (p2.x - p3.x) + p3.x * p2.y - p2.x * p3.y + p0.x * (p3.y - p2.y);
        double a2 = p0.x * p3.y - p3.x * p0.y + p1.y * (p3.x - p0.x) + p1.x * (p0.y - p3.y);
        double a3 = p1.x * p0.y - p0.x * p1.y + p2.x * (p1.y - p0.y) + p2.y * (p0.x - p1.x);
        double d3 = 3.0 * a3;
        double d2 = d3 - a2;
        double d1 = d2 - a2 + a1;
        return Vec.vec(d1, d2, d3);
    }

    public CubicType cubicType(Vec3 d) {
        double d1 = d.x;
        double d2 = d.y;
        double d3 = d.z;
        double disc = d1 * d1 * (3.0 * d2 * d2 - 4.0 * d1 * d3);
        if (disc < 0.0) {
            return CubicType.LOOP;
        }
        if (disc > 0.0) {
            return CubicType.SERPENTINE;
        }
        if (d1 == d2) {
            return d2 == d3 ? CubicType.LINE : CubicType.QUADRATIC;
        }
        return CubicType.CUSP;
    }

    public static Matrix4 reverse(Matrix4 m) {
        return m.mul(Matrix4.scale(-1.0, -1.0, 1.0));
    }

    public static Matrix4 serpentine(Vec3 d) {
        double d1 = d.x;
        double d2 = d.y;
        double d3 = d.z;
        double disc = Math.sqrt(9.0 * d2 * d2 - 12.0 * d1 * d3);
        double t = 6.0 * d1;
        double l = 3.0 * d2 - disc;
        double m = 3.0 * d2 + disc;
        double lm = l * m;
        double mt = m * t;
        double lt2 = l * t;
        double tt = t * t;
        double ll = l * l;
        double mm = m * m;
        Vec4 v1 = Vec.vec(lm, (3.0 * lm - lt2 - mt) / 3.0, (tt - 2.0 * mt + (3.0 * lm - 2.0 * lt2)) / 3.0, (t - l) * (t - m));
        double tsl = t - l;
        Vec4 v2 = Vec.vec(ll * l, ll * (l - t), tsl * tsl * l, -tsl * tsl * tsl);
        double tsm = t - m;
        Vec4 v3 = Vec.vec(mm * m, mm * m - mm * t, tsm * tsm * m, -tsm * tsm * tsm);
        Matrix4 result2 = Matrix4.from(v1, v2, v3, Vec.vec(0.0, 0.0, 0.0, 1.0));
        return d1 < 0.0 ? Cubics.reverse(result2) : result2;
    }

    public static Matrix4 loop(Vec3 d) {
        double d1 = d.x;
        double d2 = d.y;
        double d3 = d.z;
        double disc = Math.sqrt(4.0 * d1 * d3 - 3.0 * d2 * d2);
        double l = d2 - disc;
        double m = d2 + disc;
        double t = 2.0 * d1;
        double lm = l * m;
        double mt = m * t;
        double lt2 = l * t;
        double tt = t * t;
        double mm = m * m;
        double ll = l * l;
        Vec4 v1 = Vec.vec(l * m, (-lt2 - mt + lm) / 3.0, (tt - 2.0 * mt + (3.0 * lm - 2.0 * lt2)) / 3.0, (t - l) * (t - m));
        Vec4 v2 = Vec.vec(ll * m, -l / 3.0 * (lt2 - 3.0 * lm + 2.0 * mt), (t - l) / 3.0 * (2.0 * lt2 - 3.0 * lm + mt), -(t - l) * (t - l) * (t - m));
        Vec4 v3 = Vec.vec(l * mm, -m / 3.0 * (2.0 * lt2 - 3.0 * lm + mt), (t - m) / 3.0 * (lt2 - 3.0 * lm + 2.0 * mt), -(t - l) * (t - m) * (t - m));
        Matrix4 result2 = Matrix4.from(v1, v2, v3, Vec.vec(0.0, 0.0, 0.0, 1.0));
        return d1 < 0.0 && v1.y > 0.0 || d1 > 0.0 && v1.y < 0.0 ? Cubics.reverse(result2) : result2;
    }

    public static Matrix4 cusp(Vec3 d) {
        double d3;
        double d2 = d.y;
        double l = d3 = d.z;
        double t = 3.0 * d2;
        double ll = l * l;
        double lst = l - t;
        Vec4 v1 = Vec.vec(l, l - t / 3.0, l - 2.0 * t / 3.0, lst);
        Vec4 v2 = Vec.vec(ll * l, ll * lst, lst * lst * l, lst * lst * lst);
        return Matrix4.from(v1, v2, Vec.vec(1.0, 1.0, 1.0, 1.0), Vec.vec(0.0, 0.0, 0.0, 1.0));
    }

    public static Matrix4 quadratic(Vec3 d) {
        return null;
    }

    private static enum CubicType {
        LINE,
        QUADRATIC,
        SERPENTINE,
        CUSP,
        LOOP;

    }
}

