/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.artifex;

import io.lacuna.artifex.Box2;
import io.lacuna.artifex.Curve2;
import io.lacuna.artifex.Line2;
import io.lacuna.artifex.Ring2;
import io.lacuna.artifex.Vec;
import io.lacuna.artifex.Vec2;
import io.lacuna.bifurcan.LinearList;
import io.lacuna.bifurcan.Lists;
import java.util.ArrayList;
import java.util.Arrays;

public class Path2 {
    private final Curve2[] curves;
    private final Box2 bounds;
    private final boolean isRing;

    Path2(Ring2 ring) {
        this.curves = ring.curves;
        this.bounds = ring.bounds;
        this.isRing = true;
    }

    public static Path2 of(Curve2 ... curves) {
        return new Path2(Arrays.asList(curves));
    }

    public static Path2 linear(Vec2 ... vertices) {
        ArrayList<Curve2> segments = new ArrayList<Curve2>();
        for (int i = 0; i < vertices.length - 1; ++i) {
            Vec2 a2 = vertices[i];
            Vec2 b = vertices[i + 1];
            if (Vec.equals(a2, b, 1.0E-14)) continue;
            segments.add(Line2.line(vertices[i], vertices[i + 1]));
        }
        return new Path2(segments);
    }

    public Path2(Iterable<Curve2> cs) {
        LinearList<Curve2> l = new LinearList<Curve2>();
        Box2 bounds = Box2.EMPTY;
        for (Curve2 a2 : cs) {
            for (Curve2 b : a2.split(a2.inflections())) {
                l.addLast(b);
                bounds = (Box2)((Box2)bounds.union(b.start())).union(b.end());
            }
        }
        this.bounds = bounds;
        this.isRing = Vec.equals(((Curve2)l.first()).start(), ((Curve2)l.last()).end(), 1.0E-14);
        this.curves = (Curve2[])l.toArray(Curve2[]::new);
        for (int i = 0; i < this.curves.length - 1; ++i) {
            this.curves[i] = this.curves[i].endpoints(this.curves[i].start(), this.curves[i + 1].start());
        }
        if (this.isRing) {
            int lastIdx = this.curves.length - 1;
            this.curves[lastIdx] = this.curves[lastIdx].endpoints(this.curves[lastIdx].start(), this.curves[0].start());
        }
    }

    public Path2 reverse() {
        return new Path2(Lists.reverse(Lists.lazyMap(Lists.from(this.curves), Curve2::reverse)));
    }

    public Curve2[] curves() {
        return this.curves;
    }

    public boolean isRing() {
        return this.isRing;
    }

    public Box2 bounds() {
        return this.bounds;
    }

    public Iterable<Vec2> vertices(double error) {
        ArrayList<Vec2> result2 = new ArrayList<Vec2>();
        for (Curve2 c : this.curves) {
            Vec2 t2;
            Vec2[] segments = c.subdivide(error);
            if (result2.isEmpty()) {
                result2.addAll(Arrays.asList(segments));
                continue;
            }
            Vec2 t1 = (Vec2)((Vec2)result2.get(result2.size() - 1)).sub((Vec2)result2.get(result2.size() - 2)).norm();
            if (Vec.equals(t1, t2 = (Vec2)segments[1].sub(segments[0]).norm(), 1.0E-14)) {
                result2.remove(result2.size() - 1);
            }
            for (int i = 1; i < segments.length; ++i) {
                result2.add(segments[i]);
            }
        }
        return result2;
    }
}

