/*
 * Decompiled with CFR 0.152.
 */
package io.lacuna.artifex;

import io.lacuna.artifex.utils.Hashes;
import io.lacuna.artifex.utils.Scalars;
import java.util.function.DoubleUnaryOperator;

public class Interval {
    public static final Interval EMPTY = new Interval(Double.NaN, Double.NaN);
    public final double lo;
    public final double hi;

    public Interval(double a2, double b) {
        if (a2 < b) {
            this.lo = a2;
            this.hi = b;
        } else {
            this.lo = b;
            this.hi = a2;
        }
    }

    public static Interval interval(double a2, double b) {
        return new Interval(a2, b);
    }

    public boolean intersects(Interval i) {
        return this.hi > i.lo && i.hi > this.lo;
    }

    public boolean contains(double n) {
        return !this.isEmpty() && this.lo <= n && n <= this.hi;
    }

    public boolean contains(Interval i) {
        return !this.isEmpty() && this.contains(i.lo) && this.contains(i.hi);
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public Interval expand(double n) {
        return this.size() + n * 2.0 < 0.0 ? EMPTY : new Interval(this.lo - n, this.hi + n);
    }

    public Interval map(DoubleUnaryOperator f) {
        return new Interval(f.applyAsDouble(this.lo), f.applyAsDouble(this.hi));
    }

    public Interval add(Interval i) {
        return this.isEmpty() || i.isEmpty() ? EMPTY : new Interval(this.lo + i.lo, this.hi + i.hi);
    }

    public Interval sub(Interval i) {
        return this.isEmpty() || i.isEmpty() ? EMPTY : new Interval(this.lo - i.lo, this.hi - i.hi);
    }

    public Interval mul(Interval i) {
        return this.isEmpty() || i.isEmpty() ? EMPTY : new Interval(this.lo * this.hi, i.lo * i.hi).union(new Interval(this.lo * i.hi, i.lo * this.hi));
    }

    public Interval div(Interval i) {
        if (i.lo == 0.0 && i.hi == 0.0) {
            return new Interval(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        }
        if (i.lo == 0.0) {
            return this.mul(new Interval(1.0 / i.hi, Double.POSITIVE_INFINITY));
        }
        if (i.hi == 0.0) {
            return this.mul(new Interval(Double.NEGATIVE_INFINITY, 1.0 / i.lo));
        }
        return this.mul(new Interval(1.0 / i.hi, 1.0 / i.lo));
    }

    public Interval union(Interval i) {
        return this.isEmpty() ? i : new Interval(Math.min(this.lo, i.lo), Math.max(this.hi, i.hi));
    }

    public Interval union(double n) {
        return this.isEmpty() ? new Interval(n, n) : new Interval(Math.min(this.lo, n), Math.max(this.hi, n));
    }

    public Interval intersection(Interval i) {
        if (this.isEmpty() || i.isEmpty() || !this.intersects(i)) {
            return EMPTY;
        }
        return new Interval(Math.max(this.lo, i.lo), Math.min(this.hi, i.hi));
    }

    public double normalize(double n) {
        return n == this.hi ? 1.0 : (n - this.lo) / this.size();
    }

    public Interval normalize(Interval i) {
        return new Interval(this.normalize(i.lo), this.normalize(i.hi));
    }

    public double lerp(double t) {
        return t == 1.0 ? this.hi : Scalars.lerp(this.lo, this.hi, t);
    }

    public Interval lerp(Interval i) {
        return new Interval(this.lerp(i.lo), this.lerp(i.hi));
    }

    public double size() {
        return this.hi - this.lo;
    }

    public int hashCode() {
        return Hashes.hash(this.lo, this.hi);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Interval) {
            Interval o = (Interval)obj;
            return this.lo == o.lo && this.hi == o.hi;
        }
        return false;
    }

    public String toString() {
        return "[" + this.lo + ", " + this.hi + "]";
    }
}

