/*
 * Decompiled with CFR 0.152.
 */
package glm_.quat;

import glm_.ExtensionsKt;
import glm_.Primitive_extensionsKt;
import glm_.glm;
import glm_.mat3x3.Mat3;
import glm_.mat3x3.Mat3d;
import glm_.mat4x4.Mat4;
import glm_.mat4x4.Mat4d;
import glm_.quat.QuatD;
import glm_.quat.QuatT;
import glm_.quat.gtcQuaternion;
import glm_.quat.quat_operators;
import glm_.vec3.Vec3;
import glm_.vec3.Vec3d;
import glm_.vec4.Vec4;
import glm_.vec4.Vec4bool;
import glm_.vec4.Vec4t;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \\2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\\B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0007B\u0017\b\u0016\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0001\u00a2\u0006\u0002\u0010\tB\u0017\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u0002\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rB\u0017\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\f\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000fB\u001b\b\u0016\u0012\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00020\u0011\u00a2\u0006\u0002\u0010\u0013B\u000f\b\u0016\u0012\u0006\u0010\u0014\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0015B\u000f\b\u0016\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018B\u0019\b\u0016\u0012\u0006\u0010\u0019\u001a\u00020\u001a\u0012\b\b\u0002\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\u0002\u0010\u001dB\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u001e\u00a2\u0006\u0002\u0010\u001fB'\b\u0016\u0012\u0006\u0010 \u001a\u00020\b\u0012\u0006\u0010!\u001a\u00020\b\u0012\u0006\u0010\"\u001a\u00020\b\u0012\u0006\u0010#\u001a\u00020\b\u00a2\u0006\u0002\u0010$B\u0013\b\u0016\u0012\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030%\u00a2\u0006\u0002\u0010&B%\u0012\u0006\u0010 \u001a\u00020\u0002\u0012\u0006\u0010!\u001a\u00020\u0002\u0012\u0006\u0010\"\u001a\u00020\u0002\u0012\u0006\u0010#\u001a\u00020\u0002\u00a2\u0006\u0002\u0010'J\u0006\u0010(\u001a\u00020\u0002J\"\u0010)\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u00022\u0006\u0010*\u001a\u00020\f2\b\b\u0002\u0010+\u001a\u00020\u0000H\u0007J\u0016\u0010,\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u00022\u0006\u0010*\u001a\u00020\fJ\u0012\u0010-\u001a\u00020\u00002\b\b\u0002\u0010+\u001a\u00020\u0000H\u0007J\u0006\u0010.\u001a\u00020\u0000J\u0011\u0010/\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u0002H\u0086\u0006J\u0016\u0010/\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u00022\u0006\u0010+\u001a\u00020\u0000J\u0011\u00101\u001a\u0002022\u0006\u00100\u001a\u00020\u0002H\u0086\u0006J\u0011\u00103\u001a\u00020\u00022\u0006\u00100\u001a\u00020\u0000H\u0086\u0004J\u0013\u00104\u001a\u00020\u001c2\b\u00105\u001a\u0004\u0018\u000106H\u0096\u0002J\u0012\u00107\u001a\u00020\f2\b\b\u0002\u0010+\u001a\u00020\fH\u0007J\b\u00108\u001a\u00020\u0012H\u0016J\u0012\u00109\u001a\u00020\u00002\b\b\u0002\u0010+\u001a\u00020\u0000H\u0007J\u0006\u0010:\u001a\u00020\u0000J\u0006\u0010;\u001a\u00020\u0002J\u0011\u0010<\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u0000H\u0086\u0006J\u0016\u0010<\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0000J\u0011\u0010=\u001a\u0002022\u0006\u00100\u001a\u00020\u0000H\u0086\u0006J\u0012\u0010>\u001a\u00020\u00002\b\b\u0002\u0010+\u001a\u00020\u0000H\u0007J\u0006\u0010?\u001a\u00020\u0000J\u0011\u0010@\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u0000H\u0086\u0006J\u0016\u0010@\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0000J\u0011\u0010A\u001a\u0002022\u0006\u00100\u001a\u00020\u0000H\u0086\u0006J\u0010\u0010B\u001a\u0002022\b\b\u0002\u0010C\u001a\u00020DJ\u0010\u0010E\u001a\u0002022\b\b\u0002\u0010C\u001a\u00020DJ\u0011\u0010F\u001a\u00020\u00002\u0006\u0010G\u001a\u00020\u0000H\u0086\u0004J&\u0010F\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u00022\u0006\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u00022\u0006\u0010#\u001a\u00020\u0002J\u0019\u0010H\u001a\u0002022\u0006\u0010I\u001a\u00020\u00122\u0006\u0010J\u001a\u00020\bH\u0096\u0002J\"\u0010K\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u00002\u0006\u0010L\u001a\u00020\u00022\b\b\u0002\u0010+\u001a\u00020\u0000H\u0007J\u0016\u0010M\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u00002\u0006\u0010L\u001a\u00020\u0002J\u0011\u0010N\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u0000H\u0086\u0006J\u0016\u0010N\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0000J\u0011\u0010N\u001a\u00020\f2\u0006\u00100\u001a\u00020\fH\u0086\u0006J\u0016\u0010N\u001a\u00020\f2\u0006\u00100\u001a\u00020\f2\u0006\u0010+\u001a\u00020\fJ\u0011\u0010N\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u0017H\u0086\u0006J\u0016\u0010N\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u0000J\u0011\u0010N\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u0002H\u0086\u0006J\u0016\u0010N\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u00022\u0006\u0010+\u001a\u00020\u0000J\u0011\u0010O\u001a\u0002022\u0006\u00100\u001a\u00020\u0000H\u0086\u0006J\u0011\u0010O\u001a\u0002022\u0006\u00100\u001a\u00020\fH\u0086\u0006J\u0011\u0010O\u001a\u0002022\u0006\u00100\u001a\u00020\u0017H\u0086\u0006J\u0011\u0010O\u001a\u0002022\u0006\u00100\u001a\u00020\u0002H\u0086\u0006J\u0011\u0010P\u001a\u00020Q2\u0006\u0010+\u001a\u00020QH\u0086\u0004J\u0011\u0010P\u001a\u00020R2\u0006\u0010+\u001a\u00020RH\u0086\u0004J\u0015\u0010P\u001a\u0002022\n\u0010S\u001a\u00060Tj\u0002`UH\u0086\u0004J\u0006\u0010V\u001a\u00020QJ\u0006\u0010W\u001a\u00020RJ\b\u0010X\u001a\u00020DH\u0016J\t\u0010Y\u001a\u00020\u0000H\u0086\u0002J\t\u0010Z\u001a\u00020\u0000H\u0086\u0002J\u0012\u0010[\u001a\u0002022\b\b\u0002\u0010+\u001a\u00020\u0017H\u0007\u00a8\u0006]"}, d2={"Lglm_/quat/Quat;", "Lglm_/quat/QuatT;", "", "()V", "f", "(F)V", "q", "(Lglm_/quat/Quat;)V", "", "(Lglm_/quat/QuatT;)V", "s", "v", "Lglm_/vec3/Vec3;", "(FLglm_/vec3/Vec3;)V", "u", "(Lglm_/vec3/Vec3;Lglm_/vec3/Vec3;)V", "block", "Lkotlin/Function1;", "", "(Lkotlin/jvm/functions/Function1;)V", "eulerAngle", "(Lglm_/vec3/Vec3;)V", "vec4", "Lglm_/vec4/Vec4;", "(Lglm_/vec4/Vec4;)V", "inputStream", "Ljava/io/InputStream;", "bigEndian", "", "(Ljava/io/InputStream;Z)V", "Lglm_/quat/QuatD;", "(Lglm_/quat/QuatD;)V", "w", "x", "y", "z", "(Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;)V", "Lglm_/vec4/Vec4t;", "(Lglm_/vec4/Vec4t;)V", "(FFFF)V", "angle", "angleAxis", "axis", "res", "angleAxisAssign", "conjugate", "conjugateAssign", "div", "b", "divAssign", "", "dot", "equals", "other", "", "eulerAngles", "hashCode", "inverse", "inverseAssign", "length", "minus", "minusAssign", "normalize", "normalizeAssign", "plus", "plusAssign", "print", "name", "", "printErr", "put", "quat", "set", "index", "value", "slerp", "interp", "slerpAssign", "times", "timesAssign", "to", "Lglm_/mat3x3/Mat3;", "Lglm_/mat4x4/Mat4;", "ptr", "", "Lkool/Ptr;", "toMat3", "toMat4", "toString", "unaryMinus", "unaryPlus", "vectorize", "Companion", "glm"})
public final class Quat
extends QuatT<Float> {
    @JvmField
    public static final int size;
    public static final Companion Companion;

    @NotNull
    public final Mat3 to(@NotNull Mat3 res) {
        Intrinsics.checkParameterIsNotNull(res, "res");
        return glm.INSTANCE.mat3_cast(this, res);
    }

    @NotNull
    public final Mat3 toMat3() {
        return glm.INSTANCE.mat3_cast(this, new Mat3());
    }

    @NotNull
    public final Mat4 to(@NotNull Mat4 res) {
        Intrinsics.checkParameterIsNotNull(res, "res");
        return glm.INSTANCE.mat4_cast(this, res);
    }

    @NotNull
    public final Mat4 toMat4() {
        return glm.INSTANCE.mat4_cast(this, new Mat4());
    }

    @NotNull
    public final Quat put(float w, float x, float y, float z) {
        this.w = Float.valueOf(w);
        this.x = Float.valueOf(x);
        this.y = Float.valueOf(y);
        this.z = Float.valueOf(z);
        return this;
    }

    @NotNull
    public final Quat put(@NotNull Quat quat) {
        Intrinsics.checkParameterIsNotNull(quat, "quat");
        return this.put(quat.w.floatValue(), quat.x.floatValue(), quat.y.floatValue(), quat.z.floatValue());
    }

    public final void to(long ptr) {
        MemoryUtil.memPutFloat(ptr, this.w.floatValue());
        MemoryUtil.memPutFloat(ptr + (long)Primitive_extensionsKt.getBYTES(FloatCompanionObject.INSTANCE), this.x.floatValue());
        MemoryUtil.memPutFloat(ptr + (long)(Primitive_extensionsKt.getBYTES(FloatCompanionObject.INSTANCE) * 2), this.y.floatValue());
        MemoryUtil.memPutFloat(ptr + (long)(Primitive_extensionsKt.getBYTES(FloatCompanionObject.INSTANCE) * 3), this.z.floatValue());
    }

    @Override
    public void set(int index, @NotNull Number value2) {
        Intrinsics.checkParameterIsNotNull(value2, "value");
        switch (index) {
            case 0: {
                this.x = Float.valueOf(ExtensionsKt.getF(value2));
                break;
            }
            case 1: {
                this.y = Float.valueOf(ExtensionsKt.getF(value2));
                break;
            }
            case 2: {
                this.z = Float.valueOf(ExtensionsKt.getF(value2));
                break;
            }
            case 3: {
                this.w = Float.valueOf(ExtensionsKt.getF(value2));
                break;
            }
            default: {
                throw (Throwable)new ArrayIndexOutOfBoundsException();
            }
        }
    }

    @NotNull
    public final Quat unaryPlus() {
        return this;
    }

    @NotNull
    public final Quat unaryMinus() {
        return new Quat(-this.w.floatValue(), -this.x.floatValue(), -this.y.floatValue(), -this.z.floatValue());
    }

    @NotNull
    public final Quat plus(@NotNull Quat b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return Companion.plus(new Quat(), this, b);
    }

    @NotNull
    public final Quat plus(@NotNull Quat b, @NotNull Quat res) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        Intrinsics.checkParameterIsNotNull(res, "res");
        return Companion.plus(res, this, b);
    }

    public final void plusAssign(@NotNull Quat b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        Companion.plus(this, this, b);
    }

    @NotNull
    public final Quat minus(@NotNull Quat b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return Companion.minus(new Quat(), this, b);
    }

    @NotNull
    public final Quat minus(@NotNull Quat b, @NotNull Quat res) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        Intrinsics.checkParameterIsNotNull(res, "res");
        return Companion.minus(res, this, b);
    }

    public final void minusAssign(@NotNull Quat b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        Companion.minus(this, this, b);
    }

    @NotNull
    public final Quat times(@NotNull Quat b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return Companion.times(new Quat(), this, b);
    }

    @NotNull
    public final Quat times(float b) {
        return Companion.times(new Quat(), this, b);
    }

    @NotNull
    public final Vec3 times(@NotNull Vec3 b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return Companion.times(new Vec3(), this, b);
    }

    @NotNull
    public final Quat times(@NotNull Vec4 b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return Companion.times(new Quat(), this, b);
    }

    @NotNull
    public final Quat times(@NotNull Quat b, @NotNull Quat res) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        Intrinsics.checkParameterIsNotNull(res, "res");
        return Companion.times(res, this, b);
    }

    @NotNull
    public final Quat times(float b, @NotNull Quat res) {
        Intrinsics.checkParameterIsNotNull(res, "res");
        return Companion.times(res, this, b);
    }

    @NotNull
    public final Vec3 times(@NotNull Vec3 b, @NotNull Vec3 res) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        Intrinsics.checkParameterIsNotNull(res, "res");
        return Companion.times(res, this, b);
    }

    @NotNull
    public final Quat times(@NotNull Vec4 b, @NotNull Quat res) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        Intrinsics.checkParameterIsNotNull(res, "res");
        return Companion.times(res, this, b);
    }

    public final void timesAssign(@NotNull Quat b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        Companion.times(this, this, b);
    }

    public final void timesAssign(float b) {
        Companion.times(this, this, b);
    }

    public final void timesAssign(@NotNull Vec3 b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        Companion.times(b, this, b);
    }

    public final void timesAssign(@NotNull Vec4 b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        Companion.times(this, this, b);
    }

    @NotNull
    public final Quat div(float b) {
        return Companion.div(new Quat(), this, b);
    }

    @NotNull
    public final Quat div(float b, @NotNull Quat res) {
        Intrinsics.checkParameterIsNotNull(res, "res");
        return Companion.div(res, this, b);
    }

    public final void divAssign(float b) {
        Companion.div(this, this, b);
    }

    public final float length() {
        return glm.INSTANCE.length(this);
    }

    @JvmOverloads
    @NotNull
    public final Quat normalize(@NotNull Quat res) {
        Intrinsics.checkParameterIsNotNull(res, "res");
        return glm.INSTANCE.normalize(this, res);
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ Quat normalize$default(Quat quat, Quat quat2, int n, Object object) {
        if ((n & 1) != 0) {
            quat2 = new Quat();
        }
        return quat.normalize(quat2);
    }

    @JvmOverloads
    @NotNull
    public final Quat normalize() {
        return Quat.normalize$default(this, null, 1, null);
    }

    @NotNull
    public final Quat normalizeAssign() {
        return glm.INSTANCE.normalize(this, this);
    }

    public final float dot(@NotNull Quat b) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return glm.INSTANCE.dot(this, b);
    }

    @JvmOverloads
    @NotNull
    public final Quat angleAxis(float angle, @NotNull Vec3 axis, @NotNull Quat res) {
        Intrinsics.checkParameterIsNotNull(axis, "axis");
        Intrinsics.checkParameterIsNotNull(res, "res");
        return glm.INSTANCE.angleAxis(angle, axis, res);
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ Quat angleAxis$default(Quat quat, float f, Vec3 vec3, Quat quat2, int n, Object object) {
        if ((n & 4) != 0) {
            quat2 = new Quat();
        }
        return quat.angleAxis(f, vec3, quat2);
    }

    @JvmOverloads
    @NotNull
    public final Quat angleAxis(float angle, @NotNull Vec3 axis) {
        return Quat.angleAxis$default(this, angle, axis, null, 4, null);
    }

    @NotNull
    public final Quat angleAxisAssign(float angle, @NotNull Vec3 axis) {
        Intrinsics.checkParameterIsNotNull(axis, "axis");
        return glm.INSTANCE.angleAxis(angle, axis, this);
    }

    @JvmOverloads
    @NotNull
    public final Quat conjugate(@NotNull Quat res) {
        Intrinsics.checkParameterIsNotNull(res, "res");
        return glm.INSTANCE.conjugate(this, res);
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ Quat conjugate$default(Quat quat, Quat quat2, int n, Object object) {
        if ((n & 1) != 0) {
            quat2 = new Quat();
        }
        return quat.conjugate(quat2);
    }

    @JvmOverloads
    @NotNull
    public final Quat conjugate() {
        return Quat.conjugate$default(this, null, 1, null);
    }

    @NotNull
    public final Quat conjugateAssign() {
        return glm.INSTANCE.conjugate(this, this);
    }

    @JvmOverloads
    @NotNull
    public final Quat inverse(@NotNull Quat res) {
        Intrinsics.checkParameterIsNotNull(res, "res");
        return glm.INSTANCE.inverse(this, res);
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ Quat inverse$default(Quat quat, Quat quat2, int n, Object object) {
        if ((n & 1) != 0) {
            quat2 = new Quat();
        }
        return quat.inverse(quat2);
    }

    @JvmOverloads
    @NotNull
    public final Quat inverse() {
        return Quat.inverse$default(this, null, 1, null);
    }

    @NotNull
    public final Quat inverseAssign() {
        return glm.INSTANCE.inverse(this, this);
    }

    public final float angle() {
        return glm.INSTANCE.angle(this);
    }

    @JvmOverloads
    @NotNull
    public final Vec3 eulerAngles(@NotNull Vec3 res) {
        Intrinsics.checkParameterIsNotNull(res, "res");
        return glm.INSTANCE.eulerAngles(this, res);
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ Vec3 eulerAngles$default(Quat quat, Vec3 vec3, int n, Object object) {
        if ((n & 1) != 0) {
            vec3 = new Vec3();
        }
        return quat.eulerAngles(vec3);
    }

    @JvmOverloads
    @NotNull
    public final Vec3 eulerAngles() {
        return Quat.eulerAngles$default(this, null, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final Quat slerp(@NotNull Quat b, float interp, @NotNull Quat res) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        Intrinsics.checkParameterIsNotNull(res, "res");
        return glm.INSTANCE.slerp(this, b, interp, res);
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ Quat slerp$default(Quat quat, Quat quat2, float f, Quat quat3, int n, Object object) {
        if ((n & 4) != 0) {
            quat3 = new Quat();
        }
        return quat.slerp(quat2, f, quat3);
    }

    @JvmOverloads
    @NotNull
    public final Quat slerp(@NotNull Quat b, float interp) {
        return Quat.slerp$default(this, b, interp, null, 4, null);
    }

    @NotNull
    public final Quat slerpAssign(@NotNull Quat b, float interp) {
        Intrinsics.checkParameterIsNotNull(b, "b");
        return glm.INSTANCE.slerp(this, b, interp, this);
    }

    @JvmOverloads
    public final void vectorize(@NotNull Vec4 res) {
        Intrinsics.checkParameterIsNotNull(res, "res");
        res.put(this.x.floatValue(), this.y.floatValue(), this.z.floatValue(), this.w.floatValue());
    }

    @JvmOverloads
    public static /* synthetic */ void vectorize$default(Quat quat, Vec4 vec4, int n, Object object) {
        if ((n & 1) != 0) {
            vec4 = new Vec4();
        }
        quat.vectorize(vec4);
    }

    @JvmOverloads
    public final void vectorize() {
        Quat.vectorize$default(this, null, 1, null);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof Quat && ((Number)this.get(0)).floatValue() == ((Number)((Quat)other).get(0)).floatValue() && ((Number)this.get(1)).floatValue() == ((Number)((Quat)other).get(1)).floatValue() && ((Number)this.get(2)).floatValue() == ((Number)((Quat)other).get(2)).floatValue() && ((Number)this.get(3)).floatValue() == ((Number)((Quat)other).get(3)).floatValue();
    }

    public int hashCode() {
        return 31 * (31 * (31 * this.w.hashCode() + this.x.hashCode()) + this.y.hashCode()) + this.z.hashCode();
    }

    public final void printErr(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        System.err.println(name + " (" + this.w.floatValue() + ", {" + this.x.floatValue() + ", " + this.y.floatValue() + ", " + this.z.floatValue() + "})");
    }

    public static /* synthetic */ void printErr$default(Quat quat, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        quat.printErr(string);
    }

    public final void print(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        String string = name + " (" + this.w.floatValue() + ", {" + this.x.floatValue() + ", " + this.y.floatValue() + ", " + this.z.floatValue() + "})";
        System.out.println((Object)string);
    }

    public static /* synthetic */ void print$default(Quat quat, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        quat.print(string);
    }

    @NotNull
    public String toString() {
        return "Quat (" + this.w.floatValue() + ", {" + this.x.floatValue() + ", " + this.y.floatValue() + ", " + this.z.floatValue() + "})";
    }

    public Quat(float w, float x, float y, float z) {
        super((Number)Float.valueOf(w), (Number)Float.valueOf(x), (Number)Float.valueOf(y), (Number)Float.valueOf(z));
    }

    public Quat() {
        this(1.0f, 0.0f, 0.0f, 0.0f);
    }

    public Quat(float f) {
        this(f, f, f, f);
    }

    public Quat(@NotNull Quat q) {
        Intrinsics.checkParameterIsNotNull(q, "q");
        this(q.w.floatValue(), q.x.floatValue(), q.y.floatValue(), q.z.floatValue());
    }

    public Quat(@NotNull QuatT<? extends Number> q) {
        Intrinsics.checkParameterIsNotNull(q, "q");
        this((Number)q.w, (Number)q.x, (Number)q.y, (Number)q.z);
    }

    public Quat(float s2, @NotNull Vec3 v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        this(s2, v.getX().floatValue(), v.getY().floatValue(), v.getZ().floatValue());
    }

    public Quat(@NotNull Vec3 u, @NotNull Vec3 v) {
        Vec3 vec3;
        Intrinsics.checkParameterIsNotNull(u, "u");
        Intrinsics.checkParameterIsNotNull(v, "v");
        this();
        float f = u.dot(u) * v.dot(v);
        float normUnormV = (float)Math.sqrt(f);
        float realPart = normUnormV + u.dot(v);
        if (realPart < 1.0E-6f * normUnormV) {
            realPart = 0.0f;
            float f2 = u.getX().floatValue();
            float f3 = Math.abs(f2);
            float f4 = f3;
            f2 = u.getZ().floatValue();
            float f5 = Math.abs(f2);
            vec3 = f4 > f5 ? new Vec3(-u.getY().floatValue(), u.getX().floatValue(), 0.0f) : new Vec3(0.0f, -u.getZ().floatValue(), u.getY().floatValue());
        } else {
            vec3 = u.cross(v);
        }
        Vec3 w = vec3;
        this.put(realPart, w.getX().floatValue(), w.getY().floatValue(), w.getZ().floatValue()).normalizeAssign();
    }

    public Quat(@NotNull Function1<? super Integer, Float> block) {
        Intrinsics.checkParameterIsNotNull(block, "block");
        this(((Number)block.invoke((Integer)0)).floatValue(), ((Number)block.invoke((Integer)1)).floatValue(), ((Number)block.invoke((Integer)2)).floatValue(), ((Number)block.invoke((Integer)3)).floatValue());
    }

    public Quat(@NotNull Vec3 eulerAngle) {
        Intrinsics.checkParameterIsNotNull(eulerAngle, "eulerAngle");
        this();
        float eX = eulerAngle.getX().floatValue() * 0.5f;
        float eY = eulerAngle.getY().floatValue() * 0.5f;
        float eZ = eulerAngle.getZ().floatValue() * 0.5f;
        float cX = glm.INSTANCE.cos(eX);
        float cY = glm.INSTANCE.cos(eY);
        float cZ = glm.INSTANCE.cos(eZ);
        float sX = glm.INSTANCE.sin(eX);
        float sY = glm.INSTANCE.sin(eY);
        float sZ = glm.INSTANCE.sin(eZ);
        this.w = Float.valueOf(cX * cY * cZ + sX * sY * sZ);
        this.x = Float.valueOf(sX * cY * cZ - cX * sY * sZ);
        this.y = Float.valueOf(cX * sY * cZ + sX * cY * sZ);
        this.z = Float.valueOf(cX * cY * sZ - sX * sY * cZ);
    }

    public Quat(@NotNull Vec4 vec4) {
        Intrinsics.checkParameterIsNotNull(vec4, "vec4");
        this(vec4.getW().floatValue(), vec4.getX().floatValue(), vec4.getY().floatValue(), vec4.getZ().floatValue());
    }

    public Quat(@NotNull InputStream inputStream, boolean bigEndian) {
        Intrinsics.checkParameterIsNotNull(inputStream, "inputStream");
        this(ExtensionsKt.float(inputStream, bigEndian), ExtensionsKt.float(inputStream, bigEndian), ExtensionsKt.float(inputStream, bigEndian), ExtensionsKt.float(inputStream, bigEndian));
    }

    public /* synthetic */ Quat(InputStream inputStream, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(inputStream, bl);
    }

    public Quat(@NotNull QuatD q) {
        Intrinsics.checkParameterIsNotNull(q, "q");
        this(ExtensionsKt.getF(q.w), ExtensionsKt.getF(q.x), ExtensionsKt.getF(q.y), ExtensionsKt.getF(q.z));
    }

    public Quat(@NotNull Number w, @NotNull Number x, @NotNull Number y, @NotNull Number z) {
        Intrinsics.checkParameterIsNotNull(w, "w");
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(y, "y");
        Intrinsics.checkParameterIsNotNull(z, "z");
        this(ExtensionsKt.getF(w), ExtensionsKt.getF(x), ExtensionsKt.getF(y), ExtensionsKt.getF(z));
    }

    public Quat(@NotNull Vec4t<?> vec4) {
        Intrinsics.checkParameterIsNotNull(vec4, "vec4");
        this(ExtensionsKt.getF(vec4.getW()), ExtensionsKt.getF(vec4.getX()), ExtensionsKt.getF(vec4.getY()), ExtensionsKt.getF(vec4.getZ()));
    }

    static {
        Companion = new Companion(null);
        size = 4 * Primitive_extensionsKt.getBYTES(FloatCompanionObject.INSTANCE);
    }

    @JvmStatic
    @NotNull
    public static final Quat fromPointer(long ptr) {
        return Companion.fromPointer(ptr);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tj\u0002`\nH\u0007R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lglm_/quat/Quat$Companion;", "Lglm_/quat/quat_operators;", "Lglm_/quat/gtcQuaternion;", "()V", "size", "", "fromPointer", "Lglm_/quat/Quat;", "ptr", "", "Lkool/Ptr;", "glm"})
    public static final class Companion
    implements quat_operators,
    gtcQuaternion {
        @JvmStatic
        @NotNull
        public final Quat fromPointer(long ptr) {
            return new Quat(MemoryUtil.memGetFloat(ptr), MemoryUtil.memGetFloat(ptr + (long)Primitive_extensionsKt.getBYTES(FloatCompanionObject.INSTANCE)), MemoryUtil.memGetFloat(ptr + (long)(Primitive_extensionsKt.getBYTES(FloatCompanionObject.INSTANCE) * 2)), MemoryUtil.memGetFloat(ptr + (long)(Primitive_extensionsKt.getBYTES(FloatCompanionObject.INSTANCE) * 3)));
        }

        private Companion() {
        }

        @Override
        @NotNull
        public Quat plus(@NotNull Quat res, @NotNull Quat a2, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quat_operators.DefaultImpls.plus(this, res, a2, b);
        }

        @Override
        @NotNull
        public Quat minus(@NotNull Quat res, @NotNull Quat a2, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quat_operators.DefaultImpls.minus(this, res, a2, b);
        }

        @Override
        @NotNull
        public Quat times(@NotNull Quat res, @NotNull Quat a2, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quat_operators.DefaultImpls.times((quat_operators)this, res, a2, b);
        }

        @Override
        @NotNull
        public Quat times(@NotNull Quat res, @NotNull Quat a2, float b) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(a2, "a");
            return quat_operators.DefaultImpls.times((quat_operators)this, res, a2, b);
        }

        @Override
        @NotNull
        public Vec3 times(@NotNull Vec3 res, @NotNull Quat a2, @NotNull Vec3 b) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quat_operators.DefaultImpls.times((quat_operators)this, res, a2, b);
        }

        @Override
        @NotNull
        public Vec3 times(@NotNull Vec3 res, @NotNull Vec3 a2, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quat_operators.DefaultImpls.times((quat_operators)this, res, a2, b);
        }

        @Override
        @NotNull
        public Quat times(@NotNull Quat res, @NotNull Quat a2, @NotNull Vec4 b) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return quat_operators.DefaultImpls.times((quat_operators)this, res, a2, b);
        }

        @Override
        @NotNull
        public Quat div(@NotNull Quat res, @NotNull Quat a2, float b) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(a2, "a");
            return quat_operators.DefaultImpls.div(this, res, a2, b);
        }

        @Override
        public float length(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return gtcQuaternion.DefaultImpls.length((gtcQuaternion)this, q);
        }

        @Override
        public double length(@NotNull QuatD q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return gtcQuaternion.DefaultImpls.length((gtcQuaternion)this, q);
        }

        @Override
        @NotNull
        public Quat normalize(@NotNull Quat q, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.normalize((gtcQuaternion)this, q, res);
        }

        @Override
        @NotNull
        public Quat normalize(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return gtcQuaternion.DefaultImpls.normalize((gtcQuaternion)this, q);
        }

        @Override
        @NotNull
        public QuatD normalize(@NotNull QuatD q, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.normalize((gtcQuaternion)this, q, res);
        }

        @Override
        @NotNull
        public QuatD normalize(@NotNull QuatD q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return gtcQuaternion.DefaultImpls.normalize((gtcQuaternion)this, q);
        }

        @Override
        public float dot(@NotNull Quat a2, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return gtcQuaternion.DefaultImpls.dot((gtcQuaternion)this, a2, b);
        }

        @Override
        public double dot(@NotNull QuatD a2, @NotNull QuatD b) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return gtcQuaternion.DefaultImpls.dot((gtcQuaternion)this, a2, b);
        }

        @Override
        @NotNull
        public Quat mix(@NotNull Quat a2, @NotNull Quat b, float interp, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.mix((gtcQuaternion)this, a2, b, interp, res);
        }

        @Override
        @NotNull
        public Quat mix(@NotNull Quat a2, @NotNull Quat b, float interp) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return gtcQuaternion.DefaultImpls.mix((gtcQuaternion)this, a2, b, interp);
        }

        @Override
        @NotNull
        public QuatD mix(@NotNull QuatD a2, @NotNull QuatD b, double interp, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.mix((gtcQuaternion)this, a2, b, interp, res);
        }

        @Override
        @NotNull
        public QuatD mix(@NotNull QuatD a2, @NotNull QuatD b, double interp) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return gtcQuaternion.DefaultImpls.mix((gtcQuaternion)this, a2, b, interp);
        }

        @Override
        @NotNull
        public Quat lerp(@NotNull Quat a2, @NotNull Quat b, float interp, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.lerp((gtcQuaternion)this, a2, b, interp, res);
        }

        @Override
        @NotNull
        public Quat lerp(@NotNull Quat a2, @NotNull Quat b, float interp) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return gtcQuaternion.DefaultImpls.lerp((gtcQuaternion)this, a2, b, interp);
        }

        @Override
        @NotNull
        public QuatD lerp(@NotNull QuatD a2, @NotNull QuatD b, double interp, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.lerp((gtcQuaternion)this, a2, b, interp, res);
        }

        @Override
        @NotNull
        public QuatD lerp(@NotNull QuatD a2, @NotNull QuatD b, double interp) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return gtcQuaternion.DefaultImpls.lerp((gtcQuaternion)this, a2, b, interp);
        }

        @Override
        @NotNull
        public Quat slerp(@NotNull Quat a2, @NotNull Quat b, float interp, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.slerp((gtcQuaternion)this, a2, b, interp, res);
        }

        @Override
        @NotNull
        public Quat slerp(@NotNull Quat a2, @NotNull Quat b, float interp) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return gtcQuaternion.DefaultImpls.slerp((gtcQuaternion)this, a2, b, interp);
        }

        @Override
        @NotNull
        public QuatD slerp(@NotNull QuatD a2, @NotNull QuatD b, double interp, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.slerp((gtcQuaternion)this, a2, b, interp, res);
        }

        @Override
        @NotNull
        public QuatD slerp(@NotNull QuatD a2, @NotNull QuatD b, double interp) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return gtcQuaternion.DefaultImpls.slerp((gtcQuaternion)this, a2, b, interp);
        }

        @Override
        @NotNull
        public Quat conjugate(@NotNull Quat a2, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.conjugate((gtcQuaternion)this, a2, res);
        }

        @Override
        @NotNull
        public Quat conjugate(@NotNull Quat a2) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            return gtcQuaternion.DefaultImpls.conjugate((gtcQuaternion)this, a2);
        }

        @Override
        @NotNull
        public QuatD conjugate(@NotNull QuatD a2, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.conjugate((gtcQuaternion)this, a2, res);
        }

        @Override
        @NotNull
        public QuatD conjugate(@NotNull QuatD a2) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            return gtcQuaternion.DefaultImpls.conjugate((gtcQuaternion)this, a2);
        }

        @Override
        @NotNull
        public Quat inverse(@NotNull Quat a2, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.inverse((gtcQuaternion)this, a2, res);
        }

        @Override
        @NotNull
        public Quat inverse(@NotNull Quat a2) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            return gtcQuaternion.DefaultImpls.inverse((gtcQuaternion)this, a2);
        }

        @Override
        @NotNull
        public QuatD inverse(@NotNull QuatD a2, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.inverse((gtcQuaternion)this, a2, res);
        }

        @Override
        @NotNull
        public QuatD inverse(@NotNull QuatD a2) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            return gtcQuaternion.DefaultImpls.inverse((gtcQuaternion)this, a2);
        }

        @Override
        @NotNull
        public Quat rotate(@NotNull Quat q, float angle, float vX, float vY, float vZ, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.rotate((gtcQuaternion)this, q, angle, vX, vY, vZ, res);
        }

        @Override
        @NotNull
        public Quat rotate(@NotNull Quat q, float angle, float vX, float vY, float vZ) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return gtcQuaternion.DefaultImpls.rotate((gtcQuaternion)this, q, angle, vX, vY, vZ);
        }

        @Override
        @NotNull
        public Quat rotate(@NotNull Quat q, float angle, @NotNull Vec3 v, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(v, "v");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.rotate((gtcQuaternion)this, q, angle, v, res);
        }

        @Override
        @NotNull
        public Quat rotate(@NotNull Quat q, float angle, @NotNull Vec3 v) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(v, "v");
            return gtcQuaternion.DefaultImpls.rotate((gtcQuaternion)this, q, angle, v);
        }

        @Override
        @NotNull
        public QuatD rotate(@NotNull QuatD q, double angle, double vX, double vY, double vZ, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.rotate((gtcQuaternion)this, q, angle, vX, vY, vZ, res);
        }

        @Override
        @NotNull
        public QuatD rotate(@NotNull QuatD q, double angle, double vX, double vY, double vZ) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return gtcQuaternion.DefaultImpls.rotate((gtcQuaternion)this, q, angle, vX, vY, vZ);
        }

        @Override
        @NotNull
        public QuatD rotate(@NotNull QuatD q, double angle, @NotNull Vec3d v, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(v, "v");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.rotate((gtcQuaternion)this, q, angle, v, res);
        }

        @Override
        @NotNull
        public QuatD rotate(@NotNull QuatD q, double angle, @NotNull Vec3d v) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(v, "v");
            return gtcQuaternion.DefaultImpls.rotate((gtcQuaternion)this, q, angle, v);
        }

        @Override
        @NotNull
        public Vec3 eulerAngles(@NotNull Quat a2, @NotNull Vec3 res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.eulerAngles((gtcQuaternion)this, a2, res);
        }

        @Override
        @NotNull
        public Vec3 eulerAngles(@NotNull Quat a2) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            return gtcQuaternion.DefaultImpls.eulerAngles((gtcQuaternion)this, a2);
        }

        @Override
        @NotNull
        public Vec3d eulerAngles(@NotNull QuatD a2, @NotNull Vec3d res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.eulerAngles((gtcQuaternion)this, a2, res);
        }

        @Override
        @NotNull
        public Vec3d eulerAngles(@NotNull QuatD a2) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            return gtcQuaternion.DefaultImpls.eulerAngles((gtcQuaternion)this, a2);
        }

        @Override
        public float roll(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return gtcQuaternion.DefaultImpls.roll((gtcQuaternion)this, q);
        }

        @Override
        public double roll(@NotNull QuatD q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return gtcQuaternion.DefaultImpls.roll((gtcQuaternion)this, q);
        }

        @Override
        public float pitch(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return gtcQuaternion.DefaultImpls.pitch((gtcQuaternion)this, q);
        }

        @Override
        public double pitch(@NotNull QuatD q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return gtcQuaternion.DefaultImpls.pitch((gtcQuaternion)this, q);
        }

        @Override
        public float yaw(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return gtcQuaternion.DefaultImpls.yaw((gtcQuaternion)this, q);
        }

        @Override
        public double yaw(@NotNull QuatD q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return gtcQuaternion.DefaultImpls.yaw((gtcQuaternion)this, q);
        }

        @Override
        @NotNull
        public Mat3 mat3_cast(@NotNull Quat q, @NotNull Mat3 res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.mat3_cast(this, q, res);
        }

        @Override
        @NotNull
        public Mat3 mat3_cast(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return gtcQuaternion.DefaultImpls.mat3_cast(this, q);
        }

        @Override
        @NotNull
        public Mat3 mat3d_cast(@NotNull QuatD q, @NotNull Mat3 m) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(m, "m");
            return gtcQuaternion.DefaultImpls.mat3d_cast(this, q, m);
        }

        @Override
        @NotNull
        public Mat4 mat4_cast(@NotNull Quat q, @NotNull Mat4 res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.mat4_cast(this, q, res);
        }

        @Override
        @NotNull
        public Mat4 mat4_cast(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return gtcQuaternion.DefaultImpls.mat4_cast(this, q);
        }

        @Override
        @NotNull
        public Mat4 mat4d_cast(@NotNull Mat4 res, @NotNull QuatD q) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            Intrinsics.checkParameterIsNotNull(q, "q");
            return gtcQuaternion.DefaultImpls.mat4d_cast(this, res, q);
        }

        @Override
        @NotNull
        public Quat quat_cast(@NotNull Mat3 m, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.quat_cast((gtcQuaternion)this, m, res);
        }

        @Override
        @NotNull
        public Quat quat_cast(@NotNull Mat3 m) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            return gtcQuaternion.DefaultImpls.quat_cast((gtcQuaternion)this, m);
        }

        @Override
        @NotNull
        public Quat quat_cast(@NotNull Mat4 m, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.quat_cast((gtcQuaternion)this, m, res);
        }

        @Override
        @NotNull
        public Quat quat_cast(@NotNull Mat4 m) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            return gtcQuaternion.DefaultImpls.quat_cast((gtcQuaternion)this, m);
        }

        @Override
        @NotNull
        public Quat quat_cast(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.quat_cast(this, m00, m01, m02, m10, m11, m12, m20, m21, m22, res);
        }

        @Override
        @NotNull
        public Quat quat_cast(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
            return gtcQuaternion.DefaultImpls.quat_cast(this, m00, m01, m02, m10, m11, m12, m20, m21, m22);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(@NotNull Mat3d m, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.quatD_cast((gtcQuaternion)this, m, res);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(@NotNull Mat3d m) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            return gtcQuaternion.DefaultImpls.quatD_cast((gtcQuaternion)this, m);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(@NotNull Mat4d m, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.quatD_cast((gtcQuaternion)this, m, res);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(@NotNull Mat4d m) {
            Intrinsics.checkParameterIsNotNull(m, "m");
            return gtcQuaternion.DefaultImpls.quatD_cast((gtcQuaternion)this, m);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.quatD_cast(this, m00, m01, m02, m10, m11, m12, m20, m21, m22, res);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
            return gtcQuaternion.DefaultImpls.quatD_cast(this, m00, m01, m02, m10, m11, m12, m20, m21, m22);
        }

        @Override
        public float angle(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return gtcQuaternion.DefaultImpls.angle((gtcQuaternion)this, q);
        }

        @Override
        public double angle(@NotNull QuatD q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return gtcQuaternion.DefaultImpls.angle((gtcQuaternion)this, q);
        }

        @Override
        @NotNull
        public Vec3 axis(@NotNull Quat q, @NotNull Vec3 res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.axis((gtcQuaternion)this, q, res);
        }

        @Override
        @NotNull
        public Vec3 axis(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return gtcQuaternion.DefaultImpls.axis((gtcQuaternion)this, q);
        }

        @Override
        @NotNull
        public Vec3d axis(@NotNull QuatD q, @NotNull Vec3d res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.axis((gtcQuaternion)this, q, res);
        }

        @Override
        @NotNull
        public Vec3d axis(@NotNull QuatD q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return gtcQuaternion.DefaultImpls.axis((gtcQuaternion)this, q);
        }

        @Override
        @NotNull
        public Quat angleAxis(float angle, float axisX, float axisY, float axisZ, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.angleAxis((gtcQuaternion)this, angle, axisX, axisY, axisZ, res);
        }

        @Override
        @NotNull
        public Quat angleAxis(float angle, float axisX, float axisY, float axisZ) {
            return gtcQuaternion.DefaultImpls.angleAxis((gtcQuaternion)this, angle, axisX, axisY, axisZ);
        }

        @Override
        @NotNull
        public Quat angleAxis(float angle, @NotNull Vec3 axis, @NotNull Quat res) {
            Intrinsics.checkParameterIsNotNull(axis, "axis");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.angleAxis((gtcQuaternion)this, angle, axis, res);
        }

        @Override
        @NotNull
        public Quat angleAxis(float angle, @NotNull Vec3 axis) {
            Intrinsics.checkParameterIsNotNull(axis, "axis");
            return gtcQuaternion.DefaultImpls.angleAxis((gtcQuaternion)this, angle, axis);
        }

        @Override
        @NotNull
        public QuatD angleAxis(double angle, double axisX, double axisY, double axisZ, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.angleAxis((gtcQuaternion)this, angle, axisX, axisY, axisZ, res);
        }

        @Override
        @NotNull
        public QuatD angleAxis(double angle, double axisX, double axisY, double axisZ) {
            return gtcQuaternion.DefaultImpls.angleAxis((gtcQuaternion)this, angle, axisX, axisY, axisZ);
        }

        @Override
        @NotNull
        public QuatD angleAxis(double angle, @NotNull Vec3d axis, @NotNull QuatD res) {
            Intrinsics.checkParameterIsNotNull(axis, "axis");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.angleAxis((gtcQuaternion)this, angle, axis, res);
        }

        @Override
        @NotNull
        public QuatD angleAxis(double angle, @NotNull Vec3d axis) {
            Intrinsics.checkParameterIsNotNull(axis, "axis");
            return gtcQuaternion.DefaultImpls.angleAxis((gtcQuaternion)this, angle, axis);
        }

        @Override
        @NotNull
        public Vec4bool lessThan(@NotNull Quat a2, @NotNull Quat b, @NotNull Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.lessThan(this, a2, b, res);
        }

        @Override
        @NotNull
        public Vec4bool lessThan(@NotNull Quat a2, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return gtcQuaternion.DefaultImpls.lessThan(this, a2, b);
        }

        @Override
        @NotNull
        public Vec4bool lessThanEqual(@NotNull Quat a2, @NotNull Quat b, @NotNull Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.lessThanEqual(this, a2, b, res);
        }

        @Override
        @NotNull
        public Vec4bool lessThanEqual(@NotNull Quat a2, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return gtcQuaternion.DefaultImpls.lessThanEqual(this, a2, b);
        }

        @Override
        @NotNull
        public Vec4bool greater(@NotNull Quat a2, @NotNull Quat b, @NotNull Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.greater(this, a2, b, res);
        }

        @Override
        @NotNull
        public Vec4bool greater(@NotNull Quat a2, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return gtcQuaternion.DefaultImpls.greater(this, a2, b);
        }

        @Override
        @NotNull
        public Vec4bool greaterThan(@NotNull Quat a2, @NotNull Quat b, @NotNull Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.greaterThan(this, a2, b, res);
        }

        @Override
        @NotNull
        public Vec4bool greaterThan(@NotNull Quat a2, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return gtcQuaternion.DefaultImpls.greaterThan(this, a2, b);
        }

        @Override
        @NotNull
        public Vec4bool equal(@NotNull Quat a2, @NotNull Quat b, @NotNull Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.equal(this, a2, b, res);
        }

        @Override
        @NotNull
        public Vec4bool equal(@NotNull Quat a2, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return gtcQuaternion.DefaultImpls.equal(this, a2, b);
        }

        @Override
        @NotNull
        public Vec4bool notEqual(@NotNull Quat a2, @NotNull Quat b, @NotNull Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.notEqual(this, a2, b, res);
        }

        @Override
        @NotNull
        public Vec4bool notEqual(@NotNull Quat a2, @NotNull Quat b) {
            Intrinsics.checkParameterIsNotNull(a2, "a");
            Intrinsics.checkParameterIsNotNull(b, "b");
            return gtcQuaternion.DefaultImpls.notEqual(this, a2, b);
        }

        @Override
        @NotNull
        public Vec4bool isNan(@NotNull Quat q, @NotNull Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.isNan(this, q, res);
        }

        @Override
        @NotNull
        public Vec4bool isNan(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return gtcQuaternion.DefaultImpls.isNan(this, q);
        }

        @Override
        @NotNull
        public Vec4bool isInf(@NotNull Quat q, @NotNull Vec4bool res) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            Intrinsics.checkParameterIsNotNull(res, "res");
            return gtcQuaternion.DefaultImpls.isInf(this, q, res);
        }

        @Override
        @NotNull
        public Vec4bool isInf(@NotNull Quat q) {
            Intrinsics.checkParameterIsNotNull(q, "q");
            return gtcQuaternion.DefaultImpls.isInf(this, q);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

