/*
 * Decompiled with CFR 0.152.
 */
package scenes;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.shape.ShapeContour;
import scenes.Walker;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lscenes/PathWalker;", "Lscenes/Walker;", "path", "Lorg/openrndr/shape/ShapeContour;", "speed", "", "(Lorg/openrndr/shape/ShapeContour;D)V", "getPath", "()Lorg/openrndr/shape/ShapeContour;", "getSpeed", "()D", "updatePositionAndDirection", "", "time", "demo-strap"})
public final class PathWalker
extends Walker {
    @NotNull
    private final ShapeContour path;
    private final double speed;

    @Override
    public boolean updatePositionAndDirection(double time) {
        Vector2 p = this.path.position(this.speed * time / 150.0);
        Vector2 d = this.path.normal(this.speed * time / 150.0);
        Vector2 dp = d.getPerpendicular();
        this.setDirection(new Vector3(dp.getX(), 0.0, dp.getY()).getNormalized());
        this.setSmoothDirection(this.getSmoothDirection().times(0.99).plus(this.getDirection().times(0.01)));
        this.setX(p.getX());
        this.setZ(p.getY());
        if (!this.hasAnimations()) {
            this.animate("dummy", 1.0, (long)((double)250 / this.speed));
            return true;
        }
        return false;
    }

    @NotNull
    public final ShapeContour getPath() {
        return this.path;
    }

    public final double getSpeed() {
        return this.speed;
    }

    public PathWalker(@NotNull ShapeContour path, double speed) {
        Intrinsics.checkParameterIsNotNull(path, "path");
        this.path = path;
        this.speed = speed;
        this.updatePositionAndDirection(0.0);
    }

    public /* synthetic */ PathWalker(ShapeContour shapeContour, double d, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            d = 1.0;
        }
        this(shapeContour, d);
    }
}

