/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.BufferUtils;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.ColorBufferShadow;
import org.openrndr.draw.ColorFormat;
import org.openrndr.internal.gl3.BufferWriterGL3;
import org.openrndr.internal.gl3.ColorBufferGL3;
import org.openrndr.internal.gl3.ColorBufferGL3Kt;
import org.openrndr.internal.gl3.ColorBufferShadowGL3;
import org.openrndr.internal.gl3.ColorBufferShadowGL3$WhenMappings;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\fH\u0016J\b\u0010\u0018\u001a\u00020\u0012H\u0016J \u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0015H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lorg/openrndr/internal/gl3/ColorBufferShadowGL3;", "Lorg/openrndr/draw/ColorBufferShadow;", "colorBuffer", "Lorg/openrndr/internal/gl3/ColorBufferGL3;", "(Lorg/openrndr/internal/gl3/ColorBufferGL3;)V", "buffer", "Ljava/nio/ByteBuffer;", "getBuffer", "()Ljava/nio/ByteBuffer;", "getColorBuffer", "()Lorg/openrndr/internal/gl3/ColorBufferGL3;", "elementSize", "", "getElementSize", "()I", "size", "getSize", "destroy", "", "download", "read", "Lorg/openrndr/color/ColorRGBa;", "x", "y", "upload", "write", "color", "writer", "Lorg/openrndr/draw/BufferWriter;", "openrndr-gl3"})
public final class ColorBufferShadowGL3
implements ColorBufferShadow {
    private final int size;
    private final int elementSize;
    @NotNull
    private final ByteBuffer buffer;
    @NotNull
    private final ColorBufferGL3 colorBuffer;

    public final int getSize() {
        return this.size;
    }

    public final int getElementSize() {
        return this.elementSize;
    }

    @Override
    @NotNull
    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public void download() {
        ColorBufferGL3Kt.access$getLogger$p().debug(download.1.INSTANCE);
        this.getColorBuffer().read(this.getBuffer());
    }

    @Override
    public void upload() {
        this.getColorBuffer().write(this.getBuffer());
    }

    @Override
    public void destroy() {
        this.getColorBuffer().destroyShadow();
    }

    @Override
    public void write(int x, int y, @NotNull ColorRGBa color) {
        Intrinsics.checkParameterIsNotNull(color, "color");
        int ay = this.getColorBuffer().getFlipV() ? y : this.getColorBuffer().getEffectiveHeight() - 1 - y;
        int offset = (ay * this.getColorBuffer().getEffectiveWidth() + x) * this.getColorBuffer().getFormat().getComponentCount() * this.getColorBuffer().getType().getComponentSize();
        switch (ColorBufferShadowGL3$WhenMappings.$EnumSwitchMapping$0[this.getColorBuffer().getType().ordinal()]) {
            case 1: {
                byte ir = (byte)RangesKt.coerceIn(color.getR() * (double)255, 0.0, 255.0);
                byte ig = (byte)RangesKt.coerceIn(color.getG() * (double)255, 0.0, 255.0);
                byte ib = (byte)RangesKt.coerceIn(color.getB() * (double)255, 0.0, 255.0);
                byte ia = (byte)RangesKt.coerceIn(color.getA() * (double)255, 0.0, 255.0);
                this.getBuffer().put(offset, ir);
                this.getBuffer().put(offset + 1, ig);
                this.getBuffer().put(offset + 2, ib);
                if (this.getColorBuffer().getFormat().getComponentCount() <= 3) break;
                this.getBuffer().put(offset + 3, ia);
                break;
            }
            case 2: {
                char ir = (char)RangesKt.coerceIn(color.getR() * (double)65535, 0.0, 65535.0);
                char ig = (char)RangesKt.coerceIn(color.getG() * (double)65535, 0.0, 65535.0);
                char ib = (char)RangesKt.coerceIn(color.getB() * (double)65335, 0.0, 65535.0);
                char ia = (char)RangesKt.coerceIn(color.getA() * (double)65535, 0.0, 65535.0);
                this.getBuffer().putChar(offset, ir);
                this.getBuffer().putChar(offset + 2, ig);
                this.getBuffer().putChar(offset + 4, ib);
                if (this.getColorBuffer().getFormat().getComponentCount() <= 3) break;
                this.getBuffer().putChar(offset + 6, ia);
                break;
            }
            case 3: {
                this.getBuffer().putFloat(offset, (float)color.getR());
                this.getBuffer().putFloat(offset + 4, (float)color.getG());
                this.getBuffer().putFloat(offset + 8, (float)color.getB());
                if (this.getColorBuffer().getFormat().getComponentCount() <= 3) break;
                this.getBuffer().putFloat(offset + 12, (float)color.getA());
                break;
            }
            default: {
                String string = "support for " + (Object)((Object)this.getColorBuffer().getType());
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
            }
        }
    }

    @Override
    @NotNull
    public ColorRGBa read(int x, int y) {
        ColorRGBa colorRGBa;
        int ay = this.getColorBuffer().getFlipV() ? y : this.getColorBuffer().getEffectiveHeight() - 1 - y;
        int offset = (ay * this.getColorBuffer().getEffectiveWidth() + x) * this.getColorBuffer().getFormat().getComponentCount() * this.getColorBuffer().getType().getComponentSize();
        switch (ColorBufferShadowGL3$WhenMappings.$EnumSwitchMapping$1[this.getColorBuffer().getType().ordinal()]) {
            case 1: {
                int ir = this.getBuffer().get(offset) & 0xFF;
                int ig = this.getBuffer().get(offset + 1) & 0xFF;
                int ib = this.getBuffer().get(offset + 2) & 0xFF;
                int ia = Intrinsics.areEqual((Object)this.getColorBuffer().getFormat(), (Object)ColorFormat.RGBa) ? this.getBuffer().get(offset + 3) & 0xFF : 255;
                colorRGBa = new ColorRGBa((double)ir / 255.0, (double)ig / 255.0, (double)ib / 255.0, (double)ia / 255.0, null, 16, null);
                break;
            }
            case 2: {
                float fr = this.getBuffer().getFloat(offset);
                float fg = this.getBuffer().getFloat(offset + 4);
                float fb = this.getBuffer().getFloat(offset + 8);
                float fa = Intrinsics.areEqual((Object)this.getColorBuffer().getFormat(), (Object)ColorFormat.RGBa) ? this.getBuffer().getFloat(offset + 12) : 1.0f;
                colorRGBa = new ColorRGBa(fr, fg, fb, fa, null, 16, null);
                break;
            }
            default: {
                String string = "support for " + (Object)((Object)this.getColorBuffer().getType());
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
            }
        }
        return colorRGBa;
    }

    @Override
    @NotNull
    public BufferWriter writer() {
        return new BufferWriterGL3(this.getBuffer(), 0, 2, null);
    }

    @Override
    @NotNull
    public ColorBufferGL3 getColorBuffer() {
        return this.colorBuffer;
    }

    public ColorBufferShadowGL3(@NotNull ColorBufferGL3 colorBuffer) {
        Intrinsics.checkParameterIsNotNull(colorBuffer, "colorBuffer");
        this.colorBuffer = colorBuffer;
        this.size = this.getColorBuffer().getWidth() * this.getColorBuffer().getHeight();
        this.elementSize = this.getColorBuffer().getFormat().getComponentCount() * this.getColorBuffer().getType().getComponentSize();
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(this.elementSize * this.size);
        Intrinsics.checkExpressionValueIsNotNull(byteBuffer, "BufferUtils.createByteBuffer(elementSize * size)");
        this.buffer = byteBuffer;
    }
}

