/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.DrawContext;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.DrawStyle;
import org.openrndr.draw.ShadeStructure;
import org.openrndr.draw.ShadeStyleManager;
import org.openrndr.draw.Shader;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexElementType;
import org.openrndr.draw.VertexFormat;
import org.openrndr.internal.Driver;
import org.openrndr.internal.ShaderGenerators;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0012J$\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u0012J$\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0012R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lorg/openrndr/internal/PerformanceLineDrawer;", "", "()V", "shaderManager", "Lorg/openrndr/draw/ShadeStyleManager;", "getShaderManager", "()Lorg/openrndr/draw/ShadeStyleManager;", "vertices", "Lorg/openrndr/draw/VertexBuffer;", "getVertices", "()Lorg/openrndr/draw/VertexBuffer;", "drawLineLoops", "", "drawContext", "Lorg/openrndr/draw/DrawContext;", "drawStyle", "Lorg/openrndr/draw/DrawStyle;", "loops", "", "", "Lorg/openrndr/math/Vector2;", "drawLineSegments2", "segments", "drawLineSegments3", "Lorg/openrndr/math/Vector3;", "openrndr-core"})
public final class PerformanceLineDrawer {
    @NotNull
    private final VertexBuffer vertices;
    @NotNull
    private final ShadeStyleManager shaderManager;

    @NotNull
    public final VertexBuffer getVertices() {
        return this.vertices;
    }

    @NotNull
    public final ShadeStyleManager getShaderManager() {
        return this.shaderManager;
    }

    /*
     * WARNING - void declaration
     */
    public final void drawLineSegments3(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull Iterable<Vector3> segments) {
        Intrinsics.checkParameterIsNotNull(drawContext, "drawContext");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        Intrinsics.checkParameterIsNotNull(segments, "segments");
        Shader shader2 = this.shaderManager.shader(drawStyle.getShadeStyle(), this.vertices.getVertexFormat());
        shader2.begin();
        drawContext.applyToShader(shader2);
        drawStyle.applyToShader(shader2);
        BufferWriter w = this.vertices.getShadow().writer();
        w.rewind();
        int segmentCount = 0;
        Iterable<Vector3> $receiver$iv = segments;
        int index$iv = 0;
        for (Vector3 item$iv : $receiver$iv) {
            void it2;
            int n2 = index$iv++;
            Vector3 vector3 = item$iv;
            int index = n2;
            w.write((Vector3)it2);
            w.write(index / 2);
            w.write(index % 2);
            int n3 = segmentCount;
            segmentCount = n3 + 1;
        }
        this.vertices.getShadow().uploadElements(0, segmentCount);
        Driver.Companion.getInstance().setState(drawStyle);
        Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(this.vertices), DrawPrimitive.LINES, 0, 6);
        shader2.end();
    }

    /*
     * WARNING - void declaration
     */
    public final void drawLineSegments2(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull Iterable<Vector2> segments) {
        Intrinsics.checkParameterIsNotNull(drawContext, "drawContext");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        Intrinsics.checkParameterIsNotNull(segments, "segments");
        Shader shader2 = this.shaderManager.shader(drawStyle.getShadeStyle(), this.vertices.getVertexFormat());
        shader2.begin();
        drawContext.applyToShader(shader2);
        drawStyle.applyToShader(shader2);
        BufferWriter w = this.vertices.getShadow().writer();
        w.rewind();
        int segmentCount = 0;
        Iterable<Vector2> $receiver$iv = segments;
        int index$iv = 0;
        for (Vector2 item$iv : $receiver$iv) {
            void it2;
            int n2 = index$iv++;
            Vector2 vector2 = item$iv;
            int index = n2;
            w.write((Vector2)it2);
            w.write(0.0f);
            w.write(index / 2);
            w.write(index % 2);
            int n3 = segmentCount;
            segmentCount = n3 + 1;
        }
        this.vertices.getShadow().uploadElements(0, segmentCount);
        Driver.Companion.getInstance().setState(drawStyle);
        Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(this.vertices), DrawPrimitive.LINES, 0, 6);
        shader2.end();
    }

    /*
     * WARNING - void declaration
     */
    public final void drawLineLoops(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull Iterable<? extends List<Vector2>> loops) {
        Intrinsics.checkParameterIsNotNull(drawContext, "drawContext");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        Intrinsics.checkParameterIsNotNull(loops, "loops");
        Shader shader2 = this.shaderManager.shader(drawStyle.getShadeStyle(), this.vertices.getVertexFormat());
        shader2.begin();
        drawContext.applyToShader(shader2);
        drawStyle.applyToShader(shader2);
        BufferWriter w = this.vertices.getShadow().writer();
        w.rewind();
        int vertexCount = 0;
        Iterable<? extends List<Vector2>> $receiver$iv = loops;
        int index$iv = 0;
        for (List<Vector2> list : $receiver$iv) {
            void loop2;
            int n2 = index$iv++;
            List<Vector2> list2 = list;
            int loopIndex = n2;
            int n3 = 0;
            int n4 = loop2.size() - 1;
            while (n3 < n4) {
                void i;
                w.write((Vector2)loop2.get((int)i));
                w.write(0.0f);
                w.write(loopIndex);
                w.write(1.0f);
                w.write((Vector2)loop2.get((int)(i + true)));
                w.write(0.0f);
                w.write(loopIndex);
                w.write(1.0f);
                vertexCount += 2;
                ++i;
            }
        }
        this.vertices.getShadow().uploadElements(0, vertexCount);
        Driver.Companion.getInstance().setState(drawStyle);
        Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(this.vertices), DrawPrimitive.LINES, 0, vertexCount);
        shader2.end();
    }

    public PerformanceLineDrawer() {
        VertexFormat vertexFormat = new VertexFormat();
        VertexBuffer.Companion companion = VertexBuffer.Companion;
        PerformanceLineDrawer performanceLineDrawer = this;
        VertexFormat $receiver = vertexFormat;
        $receiver.position(3);
        $receiver.attribute("instance", 1, VertexElementType.FLOAT32);
        $receiver.attribute("vertexOffset", 1, VertexElementType.FLOAT32);
        VertexFormat vertexFormat2 = vertexFormat;
        performanceLineDrawer.vertices = companion.createDynamic(vertexFormat2, 0x100000);
        this.shaderManager = ShadeStyleManager.Companion.fromGenerators((Function1<? super ShadeStructure, String>)new Function1<ShadeStructure, String>(Driver.Companion.getInstance().getShaderGenerators()){

            @Override
            @NotNull
            public final String invoke(@NotNull ShadeStructure p1) {
                Intrinsics.checkParameterIsNotNull(p1, "p1");
                return ((ShaderGenerators)this.receiver).fastLineVertexShader(p1);
            }

            @Override
            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ShaderGenerators.class);
            }

            @Override
            public final String getName() {
                return "fastLineVertexShader";
            }

            @Override
            public final String getSignature() {
                return "fastLineVertexShader(Lorg/openrndr/draw/ShadeStructure;)Ljava/lang/String;";
            }
        }, (Function1<? super ShadeStructure, String>)new Function1<ShadeStructure, String>(Driver.Companion.getInstance().getShaderGenerators()){

            @Override
            @NotNull
            public final String invoke(@NotNull ShadeStructure p1) {
                Intrinsics.checkParameterIsNotNull(p1, "p1");
                return ((ShaderGenerators)this.receiver).fastLineFragmentShader(p1);
            }

            @Override
            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ShaderGenerators.class);
            }

            @Override
            public final String getName() {
                return "fastLineFragmentShader";
            }

            @Override
            public final String getSignature() {
                return "fastLineFragmentShader(Lorg/openrndr/draw/ShadeStructure;)Ljava/lang/String;";
            }
        });
    }
}

