/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.CullTestPass;
import org.openrndr.draw.DepthTestPass;
import org.openrndr.draw.DrawContext;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.DrawStyle;
import org.openrndr.draw.Drawer$WhenMappings;
import org.openrndr.draw.FontImageMap;
import org.openrndr.draw.FontMap;
import org.openrndr.draw.LineCap;
import org.openrndr.draw.LineJoin;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.ShadeStyle;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.internal.CircleDrawer;
import org.openrndr.internal.Driver;
import org.openrndr.internal.FontImageMapDrawer;
import org.openrndr.internal.ImageDrawer;
import org.openrndr.internal.PerformanceLineDrawer;
import org.openrndr.internal.QualityLineDrawer;
import org.openrndr.internal.QualityPolygonDrawer;
import org.openrndr.internal.RectangleDrawer;
import org.openrndr.internal.VertexBufferDrawer;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.transforms.TransformsKt;
import org.openrndr.shape.Color;
import org.openrndr.shape.Composition;
import org.openrndr.shape.CompositionColor;
import org.openrndr.shape.CompositionNode;
import org.openrndr.shape.GroupNode;
import org.openrndr.shape.LineSegment;
import org.openrndr.shape.Rectangle;
import org.openrndr.shape.Shape;
import org.openrndr.shape.ShapeContour;
import org.openrndr.shape.ShapeNode;
import org.openrndr.shape.TextNode;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00a2\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u007f\u001a\u00030\u0080\u00012\u0007\u0010\u0081\u0001\u001a\u00020.J\u001b\u0010\u0082\u0001\u001a\u00030\u0080\u00012\b\u0010\u0083\u0001\u001a\u00030\u0084\u00012\u0007\u0010\u0085\u0001\u001a\u00020oJ\"\u0010\u0086\u0001\u001a\u00030\u0080\u00012\u000f\u0010\u0087\u0001\u001a\n\u0012\u0005\u0012\u00030\u0084\u00010\u0088\u00012\u0007\u0010\u0085\u0001\u001a\u00020oJ)\u0010\u0086\u0001\u001a\u00030\u0080\u00012\u000f\u0010\u0087\u0001\u001a\n\u0012\u0005\u0012\u00030\u0084\u00010\u0088\u00012\u000e\u0010\u0089\u0001\u001a\t\u0012\u0004\u0012\u00020o0\u0088\u0001J\u0012\u0010\u008a\u0001\u001a\u00030\u0080\u00012\b\u0010\u008a\u0001\u001a\u00030\u008b\u0001J\u0012\u0010\u008c\u0001\u001a\u00030\u0080\u00012\b\u0010\u008c\u0001\u001a\u00030\u008d\u0001J\u0019\u0010\u008e\u0001\u001a\u00030\u0080\u00012\u000f\u0010\u008e\u0001\u001a\n\u0012\u0005\u0012\u00030\u008d\u00010\u0088\u0001J\u0012\u0010\u008f\u0001\u001a\u00030\u0080\u00012\b\u0010\u0090\u0001\u001a\u00030\u0091\u0001J$\u0010\u008f\u0001\u001a\u00030\u0080\u00012\b\u0010\u0090\u0001\u001a\u00030\u0091\u00012\u0007\u0010\u0092\u0001\u001a\u00020o2\u0007\u0010\u0093\u0001\u001a\u00020oJ$\u0010\u008f\u0001\u001a\u00030\u0080\u00012\b\u0010\u0090\u0001\u001a\u00030\u0091\u00012\u0007\u0010\u0094\u0001\u001a\u00020\u00062\u0007\u0010\u0095\u0001\u001a\u00020\u0006J\u0019\u0010\u0096\u0001\u001a\u00030\u0080\u00012\u000f\u0010\u0097\u0001\u001a\n\u0012\u0005\u0012\u00030\u0084\u00010\u0088\u0001J \u0010\u0098\u0001\u001a\u00030\u0080\u00012\u0016\u0010\u0099\u0001\u001a\u0011\u0012\f\u0012\n\u0012\u0005\u0012\u00030\u0084\u00010\u0088\u00010\u0088\u0001J,\u0010\u009a\u0001\u001a\u00030\u0080\u00012\u0007\u0010\u009b\u0001\u001a\u00020o2\u0007\u0010\u009c\u0001\u001a\u00020o2\u0007\u0010\u009d\u0001\u001a\u00020o2\u0007\u0010\u009e\u0001\u001a\u00020oJ\u001c\u0010\u009a\u0001\u001a\u00030\u0080\u00012\b\u0010\u009f\u0001\u001a\u00030\u0084\u00012\b\u0010\u00a0\u0001\u001a\u00030\u0084\u0001J\u001c\u0010\u009a\u0001\u001a\u00030\u0080\u00012\b\u0010\u009f\u0001\u001a\u00030\u00a1\u00012\b\u0010\u00a0\u0001\u001a\u00030\u00a1\u0001J\u0012\u0010\u009a\u0001\u001a\u00030\u0080\u00012\b\u0010\u009a\u0001\u001a\u00030\u00a2\u0001J\u0019\u0010\u00a3\u0001\u001a\u00030\u0080\u00012\u000f\u0010\u00a4\u0001\u001a\n\u0012\u0005\u0012\u00030\u0084\u00010\u0088\u0001J\u0019\u0010\u00a5\u0001\u001a\u00030\u0080\u00012\u000f\u0010\u00a4\u0001\u001a\n\u0012\u0005\u0012\u00030\u00a1\u00010\u0088\u0001J\u0019\u0010\u00a6\u0001\u001a\u00030\u0080\u00012\u000f\u0010\u0097\u0001\u001a\n\u0012\u0005\u0012\u00030\u0084\u00010\u0088\u0001J \u0010\u00a7\u0001\u001a\u00030\u0080\u00012\u0016\u0010\u00a8\u0001\u001a\u0011\u0012\f\u0012\n\u0012\u0005\u0012\u00030\u0084\u00010\u0088\u00010\u0088\u0001J(\u0010\u00a9\u0001\u001a\u00030\u0080\u00012\b\u0010\u00aa\u0001\u001a\u00030\u00a1\u00012\b\u0010\u00ab\u0001\u001a\u00030\u00a1\u00012\n\b\u0002\u0010\u00ac\u0001\u001a\u00030\u00a1\u0001J\b\u0010\u00ad\u0001\u001a\u00030\u0080\u0001J>\u0010\u00ad\u0001\u001a\u00030\u0080\u00012\u0007\u0010\u00ae\u0001\u001a\u00020o2\u0007\u0010\u00af\u0001\u001a\u00020o2\u0007\u0010\u00b0\u0001\u001a\u00020o2\u0007\u0010\u00b1\u0001\u001a\u00020o2\u0007\u0010\u00b2\u0001\u001a\u00020o2\u0007\u0010\u00b3\u0001\u001a\u00020oJ\u0012\u0010\u00ad\u0001\u001a\u00030\u0080\u00012\b\u0010\u00b4\u0001\u001a\u00030\u00b5\u0001J,\u0010\u00b6\u0001\u001a\u00030\u0080\u00012\u0007\u0010\u00b7\u0001\u001a\u00020o2\u0007\u0010\u00b8\u0001\u001a\u00020o2\u0007\u0010\u00b9\u0001\u001a\u00020o2\u0007\u0010\u00ba\u0001\u001a\u00020oJ\b\u0010\u00bb\u0001\u001a\u00030\u0080\u0001J\b\u0010\u00bc\u0001\u001a\u00030\u0080\u0001J\b\u0010\u00bd\u0001\u001a\u00030\u0080\u0001J\b\u0010\u00be\u0001\u001a\u00030\u0080\u0001J\b\u0010\u00bf\u0001\u001a\u00030\u0080\u0001J\u0007\u0010\u00c0\u0001\u001a\u00020SJ\u0007\u0010\u00c1\u0001\u001a\u00020SJ\u0007\u0010\u00c2\u0001\u001a\u00020#J\b\u0010\u00c3\u0001\u001a\u00030\u0080\u0001J\u0007\u0010\u00c4\u0001\u001a\u00020SJ*\u0010\u00c5\u0001\u001a\u00030\u0080\u00012\u0007\u0010\u0092\u0001\u001a\u00020o2\u0007\u0010\u0093\u0001\u001a\u00020o2\u0006\u0010|\u001a\u00020o2\u0006\u0010>\u001a\u00020oJ)\u0010\u00c6\u0001\u001a\u00030\u0080\u00012\u000f\u0010\u0087\u0001\u001a\n\u0012\u0005\u0012\u00030\u0084\u00010\u0088\u00012\u0006\u0010|\u001a\u00020o2\u0006\u0010>\u001a\u00020oJ*\u0010\u00c6\u0001\u001a\u00030\u0080\u00012\u000f\u0010\u0087\u0001\u001a\n\u0012\u0005\u0012\u00030\u0084\u00010\u0088\u00012\u000f\u0010\u00c7\u0001\u001a\n\u0012\u0005\u0012\u00030\u0084\u00010\u0088\u0001J\b\u0010\u00c8\u0001\u001a\u00030\u0080\u0001J\u0011\u0010\u00c9\u0001\u001a\u00030\u0080\u00012\u0007\u0010\u00ca\u0001\u001a\u00020oJ\u001b\u0010\u00c9\u0001\u001a\u00030\u0080\u00012\b\u0010\u00cb\u0001\u001a\u00030\u00a1\u00012\u0007\u0010\u00ca\u0001\u001a\u00020oJ\u0011\u0010\u00cc\u0001\u001a\u00030\u0080\u00012\u0007\u0010\u00cd\u0001\u001a\u00020oJ\u001a\u0010\u00cc\u0001\u001a\u00030\u0080\u00012\u0007\u0010\u0092\u0001\u001a\u00020o2\u0007\u0010\u0093\u0001\u001a\u00020oJ#\u0010\u00cc\u0001\u001a\u00030\u0080\u00012\u0007\u0010\u0092\u0001\u001a\u00020o2\u0007\u0010\u0093\u0001\u001a\u00020o2\u0007\u0010\u00ce\u0001\u001a\u00020oJ\u0012\u0010\u00cf\u0001\u001a\u00030\u0080\u00012\b\u0010\u00cf\u0001\u001a\u00030\u00d0\u0001J\u0018\u0010\u00d1\u0001\u001a\u00030\u0080\u00012\u0006\u0010|\u001a\u00020?2\u0006\u0010>\u001a\u00020?J$\u0010\u00d2\u0001\u001a\u00030\u0080\u00012\b\u0010\u00d2\u0001\u001a\u00030\u00d3\u00012\u0007\u0010\u0092\u0001\u001a\u00020o2\u0007\u0010\u0093\u0001\u001a\u00020oJ\u001a\u0010\u00d4\u0001\u001a\u00030\u0080\u00012\u0007\u0010\u0092\u0001\u001a\u00020o2\u0007\u0010\u0093\u0001\u001a\u00020oJ#\u0010\u00d4\u0001\u001a\u00030\u0080\u00012\u0007\u0010\u0092\u0001\u001a\u00020o2\u0007\u0010\u0093\u0001\u001a\u00020o2\u0007\u0010\u00ce\u0001\u001a\u00020oJ\u0012\u0010\u00d4\u0001\u001a\u00030\u0080\u00012\b\u0010\u00d5\u0001\u001a\u00030\u0084\u0001J\u0012\u0010\u00d4\u0001\u001a\u00030\u0080\u00012\b\u0010\u00d5\u0001\u001a\u00030\u00a1\u0001J9\u0010\u00d6\u0001\u001a\u00030\u0080\u00012\u000f\u0010\u00d7\u0001\u001a\n\u0012\u0005\u0012\u00030\u00d8\u00010\u0088\u00012\b\u0010\u00d9\u0001\u001a\u00030\u00da\u00012\t\b\u0002\u0010\u00db\u0001\u001a\u00020?2\t\b\u0002\u0010\u00dc\u0001\u001a\u00020?J2\u0010\u00d6\u0001\u001a\u00030\u0080\u00012\b\u0010\u00d6\u0001\u001a\u00030\u00d8\u00012\b\u0010\u00d9\u0001\u001a\u00030\u00da\u00012\t\b\u0002\u0010\u00dd\u0001\u001a\u00020?2\t\b\u0002\u0010\u00dc\u0001\u001a\u00020?JS\u0010\u00de\u0001\u001a\u00030\u0080\u00012\u000f\u0010\u00d7\u0001\u001a\n\u0012\u0005\u0012\u00030\u00d8\u00010\u0088\u00012\u000f\u0010\u00df\u0001\u001a\n\u0012\u0005\u0012\u00030\u00d8\u00010\u0088\u00012\b\u0010\u00d9\u0001\u001a\u00030\u00da\u00012\u0007\u0010\u00e0\u0001\u001a\u00020?2\t\b\u0002\u0010\u00db\u0001\u001a\u00020?2\t\b\u0002\u0010\u00dc\u0001\u001a\u00020?J/\u0010\u00e1\u0001\u001a\u00030\u0080\u00012\b\u0010\u0095\u0001\u001a\u00030\u00b5\u00012\u001b\u0010\u00e2\u0001\u001a\u0016\u0012\u0004\u0012\u00020\u0000\u0012\u0005\u0012\u00030\u0080\u00010\u00e3\u0001\u00a2\u0006\u0003\b\u00e4\u0001R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR$\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00108F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R$\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00168F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR$\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u001c8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020#0)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u000e\u0010,\u001a\u00020-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010/\u001a\u0004\u0018\u00010.2\b\u0010\u000f\u001a\u0004\u0018\u00010.8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u0014\u00104\u001a\u000205X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R(\u00109\u001a\u0004\u0018\u0001082\b\u0010\u000f\u001a\u0004\u0018\u0001088F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u001a\u0010>\u001a\u00020?X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR\u000e\u0010D\u001a\u00020EX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010G\u001a\u00020F2\u0006\u0010\u000f\u001a\u00020F8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bH\u0010I\"\u0004\bJ\u0010KR$\u0010M\u001a\u00020L2\u0006\u0010\u000f\u001a\u00020L8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bN\u0010O\"\u0004\bP\u0010QR\u001a\u0010R\u001a\u00020SX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u0010U\"\u0004\bV\u0010WR\u0017\u0010X\u001a\b\u0012\u0004\u0012\u00020S0)\u00a2\u0006\b\n\u0000\u001a\u0004\bY\u0010ZR\u001a\u0010[\u001a\u00020SX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\\\u0010U\"\u0004\b]\u0010WR\u0017\u0010^\u001a\b\u0012\u0004\u0012\u00020S0)\u00a2\u0006\b\n\u0000\u001a\u0004\b_\u0010ZR\u000e\u0010`\u001a\u00020aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010b\u001a\u00020cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010d\u001a\u00020eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010g\u001a\u0004\u0018\u00010f2\b\u0010\u000f\u001a\u0004\u0018\u00010f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bh\u0010i\"\u0004\bj\u0010kR(\u0010l\u001a\u0004\u0018\u00010.2\b\u0010\u000f\u001a\u0004\u0018\u00010.8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bm\u00101\"\u0004\bn\u00103R$\u0010p\u001a\u00020o2\u0006\u0010\u000f\u001a\u00020o8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bq\u0010r\"\u0004\bs\u0010tR\u000e\u0010u\u001a\u00020vX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010w\u001a\u00020SX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bx\u0010U\"\u0004\by\u0010WR\u0017\u0010z\u001a\b\u0012\u0004\u0012\u00020S0)\u00a2\u0006\b\n\u0000\u001a\u0004\b{\u0010ZR\u001a\u0010|\u001a\u00020?X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b}\u0010A\"\u0004\b~\u0010C\u00a8\u0006\u00e5\u0001"}, d2={"Lorg/openrndr/draw/Drawer;", "", "driver", "Lorg/openrndr/internal/Driver;", "(Lorg/openrndr/internal/Driver;)V", "bounds", "Lorg/openrndr/shape/Rectangle;", "getBounds", "()Lorg/openrndr/shape/Rectangle;", "circleDrawer", "Lorg/openrndr/internal/CircleDrawer;", "context", "Lorg/openrndr/draw/DrawContext;", "getContext", "()Lorg/openrndr/draw/DrawContext;", "value", "Lorg/openrndr/draw/CullTestPass;", "cullTestPass", "getCullTestPass", "()Lorg/openrndr/draw/CullTestPass;", "setCullTestPass", "(Lorg/openrndr/draw/CullTestPass;)V", "Lorg/openrndr/draw/DepthTestPass;", "depthTestPass", "getDepthTestPass", "()Lorg/openrndr/draw/DepthTestPass;", "setDepthTestPass", "(Lorg/openrndr/draw/DepthTestPass;)V", "", "depthWrite", "getDepthWrite", "()Z", "setDepthWrite", "(Z)V", "drawStyle", "Lorg/openrndr/draw/DrawStyle;", "getDrawStyle", "()Lorg/openrndr/draw/DrawStyle;", "setDrawStyle", "(Lorg/openrndr/draw/DrawStyle;)V", "drawStyles", "Ljava/util/Stack;", "getDriver", "()Lorg/openrndr/internal/Driver;", "fastLineDrawer", "Lorg/openrndr/internal/PerformanceLineDrawer;", "Lorg/openrndr/color/ColorRGBa;", "fill", "getFill", "()Lorg/openrndr/color/ColorRGBa;", "setFill", "(Lorg/openrndr/color/ColorRGBa;)V", "fontImageMapDrawer", "Lorg/openrndr/internal/FontImageMapDrawer;", "getFontImageMapDrawer$openrndr_core", "()Lorg/openrndr/internal/FontImageMapDrawer;", "Lorg/openrndr/draw/FontMap;", "fontMap", "getFontMap", "()Lorg/openrndr/draw/FontMap;", "setFontMap", "(Lorg/openrndr/draw/FontMap;)V", "height", "", "getHeight", "()I", "setHeight", "(I)V", "imageDrawer", "Lorg/openrndr/internal/ImageDrawer;", "Lorg/openrndr/draw/LineCap;", "lineCap", "getLineCap", "()Lorg/openrndr/draw/LineCap;", "setLineCap", "(Lorg/openrndr/draw/LineCap;)V", "Lorg/openrndr/draw/LineJoin;", "lineJoin", "getLineJoin", "()Lorg/openrndr/draw/LineJoin;", "setLineJoin", "(Lorg/openrndr/draw/LineJoin;)V", "model", "Lorg/openrndr/math/Matrix44;", "getModel", "()Lorg/openrndr/math/Matrix44;", "setModel", "(Lorg/openrndr/math/Matrix44;)V", "modelStack", "getModelStack", "()Ljava/util/Stack;", "projection", "getProjection", "setProjection", "projectionStack", "getProjectionStack", "qualityLineDrawer", "Lorg/openrndr/internal/QualityLineDrawer;", "qualityPolygonDrawer", "Lorg/openrndr/internal/QualityPolygonDrawer;", "rectangleDrawer", "Lorg/openrndr/internal/RectangleDrawer;", "Lorg/openrndr/draw/ShadeStyle;", "shadeStyle", "getShadeStyle", "()Lorg/openrndr/draw/ShadeStyle;", "setShadeStyle", "(Lorg/openrndr/draw/ShadeStyle;)V", "stroke", "getStroke", "setStroke", "", "strokeWeight", "getStrokeWeight", "()D", "setStrokeWeight", "(D)V", "vertexBufferDrawer", "Lorg/openrndr/internal/VertexBufferDrawer;", "view", "getView", "setView", "viewStack", "getViewStack", "width", "getWidth", "setWidth", "background", "", "color", "circle", "position", "Lorg/openrndr/math/Vector2;", "radius", "circles", "positions", "", "radii", "composition", "Lorg/openrndr/shape/Composition;", "contour", "Lorg/openrndr/shape/ShapeContour;", "contours", "image", "colorBuffer", "Lorg/openrndr/draw/ColorBuffer;", "x", "y", "source", "target", "lineLoop", "points", "lineLoops", "loops", "lineSegment", "x0", "y0", "x1", "y1", "start", "end", "Lorg/openrndr/math/Vector3;", "Lorg/openrndr/shape/LineSegment;", "lineSegments", "segments", "lineSegments3d", "lineStrip", "lineStrips", "strips", "lookAt", "from", "to", "up", "ortho", "left", "right", "bottom", "top", "near", "far", "renderTarget", "Lorg/openrndr/draw/RenderTarget;", "perspective", "fovY", "aspectRatio", "zNear", "zFar", "popModel", "popProjection", "popStyle", "popTransforms", "popView", "pushModel", "pushProjection", "pushStyle", "pushTransforms", "pushView", "rectangle", "rectangles", "dimensions", "reset", "rotate", "rotationInDegrees", "axis", "scale", "s", "z", "shape", "Lorg/openrndr/shape/Shape;", "size", "text", "", "translate", "t", "vertexBuffer", "vertexBuffers", "Lorg/openrndr/draw/VertexBuffer;", "primitive", "Lorg/openrndr/draw/DrawPrimitive;", "offset", "vertexCount", "vertexOffset", "vertexBufferInstances", "instanceAttributes", "instanceCount", "withTarget", "action", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "openrndr-core"})
public final class Drawer {
    private final Stack<DrawStyle> drawStyles;
    private RectangleDrawer rectangleDrawer;
    private VertexBufferDrawer vertexBufferDrawer;
    private CircleDrawer circleDrawer;
    private ImageDrawer imageDrawer;
    private PerformanceLineDrawer fastLineDrawer;
    private QualityLineDrawer qualityLineDrawer;
    private QualityPolygonDrawer qualityPolygonDrawer;
    @NotNull
    private final FontImageMapDrawer fontImageMapDrawer;
    @NotNull
    private final Stack<Matrix44> modelStack;
    @NotNull
    private final Stack<Matrix44> viewStack;
    @NotNull
    private final Stack<Matrix44> projectionStack;
    private int width;
    private int height;
    @NotNull
    private Matrix44 model;
    @NotNull
    private Matrix44 view;
    @NotNull
    private Matrix44 projection;
    @NotNull
    private DrawStyle drawStyle;
    @NotNull
    private final Driver driver;

    @NotNull
    public final Rectangle getBounds() {
        return new Rectangle(new Vector2(0.0, 0.0), (double)this.width * 1.0, (double)this.height * 1.0);
    }

    @NotNull
    public final FontImageMapDrawer getFontImageMapDrawer$openrndr_core() {
        return this.fontImageMapDrawer;
    }

    @NotNull
    public final Stack<Matrix44> getModelStack() {
        return this.modelStack;
    }

    @NotNull
    public final Stack<Matrix44> getViewStack() {
        return this.viewStack;
    }

    @NotNull
    public final Stack<Matrix44> getProjectionStack() {
        return this.projectionStack;
    }

    public final int getWidth() {
        return this.width;
    }

    public final void setWidth(int n2) {
        this.width = n2;
    }

    public final int getHeight() {
        return this.height;
    }

    public final void setHeight(int n2) {
        this.height = n2;
    }

    @NotNull
    public final Matrix44 getModel() {
        return this.model;
    }

    public final void setModel(@NotNull Matrix44 matrix44) {
        Intrinsics.checkParameterIsNotNull(matrix44, "<set-?>");
        this.model = matrix44;
    }

    @NotNull
    public final Matrix44 getView() {
        return this.view;
    }

    public final void setView(@NotNull Matrix44 matrix44) {
        Intrinsics.checkParameterIsNotNull(matrix44, "<set-?>");
        this.view = matrix44;
    }

    @NotNull
    public final Matrix44 getProjection() {
        return this.projection;
    }

    public final void setProjection(@NotNull Matrix44 matrix44) {
        Intrinsics.checkParameterIsNotNull(matrix44, "<set-?>");
        this.projection = matrix44;
    }

    @NotNull
    public final DrawContext getContext() {
        return new DrawContext(this.model, this.view, this.projection, this.width, this.height);
    }

    @NotNull
    public final DrawStyle getDrawStyle() {
        return this.drawStyle;
    }

    public final void setDrawStyle(@NotNull DrawStyle drawStyle) {
        Intrinsics.checkParameterIsNotNull(drawStyle, "<set-?>");
        this.drawStyle = drawStyle;
    }

    public final void withTarget(@NotNull RenderTarget target, @NotNull Function1<? super Drawer, Unit> action) {
        Intrinsics.checkParameterIsNotNull(target, "target");
        Intrinsics.checkParameterIsNotNull(action, "action");
        target.bind();
        action.invoke(this);
        target.unbind();
    }

    public final void reset() {
        this.viewStack.clear();
        this.modelStack.clear();
        this.projectionStack.clear();
        this.drawStyles.clear();
        this.ortho();
        this.drawStyle = new DrawStyle(null, null, null, null, 0.0, false, null, null, false, null, null, null, null, null, null, null, null, null, 262143, null);
        this.view = Matrix44.Companion.getIDENTITY();
        this.model = Matrix44.Companion.getIDENTITY();
    }

    public final void ortho(@NotNull RenderTarget renderTarget) {
        Intrinsics.checkParameterIsNotNull(renderTarget, "renderTarget");
        this.ortho(0.0, renderTarget.getWidth(), renderTarget.getHeight(), 0.0, -1.0, 1.0);
    }

    public final void ortho() {
        this.ortho(0.0, this.width, this.height, 0.0, -1.0, 1.0);
    }

    public final void ortho(double left, double right, double bottom, double top, double near, double far) {
        this.projection = TransformsKt.ortho(left, right, bottom, top, near, far);
    }

    public final void perspective(double fovY, double aspectRatio, double zNear, double zFar) {
        this.projection = TransformsKt.perspective(fovY, aspectRatio, zNear, zFar);
    }

    public final void lookAt(@NotNull Vector3 from, @NotNull Vector3 to, @NotNull Vector3 up) {
        Intrinsics.checkParameterIsNotNull(from, "from");
        Intrinsics.checkParameterIsNotNull(to, "to");
        Intrinsics.checkParameterIsNotNull(up, "up");
        this.view = this.view.times(TransformsKt.lookAt(from, to, up));
    }

    public static /* bridge */ /* synthetic */ void lookAt$default(Drawer drawer, Vector3 vector3, Vector3 vector32, Vector3 vector33, int n2, Object object) {
        if ((n2 & 4) != 0) {
            vector33 = Vector3.Companion.getUNIT_Y();
        }
        drawer.lookAt(vector3, vector32, vector33);
    }

    public final void scale(double s) {
        this.model = this.model.times(TransformsKt.scale(s, s, s));
    }

    public final void scale(double x, double y) {
        this.model = this.model.times(TransformsKt.scale(x, y, 1.0));
    }

    public final void scale(double x, double y, double z) {
        this.model = this.model.times(TransformsKt.scale(x, y, z));
    }

    public final void translate(@NotNull Vector2 t2) {
        Intrinsics.checkParameterIsNotNull(t2, "t");
        this.model = this.model.times(TransformsKt.translate(Vector2.vector3$default(t2, 0.0, 0.0, 0.0, 7, null)));
    }

    public final void translate(@NotNull Vector3 t2) {
        Intrinsics.checkParameterIsNotNull(t2, "t");
        this.model = this.model.times(TransformsKt.translate(t2));
    }

    public final void translate(double x, double y) {
        this.translate(x, y, 0.0);
    }

    public final void translate(double x, double y, double z) {
        this.model = this.model.times(TransformsKt.translate(new Vector3(x, y, z)));
    }

    public final void rotate(double rotationInDegrees) {
        this.model = this.model.times(TransformsKt.rotateZ(rotationInDegrees));
    }

    public final void rotate(@NotNull Vector3 axis, double rotationInDegrees) {
        Intrinsics.checkParameterIsNotNull(axis, "axis");
        this.model = this.model.times(TransformsKt.rotate(axis, rotationInDegrees));
    }

    public final void background(@NotNull ColorRGBa color) {
        Intrinsics.checkParameterIsNotNull(color, "color");
        this.driver.clear(color);
    }

    @NotNull
    public final DrawStyle pushStyle() {
        DrawStyle drawStyle = this.drawStyles.push(DrawStyle.copy$default(this.drawStyle, null, null, null, null, 0.0, false, null, null, false, null, null, null, null, null, null, null, null, null, 262143, null));
        Intrinsics.checkExpressionValueIsNotNull(drawStyle, "drawStyles.push(drawStyle.copy())");
        return drawStyle;
    }

    public final void popStyle() {
        this.drawStyle = DrawStyle.copy$default(this.drawStyles.pop(), null, null, null, null, 0.0, false, null, null, false, null, null, null, null, null, null, null, null, null, 262143, null);
    }

    @NotNull
    public final Matrix44 pushView() {
        Matrix44 matrix44 = this.viewStack.push(this.view);
        Intrinsics.checkExpressionValueIsNotNull(matrix44, "viewStack.push(view)");
        return matrix44;
    }

    public final void popView() {
        Matrix44 matrix44 = this.viewStack.pop();
        Intrinsics.checkExpressionValueIsNotNull(matrix44, "viewStack.pop()");
        this.view = matrix44;
    }

    @NotNull
    public final Matrix44 pushModel() {
        Matrix44 matrix44 = this.modelStack.push(this.model);
        Intrinsics.checkExpressionValueIsNotNull(matrix44, "modelStack.push(model)");
        return matrix44;
    }

    public final void popModel() {
        Matrix44 matrix44 = this.modelStack.pop();
        Intrinsics.checkExpressionValueIsNotNull(matrix44, "modelStack.pop()");
        this.model = matrix44;
    }

    @NotNull
    public final Matrix44 pushProjection() {
        Matrix44 matrix44 = this.projectionStack.push(this.projection);
        Intrinsics.checkExpressionValueIsNotNull(matrix44, "projectionStack.push(projection)");
        return matrix44;
    }

    public final void popProjection() {
        Matrix44 matrix44 = this.projectionStack.pop();
        Intrinsics.checkExpressionValueIsNotNull(matrix44, "projectionStack.pop()");
        this.projection = matrix44;
    }

    public final void pushTransforms() {
        this.pushModel();
        this.pushView();
        this.pushProjection();
    }

    public final void popTransforms() {
        this.popModel();
        this.popView();
        this.popProjection();
    }

    public final boolean getDepthWrite() {
        return this.drawStyle.getDepthWrite();
    }

    public final void setDepthWrite(boolean value) {
        this.drawStyle.setDepthWrite(value);
    }

    @NotNull
    public final CullTestPass getCullTestPass() {
        return this.drawStyle.getCullTestPass();
    }

    public final void setCullTestPass(@NotNull CullTestPass value) {
        Intrinsics.checkParameterIsNotNull((Object)value, "value");
        this.drawStyle.setCullTestPass(value);
    }

    @NotNull
    public final DepthTestPass getDepthTestPass() {
        return this.drawStyle.getDepthTestPass();
    }

    public final void setDepthTestPass(@NotNull DepthTestPass value) {
        Intrinsics.checkParameterIsNotNull((Object)value, "value");
        this.drawStyle.setDepthTestPass(value);
    }

    @Nullable
    public final ShadeStyle getShadeStyle() {
        return this.drawStyle.getShadeStyle();
    }

    public final void setShadeStyle(@Nullable ShadeStyle value) {
        this.drawStyle.setShadeStyle(value);
    }

    @Nullable
    public final ColorRGBa getFill() {
        return this.drawStyle.getFill();
    }

    public final void setFill(@Nullable ColorRGBa value) {
        this.drawStyle.setFill(value);
    }

    @Nullable
    public final ColorRGBa getStroke() {
        return this.drawStyle.getStroke();
    }

    public final void setStroke(@Nullable ColorRGBa value) {
        this.drawStyle.setStroke(value);
    }

    public final double getStrokeWeight() {
        return this.drawStyle.getStrokeWeight();
    }

    public final void setStrokeWeight(double value) {
        this.drawStyle.setStrokeWeight(value);
    }

    @NotNull
    public final LineCap getLineCap() {
        return this.drawStyle.getLineCap();
    }

    public final void setLineCap(@NotNull LineCap value) {
        Intrinsics.checkParameterIsNotNull((Object)value, "value");
        this.drawStyle.setLineCap(value);
    }

    @NotNull
    public final LineJoin getLineJoin() {
        return this.drawStyle.getLineJoin();
    }

    public final void setLineJoin(@NotNull LineJoin value) {
        Intrinsics.checkParameterIsNotNull((Object)value, "value");
        this.drawStyle.setLineJoin(value);
    }

    @Nullable
    public final FontMap getFontMap() {
        return this.drawStyle.getFontMap();
    }

    public final void setFontMap(@Nullable FontMap value) {
        this.drawStyle.setFontMap(value);
    }

    public final void rectangle(double x, double y, double width, double height) {
        this.rectangleDrawer.drawRectangle(this.getContext(), this.drawStyle, x, y, width, height);
    }

    public final void rectangles(@NotNull List<Vector2> positions, double width, double height) {
        Intrinsics.checkParameterIsNotNull(positions, "positions");
        this.rectangleDrawer.drawRectangles(this.getContext(), this.drawStyle, positions, width, height);
    }

    public final void rectangles(@NotNull List<Vector2> positions, @NotNull List<Vector2> dimensions) {
        Intrinsics.checkParameterIsNotNull(positions, "positions");
        Intrinsics.checkParameterIsNotNull(dimensions, "dimensions");
        this.rectangleDrawer.drawRectangles(this.getContext(), this.drawStyle, positions, dimensions);
    }

    public final void circle(@NotNull Vector2 position, double radius) {
        Intrinsics.checkParameterIsNotNull(position, "position");
        this.circleDrawer.drawCircle(this.getContext(), this.drawStyle, position.getX(), position.getY(), radius);
    }

    public final void circles(@NotNull List<Vector2> positions, double radius) {
        Intrinsics.checkParameterIsNotNull(positions, "positions");
        this.circleDrawer.drawCircles(this.getContext(), this.drawStyle, positions, radius);
    }

    public final void circles(@NotNull List<Vector2> positions, @NotNull List<Double> radii) {
        Intrinsics.checkParameterIsNotNull(positions, "positions");
        Intrinsics.checkParameterIsNotNull(radii, "radii");
        this.circleDrawer.drawCircles(this.getContext(), this.drawStyle, positions, radii);
    }

    /*
     * WARNING - void declaration
     */
    public final void shape(@NotNull Shape shape) {
        Intrinsics.checkParameterIsNotNull(shape, "shape");
        if (RenderTarget.Companion.getActive().getHasDepthBuffer()) {
            if (shape.getContours().size() > 1 || shape.getContours().get(0).getClosed()) {
                Collection<List> collection;
                void $receiver$iv$iv;
                void $receiver$iv;
                Iterable iterable = shape.getContours();
                DrawStyle drawStyle = this.drawStyle;
                DrawContext drawContext = this.getContext();
                QualityPolygonDrawer qualityPolygonDrawer = this.qualityPolygonDrawer;
                void var3_6 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it2;
                    ShapeContour shapeContour = (ShapeContour)item$iv$iv;
                    collection = destination$iv$iv;
                    List list = ShapeContour.adaptivePositions$default((ShapeContour)it2, 0.0, 1, null);
                    collection.add(list);
                }
                collection = (List)destination$iv$iv;
                qualityPolygonDrawer.drawPolygon(drawContext, drawStyle, (List<? extends List<Vector2>>)collection);
            } else if (!shape.getContours().get(0).getClosed() && this.drawStyle.getStroke() != null) {
                this.qualityLineDrawer.drawLineStrips(this.getContext(), this.drawStyle, (Iterable<? extends Iterable<Vector2>>)CollectionsKt.listOf(ShapeContour.adaptivePositions$default(shape.getContours().get(0), 0.0, 1, null)));
            }
        } else {
            throw (Throwable)new RuntimeException("drawing shapes requires a render target with a depth buffer attachment");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void contour(@NotNull ShapeContour contour2) {
        Intrinsics.checkParameterIsNotNull(contour2, "contour");
        if (!RenderTarget.Companion.getActive().getHasDepthBuffer()) throw (Throwable)new RuntimeException("drawing contours requires a render target with a depth buffer attachment");
        if (this.drawStyle.getFill() != null && contour2.getClosed()) {
            this.qualityPolygonDrawer.drawPolygon(this.getContext(), this.drawStyle, CollectionsKt.listOf(ShapeContour.adaptivePositions$default(contour2, 0.0, 1, null)));
        }
        if (this.drawStyle.getStroke() == null) return;
        switch (Drawer$WhenMappings.$EnumSwitchMapping$0[this.drawStyle.getQuality().ordinal()]) {
            case 1: {
                boolean bl = contour2.getClosed();
                if (bl) {
                    this.fastLineDrawer.drawLineLoops(this.getContext(), this.drawStyle, (Iterable<? extends List<Vector2>>)CollectionsKt.listOf(ShapeContour.adaptivePositions$default(contour2, 0.0, 1, null)));
                    return;
                }
                if (bl) return;
                this.fastLineDrawer.drawLineLoops(this.getContext(), this.drawStyle, (Iterable<? extends List<Vector2>>)CollectionsKt.listOf(ShapeContour.adaptivePositions$default(contour2, 0.0, 1, null)));
                return;
            }
            case 2: {
                boolean bl = contour2.getClosed();
                if (bl) {
                    List list = ShapeContour.adaptivePositions$default(contour2, 0.0, 1, null);
                    DrawStyle drawStyle = this.drawStyle;
                    DrawContext drawContext = this.getContext();
                    QualityLineDrawer qualityLineDrawer = this.qualityLineDrawer;
                    List it2 = list;
                    List list2 = it2.subList(0, it2.size() - 1);
                    qualityLineDrawer.drawLineLoops(drawContext, drawStyle, CollectionsKt.listOf(list2));
                    return;
                }
                if (bl) return;
                this.qualityLineDrawer.drawLineStrips(this.getContext(), this.drawStyle, (Iterable<? extends Iterable<Vector2>>)CollectionsKt.listOf(ShapeContour.adaptivePositions$default(contour2, 0.0, 1, null)));
            }
        }
    }

    public final void contours(@NotNull List<ShapeContour> contours) {
        List list;
        ShapeContour it2;
        Collection<List> collection;
        Iterable $receiver$iv$iv;
        Collection destination$iv$iv;
        Iterable $receiver$iv;
        Object object;
        DrawContext drawContext;
        DrawStyle drawStyle;
        Intrinsics.checkParameterIsNotNull(contours, "contours");
        if (this.drawStyle.getFill() != null) {
            Iterable iterable = contours;
            drawStyle = this.drawStyle;
            drawContext = this.getContext();
            object = this.qualityPolygonDrawer;
            void var3_6 = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                ShapeContour shapeContour = (ShapeContour)item$iv$iv;
                collection = destination$iv$iv;
                list = CollectionsKt.listOf(ShapeContour.adaptivePositions$default(it2, 0.0, 1, null));
                collection.add(list);
            }
            collection = (List)destination$iv$iv;
            ((QualityPolygonDrawer)object).drawPolygons(drawContext, drawStyle, (List<? extends List<? extends List<Vector2>>>)collection);
        }
        if (this.drawStyle.getStroke() != null) {
            $receiver$iv = contours;
            drawStyle = this.drawStyle;
            drawContext = this.getContext();
            object = this.qualityLineDrawer;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                it2 = (ShapeContour)item$iv$iv;
                collection = destination$iv$iv;
                list = ShapeContour.adaptivePositions$default(it2, 0.0, 1, null);
                collection.add(list);
            }
            collection = (List)destination$iv$iv;
            ((QualityLineDrawer)object).drawLineStrips(drawContext, drawStyle, (Iterable<? extends Iterable<Vector2>>)collection);
        }
    }

    public final void lineSegment(double x0, double y0, double x1, double y1) {
        this.lineSegment(new Vector2(x0, y0), new Vector2(x1, y1));
    }

    public final void lineSegment(@NotNull LineSegment lineSegment) {
        Intrinsics.checkParameterIsNotNull(lineSegment, "lineSegment");
        this.lineSegment(lineSegment.getStart(), lineSegment.getEnd());
    }

    public final void lineSegment(@NotNull Vector2 start, @NotNull Vector2 end2) {
        Intrinsics.checkParameterIsNotNull(start, "start");
        Intrinsics.checkParameterIsNotNull(end2, "end");
        switch (Drawer$WhenMappings.$EnumSwitchMapping$1[this.drawStyle.getQuality().ordinal()]) {
            case 1: {
                this.fastLineDrawer.drawLineSegments2(this.getContext(), this.drawStyle, (Iterable<Vector2>)CollectionsKt.listOf(new Vector2[]{start, end2}));
                break;
            }
            case 2: {
                this.qualityLineDrawer.drawLineStrips(this.getContext(), this.drawStyle, (Iterable<? extends Iterable<Vector2>>)CollectionsKt.listOf(CollectionsKt.listOf(new Vector2[]{start, end2})));
            }
        }
    }

    public final void lineSegment(@NotNull Vector3 start, @NotNull Vector3 end2) {
        Intrinsics.checkParameterIsNotNull(start, "start");
        Intrinsics.checkParameterIsNotNull(end2, "end");
        this.fastLineDrawer.drawLineSegments3(this.getContext(), this.drawStyle, (Iterable<Vector3>)CollectionsKt.listOf(new Vector3[]{start, end2}));
    }

    /*
     * WARNING - void declaration
     */
    public final void lineSegments(@NotNull List<Vector2> segments) {
        Intrinsics.checkParameterIsNotNull(segments, "segments");
        switch (Drawer$WhenMappings.$EnumSwitchMapping$2[this.drawStyle.getQuality().ordinal()]) {
            case 1: {
                this.fastLineDrawer.drawLineSegments2(this.getContext(), this.drawStyle, (Iterable<Vector2>)segments);
                break;
            }
            case 2: {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable iterable = $receiver$iv = (Iterable)RangesKt.until(0, segments.size() / 2);
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                Iterator iterator2 = $receiver$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void it2;
                    int item$iv$iv;
                    int n2 = item$iv$iv = ((IntIterator)iterator2).nextInt();
                    Collection collection = destination$iv$iv;
                    List<Vector2[]> list = CollectionsKt.listOf(new Vector2[]{segments.get((int)(it2 * 2)), segments.get((int)(it2 * 2 + true))});
                    collection.add(list);
                }
                List pairs = (List)destination$iv$iv;
                this.qualityLineDrawer.drawLineStrips(this.getContext(), this.drawStyle, pairs);
            }
        }
    }

    public final void lineSegments3d(@NotNull List<Vector3> segments) {
        Intrinsics.checkParameterIsNotNull(segments, "segments");
        this.fastLineDrawer.drawLineSegments3(this.getContext(), this.drawStyle, (Iterable<Vector3>)segments);
    }

    public final void lineLoop(@NotNull List<Vector2> points) {
        Intrinsics.checkParameterIsNotNull(points, "points");
        switch (Drawer$WhenMappings.$EnumSwitchMapping$3[this.drawStyle.getQuality().ordinal()]) {
            case 1: {
                this.fastLineDrawer.drawLineLoops(this.getContext(), this.drawStyle, (Iterable<? extends List<Vector2>>)CollectionsKt.listOf(points));
                break;
            }
            case 2: {
                this.qualityLineDrawer.drawLineLoops(this.getContext(), this.drawStyle, CollectionsKt.listOf(points));
            }
        }
    }

    public final void lineLoops(@NotNull List<? extends List<Vector2>> loops) {
        Intrinsics.checkParameterIsNotNull(loops, "loops");
        switch (Drawer$WhenMappings.$EnumSwitchMapping$4[this.drawStyle.getQuality().ordinal()]) {
            case 1: {
                this.fastLineDrawer.drawLineLoops(this.getContext(), this.drawStyle, (Iterable<? extends List<Vector2>>)loops);
                break;
            }
            case 2: {
                this.qualityLineDrawer.drawLineLoops(this.getContext(), this.drawStyle, loops);
            }
        }
    }

    public final void lineStrip(@NotNull List<Vector2> points) {
        Intrinsics.checkParameterIsNotNull(points, "points");
        switch (Drawer$WhenMappings.$EnumSwitchMapping$5[this.drawStyle.getQuality().ordinal()]) {
            case 1: {
                this.fastLineDrawer.drawLineLoops(this.getContext(), this.drawStyle, (Iterable<? extends List<Vector2>>)CollectionsKt.listOf(points));
                break;
            }
            case 2: {
                this.qualityLineDrawer.drawLineStrips(this.getContext(), this.drawStyle, (Iterable<? extends Iterable<Vector2>>)CollectionsKt.listOf(points));
            }
        }
    }

    public final void lineStrips(@NotNull List<? extends List<Vector2>> strips) {
        Intrinsics.checkParameterIsNotNull(strips, "strips");
        switch (Drawer$WhenMappings.$EnumSwitchMapping$6[this.drawStyle.getQuality().ordinal()]) {
            case 1: {
                this.fastLineDrawer.drawLineLoops(this.getContext(), this.drawStyle, (Iterable<? extends List<Vector2>>)strips);
                break;
            }
            case 2: {
                this.qualityLineDrawer.drawLineStrips(this.getContext(), this.drawStyle, (Iterable<? extends Iterable<Vector2>>)strips);
            }
        }
    }

    public final void composition(@NotNull Composition composition2) {
        Intrinsics.checkParameterIsNotNull(composition2, "composition");
        this.pushStyle();
        this.setFill(ColorRGBa.Companion.getBLACK());
        this.setStroke(null);
        Function1<CompositionNode, Unit> node$ = new Function1<CompositionNode, Unit>(this){
            final /* synthetic */ Drawer this$0;

            public final void invoke(@NotNull CompositionNode compositionNode) {
                Intrinsics.checkParameterIsNotNull(compositionNode, "compositionNode");
                this.this$0.pushModel();
                this.this$0.pushStyle();
                Drawer drawer = this.this$0;
                drawer.setModel(drawer.getModel().times(compositionNode.getTransform()));
                CompositionNode compositionNode2 = compositionNode;
                if (compositionNode2 instanceof ShapeNode) {
                    CompositionColor compositionColor = compositionNode.getFill();
                    CompositionColor it2 = compositionColor;
                    if (it2 instanceof Color) {
                        this.this$0.setFill(((Color)it2).getColor());
                    }
                    it2 = compositionColor = compositionNode.getStroke();
                    if (it2 instanceof Color) {
                        this.this$0.setStroke(((Color)it2).getColor());
                    }
                    this.this$0.shape(((ShapeNode)compositionNode).getShape());
                } else {
                    if (compositionNode2 instanceof TextNode) {
                        throw (Throwable)new NotImplementedError(null, 1, null);
                    }
                    if (compositionNode2 instanceof GroupNode) {
                        Iterable $receiver$iv = ((GroupNode)compositionNode).getChildren();
                        for (T element$iv : $receiver$iv) {
                            CompositionNode it3 = (CompositionNode)element$iv;
                            this.invoke(it3);
                        }
                    }
                }
                this.this$0.popModel();
                this.this$0.popStyle();
            }
            {
                this.this$0 = drawer;
                super(1);
            }
        };
        node$.invoke(composition2.getRoot());
        this.popStyle();
    }

    public final void image(@NotNull ColorBuffer colorBuffer, @NotNull Rectangle source, @NotNull Rectangle target) {
        Intrinsics.checkParameterIsNotNull(colorBuffer, "colorBuffer");
        Intrinsics.checkParameterIsNotNull(source, "source");
        Intrinsics.checkParameterIsNotNull(target, "target");
        this.imageDrawer.drawImage(this.getContext(), this.drawStyle, colorBuffer, source, target);
    }

    public final void image(@NotNull ColorBuffer colorBuffer, double x, double y) {
        Intrinsics.checkParameterIsNotNull(colorBuffer, "colorBuffer");
        this.imageDrawer.drawImage(this.getContext(), this.drawStyle, colorBuffer, x, y, (double)colorBuffer.getWidth() * 1.0, (double)colorBuffer.getHeight() * 1.0);
    }

    public final void image(@NotNull ColorBuffer colorBuffer) {
        Intrinsics.checkParameterIsNotNull(colorBuffer, "colorBuffer");
        this.image(colorBuffer, 0.0, 0.0);
    }

    public final void text(@NotNull String text, double x, double y) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        if (this.getFontMap() instanceof FontImageMap) {
            this.fontImageMapDrawer.drawText(this.getContext(), this.drawStyle, text, x, y);
        }
    }

    public final void size(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public final void vertexBuffer(@NotNull VertexBuffer vertexBuffer, @NotNull DrawPrimitive primitive, int vertexOffset, int vertexCount) {
        Intrinsics.checkParameterIsNotNull(vertexBuffer, "vertexBuffer");
        Intrinsics.checkParameterIsNotNull((Object)primitive, "primitive");
        this.vertexBuffer(CollectionsKt.listOf(vertexBuffer), primitive, vertexOffset, vertexCount);
    }

    public static /* bridge */ /* synthetic */ void vertexBuffer$default(Drawer drawer, VertexBuffer vertexBuffer, DrawPrimitive drawPrimitive, int n2, int n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = vertexBuffer.getVertexCount();
        }
        drawer.vertexBuffer(vertexBuffer, drawPrimitive, n2, n3);
    }

    public final void vertexBuffer(@NotNull List<? extends VertexBuffer> vertexBuffers, @NotNull DrawPrimitive primitive, int offset, int vertexCount) {
        Intrinsics.checkParameterIsNotNull(vertexBuffers, "vertexBuffers");
        Intrinsics.checkParameterIsNotNull((Object)primitive, "primitive");
        this.vertexBufferDrawer.drawVertexBuffer(this.getContext(), this.drawStyle, primitive, vertexBuffers, offset, vertexCount);
    }

    public static /* bridge */ /* synthetic */ void vertexBuffer$default(Drawer drawer, List list, DrawPrimitive drawPrimitive, int n2, int n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = ((VertexBuffer)list.get(0)).getVertexCount();
        }
        drawer.vertexBuffer(list, drawPrimitive, n2, n3);
    }

    public final void vertexBufferInstances(@NotNull List<? extends VertexBuffer> vertexBuffers, @NotNull List<? extends VertexBuffer> instanceAttributes, @NotNull DrawPrimitive primitive, int instanceCount, int offset, int vertexCount) {
        Intrinsics.checkParameterIsNotNull(vertexBuffers, "vertexBuffers");
        Intrinsics.checkParameterIsNotNull(instanceAttributes, "instanceAttributes");
        Intrinsics.checkParameterIsNotNull((Object)primitive, "primitive");
        this.vertexBufferDrawer.drawVertexBufferInstances(this.getContext(), this.drawStyle, primitive, vertexBuffers, instanceAttributes, offset, vertexCount, instanceCount);
    }

    public static /* bridge */ /* synthetic */ void vertexBufferInstances$default(Drawer drawer, List list, List list2, DrawPrimitive drawPrimitive, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 0x10) != 0) {
            n3 = 0;
        }
        if ((n5 & 0x20) != 0) {
            n4 = ((VertexBuffer)list.get(0)).getVertexCount();
        }
        drawer.vertexBufferInstances(list, list2, drawPrimitive, n2, n3, n4);
    }

    @NotNull
    public final Driver getDriver() {
        return this.driver;
    }

    public Drawer(@NotNull Driver driver) {
        Intrinsics.checkParameterIsNotNull(driver, "driver");
        this.driver = driver;
        Stack<DrawStyle> stack = new Stack<DrawStyle>();
        Drawer drawer = this;
        Stack<DrawStyle> $receiver = stack;
        $receiver.push(new DrawStyle(null, null, null, null, 0.0, false, null, null, false, null, null, null, null, null, null, null, null, null, 262143, null));
        Stack<DrawStyle> stack2 = stack;
        drawer.drawStyles = stack2;
        this.rectangleDrawer = new RectangleDrawer();
        this.vertexBufferDrawer = new VertexBufferDrawer();
        this.circleDrawer = new CircleDrawer();
        this.imageDrawer = new ImageDrawer();
        this.fastLineDrawer = new PerformanceLineDrawer();
        this.qualityLineDrawer = new QualityLineDrawer();
        this.qualityPolygonDrawer = new QualityPolygonDrawer();
        this.fontImageMapDrawer = new FontImageMapDrawer();
        this.modelStack = new Stack();
        this.viewStack = new Stack();
        this.projectionStack = new Stack();
        this.model = Matrix44.Companion.getIDENTITY();
        this.view = Matrix44.Companion.getIDENTITY();
        this.projection = Matrix44.Companion.getIDENTITY();
        this.drawStyle = new DrawStyle(null, null, null, null, 0.0, false, null, null, false, null, null, null, null, null, null, null, null, null, 262143, null);
    }
}

