/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class ARBSeparateShaderObjects {
    public static final int GL_VERTEX_SHADER_BIT = 1;
    public static final int GL_FRAGMENT_SHADER_BIT = 2;
    public static final int GL_GEOMETRY_SHADER_BIT = 4;
    public static final int GL_TESS_CONTROL_SHADER_BIT = 8;
    public static final int GL_TESS_EVALUATION_SHADER_BIT = 16;
    public static final int GL_ALL_SHADER_BITS = -1;
    public static final int GL_PROGRAM_SEPARABLE = 33368;
    public static final int GL_ACTIVE_PROGRAM = 33369;
    public static final int GL_PROGRAM_PIPELINE_BINDING = 33370;

    protected ARBSeparateShaderObjects() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions(caps.glUseProgramStages, caps.glActiveShaderProgram, caps.glCreateShaderProgramv, caps.glBindProgramPipeline, caps.glDeleteProgramPipelines, caps.glGenProgramPipelines, caps.glIsProgramPipeline, caps.glProgramParameteri, caps.glGetProgramPipelineiv, caps.glProgramUniform1i, caps.glProgramUniform2i, caps.glProgramUniform3i, caps.glProgramUniform4i, caps.glProgramUniform1ui, caps.glProgramUniform2ui, caps.glProgramUniform3ui, caps.glProgramUniform4ui, caps.glProgramUniform1f, caps.glProgramUniform2f, caps.glProgramUniform3f, caps.glProgramUniform4f, caps.glProgramUniform1d, caps.glProgramUniform2d, caps.glProgramUniform3d, caps.glProgramUniform4d, caps.glProgramUniform1iv, caps.glProgramUniform2iv, caps.glProgramUniform3iv, caps.glProgramUniform4iv, caps.glProgramUniform1uiv, caps.glProgramUniform2uiv, caps.glProgramUniform3uiv, caps.glProgramUniform4uiv, caps.glProgramUniform1fv, caps.glProgramUniform2fv, caps.glProgramUniform3fv, caps.glProgramUniform4fv, caps.glProgramUniform1dv, caps.glProgramUniform2dv, caps.glProgramUniform3dv, caps.glProgramUniform4dv, caps.glProgramUniformMatrix2fv, caps.glProgramUniformMatrix3fv, caps.glProgramUniformMatrix4fv, caps.glProgramUniformMatrix2dv, caps.glProgramUniformMatrix3dv, caps.glProgramUniformMatrix4dv, caps.glProgramUniformMatrix2x3fv, caps.glProgramUniformMatrix3x2fv, caps.glProgramUniformMatrix2x4fv, caps.glProgramUniformMatrix4x2fv, caps.glProgramUniformMatrix3x4fv, caps.glProgramUniformMatrix4x3fv, caps.glProgramUniformMatrix2x3dv, caps.glProgramUniformMatrix3x2dv, caps.glProgramUniformMatrix2x4dv, caps.glProgramUniformMatrix4x2dv, caps.glProgramUniformMatrix3x4dv, caps.glProgramUniformMatrix4x3dv, caps.glValidateProgramPipeline, caps.glGetProgramPipelineInfoLog);
    }

    public static native void glUseProgramStages(@NativeType(value="GLuint") int var0, @NativeType(value="GLbitfield") int var1, @NativeType(value="GLuint") int var2);

    public static native void glActiveShaderProgram(@NativeType(value="GLuint") int var0, @NativeType(value="GLuint") int var1);

    public static native int nglCreateShaderProgramv(int var0, int var1, long var2);

    @NativeType(value="GLuint")
    public static int glCreateShaderProgramv(@NativeType(value="GLenum") int type, @NativeType(value="const GLchar **") PointerBuffer strings) {
        return ARBSeparateShaderObjects.nglCreateShaderProgramv(type, strings.remaining(), MemoryUtil.memAddress(strings));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="GLuint")
    public static int glCreateShaderProgramv(@NativeType(value="GLenum") int type, CharSequence ... strings) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            long stringsAddress = APIUtil.apiArray(stack, MemoryUtil::memUTF8, strings);
            int __result = ARBSeparateShaderObjects.nglCreateShaderProgramv(type, strings.length, stringsAddress);
            APIUtil.apiArrayFree(stringsAddress, strings.length);
            int n2 = __result;
            return n2;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="GLuint")
    public static int glCreateShaderProgramv(@NativeType(value="GLenum") int type, @NativeType(value="const GLchar **") CharSequence string) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            long stringsAddress = APIUtil.apiArray(stack, MemoryUtil::memUTF8, string);
            int __result = ARBSeparateShaderObjects.nglCreateShaderProgramv(type, 1, stringsAddress);
            APIUtil.apiArrayFree(stringsAddress, 1);
            int n2 = __result;
            return n2;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void glBindProgramPipeline(@NativeType(value="GLuint") int var0);

    public static native void nglDeleteProgramPipelines(int var0, long var1);

    public static void glDeleteProgramPipelines(@NativeType(value="const GLuint *") IntBuffer pipelines) {
        ARBSeparateShaderObjects.nglDeleteProgramPipelines(pipelines.remaining(), MemoryUtil.memAddress(pipelines));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteProgramPipelines(@NativeType(value="const GLuint *") int pipeline) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer pipelines = stack.ints(pipeline);
            ARBSeparateShaderObjects.nglDeleteProgramPipelines(1, MemoryUtil.memAddress(pipelines));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGenProgramPipelines(int var0, long var1);

    public static void glGenProgramPipelines(@NativeType(value="GLuint *") IntBuffer pipelines) {
        ARBSeparateShaderObjects.nglGenProgramPipelines(pipelines.remaining(), MemoryUtil.memAddress(pipelines));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static int glGenProgramPipelines() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer pipelines = stack.callocInt(1);
            ARBSeparateShaderObjects.nglGenProgramPipelines(1, MemoryUtil.memAddress(pipelines));
            int n2 = pipelines.get(0);
            return n2;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="GLboolean")
    public static native boolean glIsProgramPipeline(@NativeType(value="GLuint") int var0);

    public static native void glProgramParameteri(@NativeType(value="GLuint") int var0, @NativeType(value="GLenum") int var1, @NativeType(value="GLint") int var2);

    public static native void nglGetProgramPipelineiv(int var0, int var1, long var2);

    public static void glGetProgramPipelineiv(@NativeType(value="GLuint") int pipeline, @NativeType(value="GLenum") int pname, @NativeType(value="GLint *") IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        ARBSeparateShaderObjects.nglGetProgramPipelineiv(pipeline, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static int glGetProgramPipelinei(@NativeType(value="GLuint") int pipeline, @NativeType(value="GLenum") int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            ARBSeparateShaderObjects.nglGetProgramPipelineiv(pipeline, pname, MemoryUtil.memAddress(params));
            int n2 = params.get(0);
            return n2;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void glProgramUniform1i(@NativeType(value="GLuint") int var0, @NativeType(value="GLint") int var1, @NativeType(value="GLint") int var2);

    public static native void glProgramUniform2i(@NativeType(value="GLuint") int var0, @NativeType(value="GLint") int var1, @NativeType(value="GLint") int var2, @NativeType(value="GLint") int var3);

    public static native void glProgramUniform3i(@NativeType(value="GLuint") int var0, @NativeType(value="GLint") int var1, @NativeType(value="GLint") int var2, @NativeType(value="GLint") int var3, @NativeType(value="GLint") int var4);

    public static native void glProgramUniform4i(@NativeType(value="GLuint") int var0, @NativeType(value="GLint") int var1, @NativeType(value="GLint") int var2, @NativeType(value="GLint") int var3, @NativeType(value="GLint") int var4, @NativeType(value="GLint") int var5);

    public static native void glProgramUniform1ui(@NativeType(value="GLuint") int var0, @NativeType(value="GLint") int var1, @NativeType(value="GLuint") int var2);

    public static native void glProgramUniform2ui(@NativeType(value="GLuint") int var0, @NativeType(value="GLint") int var1, @NativeType(value="GLuint") int var2, @NativeType(value="GLuint") int var3);

    public static native void glProgramUniform3ui(@NativeType(value="GLuint") int var0, @NativeType(value="GLint") int var1, @NativeType(value="GLuint") int var2, @NativeType(value="GLuint") int var3, @NativeType(value="GLuint") int var4);

    public static native void glProgramUniform4ui(@NativeType(value="GLuint") int var0, @NativeType(value="GLint") int var1, @NativeType(value="GLuint") int var2, @NativeType(value="GLuint") int var3, @NativeType(value="GLuint") int var4, @NativeType(value="GLuint") int var5);

    public static native void glProgramUniform1f(@NativeType(value="GLuint") int var0, @NativeType(value="GLint") int var1, @NativeType(value="GLfloat") float var2);

    public static native void glProgramUniform2f(@NativeType(value="GLuint") int var0, @NativeType(value="GLint") int var1, @NativeType(value="GLfloat") float var2, @NativeType(value="GLfloat") float var3);

    public static native void glProgramUniform3f(@NativeType(value="GLuint") int var0, @NativeType(value="GLint") int var1, @NativeType(value="GLfloat") float var2, @NativeType(value="GLfloat") float var3, @NativeType(value="GLfloat") float var4);

    public static native void glProgramUniform4f(@NativeType(value="GLuint") int var0, @NativeType(value="GLint") int var1, @NativeType(value="GLfloat") float var2, @NativeType(value="GLfloat") float var3, @NativeType(value="GLfloat") float var4, @NativeType(value="GLfloat") float var5);

    public static native void glProgramUniform1d(@NativeType(value="GLuint") int var0, @NativeType(value="GLint") int var1, @NativeType(value="GLdouble") double var2);

    public static native void glProgramUniform2d(@NativeType(value="GLuint") int var0, @NativeType(value="GLint") int var1, @NativeType(value="GLdouble") double var2, @NativeType(value="GLdouble") double var4);

    public static native void glProgramUniform3d(@NativeType(value="GLuint") int var0, @NativeType(value="GLint") int var1, @NativeType(value="GLdouble") double var2, @NativeType(value="GLdouble") double var4, @NativeType(value="GLdouble") double var6);

    public static native void glProgramUniform4d(@NativeType(value="GLuint") int var0, @NativeType(value="GLint") int var1, @NativeType(value="GLdouble") double var2, @NativeType(value="GLdouble") double var4, @NativeType(value="GLdouble") double var6, @NativeType(value="GLdouble") double var8);

    public static native void nglProgramUniform1iv(int var0, int var1, int var2, long var3);

    public static void glProgramUniform1iv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="const GLint *") IntBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform1iv(program, location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniform2iv(int var0, int var1, int var2, long var3);

    public static void glProgramUniform2iv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="const GLint *") IntBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform2iv(program, location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniform3iv(int var0, int var1, int var2, long var3);

    public static void glProgramUniform3iv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="const GLint *") IntBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform3iv(program, location, value.remaining() / 3, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniform4iv(int var0, int var1, int var2, long var3);

    public static void glProgramUniform4iv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="const GLint *") IntBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform4iv(program, location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniform1uiv(int var0, int var1, int var2, long var3);

    public static void glProgramUniform1uiv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="const GLuint *") IntBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform1uiv(program, location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniform2uiv(int var0, int var1, int var2, long var3);

    public static void glProgramUniform2uiv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="const GLuint *") IntBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform2uiv(program, location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniform3uiv(int var0, int var1, int var2, long var3);

    public static void glProgramUniform3uiv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="const GLuint *") IntBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform3uiv(program, location, value.remaining() / 3, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniform4uiv(int var0, int var1, int var2, long var3);

    public static void glProgramUniform4uiv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="const GLuint *") IntBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform4uiv(program, location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniform1fv(int var0, int var1, int var2, long var3);

    public static void glProgramUniform1fv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="const GLfloat *") FloatBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform1fv(program, location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniform2fv(int var0, int var1, int var2, long var3);

    public static void glProgramUniform2fv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="const GLfloat *") FloatBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform2fv(program, location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniform3fv(int var0, int var1, int var2, long var3);

    public static void glProgramUniform3fv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="const GLfloat *") FloatBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform3fv(program, location, value.remaining() / 3, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniform4fv(int var0, int var1, int var2, long var3);

    public static void glProgramUniform4fv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="const GLfloat *") FloatBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform4fv(program, location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniform1dv(int var0, int var1, int var2, long var3);

    public static void glProgramUniform1dv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="const GLdouble *") DoubleBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform1dv(program, location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniform2dv(int var0, int var1, int var2, long var3);

    public static void glProgramUniform2dv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="const GLdouble *") DoubleBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform2dv(program, location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniform3dv(int var0, int var1, int var2, long var3);

    public static void glProgramUniform3dv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="const GLdouble *") DoubleBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform3dv(program, location, value.remaining() / 3, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniform4dv(int var0, int var1, int var2, long var3);

    public static void glProgramUniform4dv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="const GLdouble *") DoubleBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform4dv(program, location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix2fv(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix2fv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLfloat *") FloatBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix2fv(program, location, value.remaining() >> 2, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix3fv(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix3fv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLfloat *") FloatBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix3fv(program, location, value.remaining() / 9, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix4fv(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix4fv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLfloat *") FloatBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix4fv(program, location, value.remaining() >> 4, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix2dv(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix2dv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLdouble *") DoubleBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix2dv(program, location, value.remaining() >> 2, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix3dv(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix3dv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLdouble *") DoubleBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix3dv(program, location, value.remaining() / 9, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix4dv(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix4dv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLdouble *") DoubleBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix4dv(program, location, value.remaining() >> 4, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix2x3fv(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix2x3fv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLfloat *") FloatBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix2x3fv(program, location, value.remaining() / 6, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix3x2fv(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix3x2fv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLfloat *") FloatBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix3x2fv(program, location, value.remaining() / 6, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix2x4fv(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix2x4fv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLfloat *") FloatBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix2x4fv(program, location, value.remaining() >> 3, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix4x2fv(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix4x2fv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLfloat *") FloatBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix4x2fv(program, location, value.remaining() >> 3, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix3x4fv(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix3x4fv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLfloat *") FloatBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix3x4fv(program, location, value.remaining() / 12, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix4x3fv(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix4x3fv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLfloat *") FloatBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix4x3fv(program, location, value.remaining() / 12, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix2x3dv(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix2x3dv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLdouble *") DoubleBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix2x3dv(program, location, value.remaining() / 6, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix3x2dv(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix3x2dv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLdouble *") DoubleBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix3x2dv(program, location, value.remaining() / 6, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix2x4dv(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix2x4dv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLdouble *") DoubleBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix2x4dv(program, location, value.remaining() >> 3, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix4x2dv(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix4x2dv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLdouble *") DoubleBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix4x2dv(program, location, value.remaining() >> 3, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix3x4dv(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix3x4dv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLdouble *") DoubleBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix3x4dv(program, location, value.remaining() / 12, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix4x3dv(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix4x3dv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLdouble *") DoubleBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix4x3dv(program, location, value.remaining() / 12, transpose, MemoryUtil.memAddress(value));
    }

    public static native void glValidateProgramPipeline(@NativeType(value="GLuint") int var0);

    public static native void nglGetProgramPipelineInfoLog(int var0, int var1, long var2, long var4);

    public static void glGetProgramPipelineInfoLog(@NativeType(value="GLuint") int pipeline, @Nullable @NativeType(value="GLsizei *") IntBuffer length, @NativeType(value="GLchar *") ByteBuffer infoLog) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, 1);
        }
        ARBSeparateShaderObjects.nglGetProgramPipelineInfoLog(pipeline, infoLog.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(infoLog));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static String glGetProgramPipelineInfoLog(@NativeType(value="GLuint") int pipeline, @NativeType(value="GLsizei") int bufSize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        ByteBuffer infoLog = MemoryUtil.memAlloc(bufSize);
        try {
            IntBuffer length = stack.ints(0);
            ARBSeparateShaderObjects.nglGetProgramPipelineInfoLog(pipeline, bufSize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(infoLog));
            String string = MemoryUtil.memUTF8(infoLog, length.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree(infoLog);
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="void")
    public static String glGetProgramPipelineInfoLog(@NativeType(value="GLuint") int pipeline) {
        return ARBSeparateShaderObjects.glGetProgramPipelineInfoLog(pipeline, ARBSeparateShaderObjects.glGetProgramPipelinei(pipeline, 35716));
    }

    public static void glDeleteProgramPipelines(@NativeType(value="const GLuint *") int[] pipelines) {
        long __functionAddress = GL.getICD().glDeleteProgramPipelines;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, pipelines.length, pipelines);
    }

    public static void glGenProgramPipelines(@NativeType(value="GLuint *") int[] pipelines) {
        long __functionAddress = GL.getICD().glGenProgramPipelines;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, pipelines.length, pipelines);
    }

    public static void glGetProgramPipelineiv(@NativeType(value="GLuint") int pipeline, @NativeType(value="GLenum") int pname, @NativeType(value="GLint *") int[] params) {
        long __functionAddress = GL.getICD().glGetProgramPipelineiv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, pipeline, pname, params);
    }

    public static void glProgramUniform1iv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="const GLint *") int[] value) {
        long __functionAddress = GL.getICD().glProgramUniform1iv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length, value);
    }

    public static void glProgramUniform2iv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="const GLint *") int[] value) {
        long __functionAddress = GL.getICD().glProgramUniform2iv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 1, value);
    }

    public static void glProgramUniform3iv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="const GLint *") int[] value) {
        long __functionAddress = GL.getICD().glProgramUniform3iv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length / 3, value);
    }

    public static void glProgramUniform4iv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="const GLint *") int[] value) {
        long __functionAddress = GL.getICD().glProgramUniform4iv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 2, value);
    }

    public static void glProgramUniform1uiv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="const GLuint *") int[] value) {
        long __functionAddress = GL.getICD().glProgramUniform1uiv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length, value);
    }

    public static void glProgramUniform2uiv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="const GLuint *") int[] value) {
        long __functionAddress = GL.getICD().glProgramUniform2uiv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 1, value);
    }

    public static void glProgramUniform3uiv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="const GLuint *") int[] value) {
        long __functionAddress = GL.getICD().glProgramUniform3uiv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length / 3, value);
    }

    public static void glProgramUniform4uiv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="const GLuint *") int[] value) {
        long __functionAddress = GL.getICD().glProgramUniform4uiv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 2, value);
    }

    public static void glProgramUniform1fv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="const GLfloat *") float[] value) {
        long __functionAddress = GL.getICD().glProgramUniform1fv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length, value);
    }

    public static void glProgramUniform2fv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="const GLfloat *") float[] value) {
        long __functionAddress = GL.getICD().glProgramUniform2fv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 1, value);
    }

    public static void glProgramUniform3fv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="const GLfloat *") float[] value) {
        long __functionAddress = GL.getICD().glProgramUniform3fv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length / 3, value);
    }

    public static void glProgramUniform4fv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="const GLfloat *") float[] value) {
        long __functionAddress = GL.getICD().glProgramUniform4fv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 2, value);
    }

    public static void glProgramUniform1dv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="const GLdouble *") double[] value) {
        long __functionAddress = GL.getICD().glProgramUniform1dv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length, value);
    }

    public static void glProgramUniform2dv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="const GLdouble *") double[] value) {
        long __functionAddress = GL.getICD().glProgramUniform2dv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 1, value);
    }

    public static void glProgramUniform3dv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="const GLdouble *") double[] value) {
        long __functionAddress = GL.getICD().glProgramUniform3dv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length / 3, value);
    }

    public static void glProgramUniform4dv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="const GLdouble *") double[] value) {
        long __functionAddress = GL.getICD().glProgramUniform4dv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 2, value);
    }

    public static void glProgramUniformMatrix2fv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLfloat *") float[] value) {
        long __functionAddress = GL.getICD().glProgramUniformMatrix2fv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 2, transpose, value);
    }

    public static void glProgramUniformMatrix3fv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLfloat *") float[] value) {
        long __functionAddress = GL.getICD().glProgramUniformMatrix3fv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length / 9, transpose, value);
    }

    public static void glProgramUniformMatrix4fv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLfloat *") float[] value) {
        long __functionAddress = GL.getICD().glProgramUniformMatrix4fv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 4, transpose, value);
    }

    public static void glProgramUniformMatrix2dv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLdouble *") double[] value) {
        long __functionAddress = GL.getICD().glProgramUniformMatrix2dv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 2, transpose, value);
    }

    public static void glProgramUniformMatrix3dv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLdouble *") double[] value) {
        long __functionAddress = GL.getICD().glProgramUniformMatrix3dv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length / 9, transpose, value);
    }

    public static void glProgramUniformMatrix4dv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLdouble *") double[] value) {
        long __functionAddress = GL.getICD().glProgramUniformMatrix4dv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 4, transpose, value);
    }

    public static void glProgramUniformMatrix2x3fv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLfloat *") float[] value) {
        long __functionAddress = GL.getICD().glProgramUniformMatrix2x3fv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length / 6, transpose, value);
    }

    public static void glProgramUniformMatrix3x2fv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLfloat *") float[] value) {
        long __functionAddress = GL.getICD().glProgramUniformMatrix3x2fv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length / 6, transpose, value);
    }

    public static void glProgramUniformMatrix2x4fv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLfloat *") float[] value) {
        long __functionAddress = GL.getICD().glProgramUniformMatrix2x4fv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 3, transpose, value);
    }

    public static void glProgramUniformMatrix4x2fv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLfloat *") float[] value) {
        long __functionAddress = GL.getICD().glProgramUniformMatrix4x2fv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 3, transpose, value);
    }

    public static void glProgramUniformMatrix3x4fv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLfloat *") float[] value) {
        long __functionAddress = GL.getICD().glProgramUniformMatrix3x4fv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length / 12, transpose, value);
    }

    public static void glProgramUniformMatrix4x3fv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLfloat *") float[] value) {
        long __functionAddress = GL.getICD().glProgramUniformMatrix4x3fv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length / 12, transpose, value);
    }

    public static void glProgramUniformMatrix2x3dv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLdouble *") double[] value) {
        long __functionAddress = GL.getICD().glProgramUniformMatrix2x3dv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length / 6, transpose, value);
    }

    public static void glProgramUniformMatrix3x2dv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLdouble *") double[] value) {
        long __functionAddress = GL.getICD().glProgramUniformMatrix3x2dv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length / 6, transpose, value);
    }

    public static void glProgramUniformMatrix2x4dv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLdouble *") double[] value) {
        long __functionAddress = GL.getICD().glProgramUniformMatrix2x4dv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 3, transpose, value);
    }

    public static void glProgramUniformMatrix4x2dv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLdouble *") double[] value) {
        long __functionAddress = GL.getICD().glProgramUniformMatrix4x2dv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 3, transpose, value);
    }

    public static void glProgramUniformMatrix3x4dv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLdouble *") double[] value) {
        long __functionAddress = GL.getICD().glProgramUniformMatrix3x4dv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length / 12, transpose, value);
    }

    public static void glProgramUniformMatrix4x3dv(@NativeType(value="GLuint") int program, @NativeType(value="GLint") int location, @NativeType(value="GLboolean") boolean transpose, @NativeType(value="const GLdouble *") double[] value) {
        long __functionAddress = GL.getICD().glProgramUniformMatrix4x3dv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length / 12, transpose, value);
    }

    public static void glGetProgramPipelineInfoLog(@NativeType(value="GLuint") int pipeline, @Nullable @NativeType(value="GLsizei *") int[] length, @NativeType(value="GLchar *") ByteBuffer infoLog) {
        long __functionAddress = GL.getICD().glGetProgramPipelineInfoLog;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.checkSafe(length, 1);
        }
        JNI.callPPV(__functionAddress, pipeline, infoLog.remaining(), length, MemoryUtil.memAddress(infoLog));
    }

    static {
        GL.initialize();
    }
}

