uniform float explosion;
uniform float time;

void main(void) 
{
  vec4 vertex  = gl_Vertex;
  vertex.x *= cos(vertex.z+time);	
  vertex.y *= cos(vertex.z+time);

  vec4 rvertex;

  float phi = vertex.z+time;
  rvertex.x = vertex.x * cos(phi) + vertex.y * -sin(phi);
  rvertex.y = vertex.x * sin(phi) + vertex.y * cos(phi);
  rvertex.z = vertex.z;
  rvertex.w = vertex.w;

  vertex = rvertex;

  vertex.x += gl_Normal.x * explosion;	
  vertex.y += gl_Normal.y * explosion;	
  vertex.z += gl_Normal.z * explosion;	

  gl_Position = gl_ModelViewProjectionMatrix * vertex;

  vec3 normal, lightDir;
  vec4 diffuse;
  float NdotL;
  
  /* first transform the normal into eye space and normalize the result */
  normal = normalize(gl_NormalMatrix * gl_Normal);
		
  /* now normalize the light's direction. Note that according to the
     OpenGL specification, the light is stored in eye space. Also since 
     we're talking about a directional light, the position field is actually 
     direction */
  lightDir = normalize(vec3(gl_LightSource[0].position));
  
  /* compute the cos of the angle between the normal and lights direction. 
     The light is directional so the direction is constant for every vertex.
     Since these two are normalized the cosine is the dot product. We also 
     need to clamp the result to the [0,1] range. */
  NdotL = max(dot(normal, lightDir), 0.0);
  
  /* Compute the diffuse term */
  diffuse = gl_Color * gl_LightSource[0].diffuse;
  diffuse.a = 1.0;
  gl_FrontColor =  NdotL * diffuse;
		


}
