from modpp import *

# Written and maintained by Edwin Jakobs (edwin@scene.nl)

""" Widget module
Used for creating widgets within the demoplaya program
"""

class ExtendedWindow(Window):
  def __init__(self, name, xpos, ypos, width, height):
    Window.__init__(self, name, xpos, ypos, width, height)
    self.__onClose = None
  
  def setOnClose(self, function):
    self.__onClose = function

  def getOnClose(self):
    return self.__onClose

  def cOnClose(self):
    if self.__onClose:
      self.__onClose(self)
    else:
      print "python on close"

  onClose = property(getOnClose, setOnClose, None, 'On window close handler')

    

class BoundedSlider(BaseBoundedSlider):
  def __init__(self, parent, xpos, ypos, width, height):
    BaseBoundedSlider.__init__(self, parent,  xpos, ypos, width, height)
    self.__onValueChanged = None
    self.__onMouseUp = None
    self.__onMouseDown = None
    self.__isDragging = False

  def getIsDragging(self):
    return self.__isDragging

  def setOnMouseDown(self, function):
    self.__onMouseDown = function

  def getOnMouseDown(self):
    return self.__onMouseDown
    
  def setOnMouseUp(self, function):
    self.__onMouseUp = function

  def getOnMouseUp(self):
    return self.__onMouseUp
    
  def setOnValueChanged(self, function):
    self.__onValueChanged = function
    
  def getOnValueChanged(self):
    return self.__onValueChanged

  def cOnMouseDown(self, x, y ,button):
    BaseBoundedSlider.cOnMouseDown(self, x, y, button)
    if button == 0:
      self.__isDragging = True
    if self.onMouseDown != None:
      self.onMouseDown(self, x, y, button)

  def cOnMouseUp(self, x, y, button):
    BaseBoundedSlider.cOnMouseUp(self, x, y, button)
    if button == 0:
      self.__isDragging = False
    if self.onMouseUp != None:
      self.onMouseUp(self, x, y, button)

  def internalOnValueChanged(self, value):
    BaseBoundedSlider.internalOnValueChanged(self, value)
    if self.onValueChanged != None:
      self.onValueChanged(self, value)
    
  # properties
  onValueChanged = property(getOnValueChanged, setOnValueChanged, None, 'Value changed event handler')
  value = property(BaseBoundedSlider.getValue, BaseBoundedSlider.setValue, None, 'Current value')
  onMouseUp = property(getOnMouseUp, setOnMouseUp, None, 'On mouse up event handler')
  onMouseDown = property(getOnMouseDown, setOnMouseDown, None, 'On mouse up event handler')
  isDragging = property(getIsDragging, None, None, 'Drag status')    
  
class ListBox(BaseListBox):

  def __init__(self,
               parent = None,
               x = 0, y = 0,
               width = 100, height = 100,
               items = []):
    BaseListBox.__init__(self, parent, x, y, width, height)
    self.__onMouseUp = None
    self.__onMouseDown = None
    self.__onKeyDown = None
    self.__onKeyUp = None
    self.__onValueChanged = None
    self.__onSelect = None

    # TODO: add proper exception handling here in case non string objects are passed through [items]
    for item in items:
      self.addItem(item)

  def addItems(self, items):
    for item in items:
      self.addItem(item)

  def setItems(self, items):
    self.removeAll()
    for item in items:
      self.addItem(item)


  def getOnValueChanged(self):
    return self.__onValueChanged

  def setOnValueChanged(self, function):
    self.__onValueChanged = function
  
  def getOnSelect(self):
    return self.__onSelect

  def setOnSelect(self, function):
    self.__onSelect = function
  
  def getOnKeyDown(self):
    return self.__onKeyDown

  def getOnKeyUp(self):
    return self.__onKeyUp

  def setOnKeyUp(self, function):
    self.__onKeyUp = function

  def setOnKeyDown(self, function):
    self.__onKeyDown = function
  
  def getOnMouseUp(self):
    return self.__onMouseUp

  def setOnMouseUp(self, function):
    self.__onMouseUp = function

  def getOnMouseDown(self):
    return self.__onMouseDown

  def setOnMouseDown(self, function):
    self.__onMouseDown = function

  def cOnMouseUp(self, x, y, button):
    BaseListBox.cOnMouseUp(self, x, y, button)
    if self.__onMouseUp != None:
      self.__onMouseUp(self, x, y, button)

  def cOnMouseDown(self, x, y, button):
    BaseListBox.cOnMouseDown(self, x, y, button)
    if self.__onMouseDown != None:
      self.__onMouseDown(self, x, y, button)

  def cOnKeyDown(self, scancode, modifiers):
    BaseListBox.cOnKeyDown(self, scancode, modifiers)
    if self.__onKeyDown != None:
      self.__onKeyDown(self, scancode, modifiers)
      
  def cOnKeyUp(self, scancode, modifiers):
    BaseListBox.cOnKeyUp(self, scancode, modifiers)
    if self.__onKeyUp != None:
      self.__onKeyUp(self, scancode, modifiers)

  def internalOnValueChanged(self, value):
    BaseListBox.internalOnValueChanged(self, value)
    try:
      if self.__onValueChanged != None:
        self.__onValueChanged(self, value)
    except Exception, details:
      print details
      print "KRAKRAKRKA"

  def internalOnSelect(self, value):
    BaseListBox.internalOnSelect(self, value)
    try:
      if self.__onSelect != None:
        self.__onSelect(self, value)
    except Exception, details:
      print details
      print "KRAKRAKRKA"

  onMouseDown = property(getOnMouseDown, setOnMouseDown, None, "Mouse down event handler")
  onMouseUp = property(getOnMouseUp, setOnMouseUp, None, "Mouse up event handler")
  onKeyUp = property(getOnKeyUp, setOnKeyUp, None, "Key up event handler")
  onKeyDown = property(getOnKeyDown, setOnKeyDown, None, "Key down event handler")
  onValueChanged = property(getOnValueChanged, setOnValueChanged, None, "Value changed event handler")
  onSelect = property(getOnSelect, setOnSelect, None, "Value changed event handler")

class Slider(BaseSlider):
  """ Slider class
  Represents a slider widget.

  """
  def __init__(self, parent = None,
               x = 0, y = 0,
               width = 100, height = 20):
    BaseSlider.__init__(self, parent, x, y, width, height)
    self.__onValueChanged = None
    self.__onMouseUp = None
    self.__onMouseDown = None
    self.__isDragging = False

  def getIsDragging(self):
    return self.__isDragging

  def setOnMouseDown(self, function):
    self.__onMouseDown = function

  def getOnMouseDown(self):
    return self.__onMouseDown
    
  def setOnMouseUp(self, function):
    self.__onMouseUp = function

  def getOnMouseUp(self):
    return self.__onMouseUp
    
  def setOnValueChanged(self, function):
    self.__onValueChanged = function
    
  def getOnValueChanged(self):
    return self.__onValueChanged

  def cOnMouseDown(self, x, y ,button):
    BaseSlider.cOnMouseDown(self, x, y, button)
    if button == 0:
      self.__isDragging = True
    if self.onMouseDown != None:
      self.onMouseDown(self, x, y, button)

  def cOnMouseUp(self, x, y, button):
    BaseSlider.cOnMouseUp(self, x, y, button)
    if button == 0:
      self.__isDragging = False
    if self.onMouseUp != None:
      self.onMouseUp(self, x, y, button)

  def internalOnValueChanged(self, value):
    BaseSlider.internalOnValueChanged(self, value)
#    if self.onValueChanged != None:
#      self.onValueChanged(self, value)
    
  # properties
  onValueChanged = property(getOnValueChanged, setOnValueChanged, None, 'Value changed event handler')
  value = property(BaseSlider.getValue, BaseSlider.setValue, None, 'Current value')
  onMouseUp = property(getOnMouseUp, setOnMouseUp, None, 'On mouse up event handler')
  onMouseDown = property(getOnMouseDown, setOnMouseDown, None, 'On mouse up event handler')
  isDragging = property(getIsDragging, None, None, 'Drag status')

class Button(BaseButton):
  """ Button class
  Represents a button widget.
  onClick can be 
  """

  def setOnClick(self, function):
    self.__onClick = function

  def getOnClick(self):
    return self.__onClick

  onClick = property(getOnClick, setOnClick, None, 'On click callback function')
  
  def __init__(self, parent = None, id = -1,
               x = 0, y = 0,
               width = 30, height = 30,
               title = "button"):

    BaseButton.__init__(self, parent, x, y, width, height, title)
    self.__onClick = None

  def internalOnClick(self):
    BaseButton.internalOnClick(self)
    print self.onClick
    if self.__onClick != None:
      self.__onClick(self)

class Panel(BasePanel):
  """ Panel class
  Represents a Panel widget.
  onClick can be overloaded
  """

  def setOnClick(self, function):
    self.__onClick = function

  def getOnClick(self):
    return self.__onClick

  onClick = property(getOnClick, setOnClick, None, 'On click callback function')
  
  def __init__(self, parent, 
               x = 0, y = 0,
               width = 30, height = 30,
               title = "panel"):

    BasePanel.__init__(self, parent, x, y, width, height, title)
    self.__onClick = None

  def internalOnClick(self):
    BasePanel.internalOnClick(self)
    if self.__onClick != None:
      self.__onClick(self)

class Image(BaseImage):
  """ Image class
  Represents a Image widget.
  onClick can be overloaded
  """

  def setOnClick(self, function):
    self.__onClick = function

  def getOnClick(self):
    return self.__onClick

  onClick = property(getOnClick, setOnClick, None, 'On click callback function')
  
  def __init__(self, parent, 
               x = 0, y = 0,
               width = 30, height = 30,
               filename = ""):

    BaseImage.__init__(self, parent, x, y, width, height, filename)
    self.__onClick = None

  def internalOnClick(self):
    BaseImage.internalOnClick(self)
    if self.__onClick != None:
      self.__onClick(self)
