# A collection of simple yet handy utility functions

def scheduleChain(scheduler, startTime, length, nodes, inputs = []):
  """ Schedules a chain of CompositionNodes for a given scheduler.
  This is can be used when a large chain of nodes needs to be scheduled at the same time.
  If no inputs parameter is given, each node is connected to the `in` input of the next node in the chain.

  example:
  scheduleChain(scheduler, 0, 1000, [shapeRenderer, sceneRenderer, noise, root])

  scheduleChain can also be used to schedule more complex graphs, by using None in the node list

  scheduleChain(scheduler, 0, 1000, [sceneA, adder, sceneB, adder, root], ["a", "b", "in"])
  
  """
  
  if inputs == []:
    inputs = ["in"] * (len(nodes)-1)

  curInput = 0
  
  l = len(nodes)
  for i in xrange(l-1):
    if nodes[i] and nodes[i+1]:
      scheduler.schedule(startTime, length, nodes[i], nodes[i+1], inputs[curInput])
      curInput += 1
