# Scene classes


from modpp import BaseSceneNode, BaseCamera


class Camera(BaseCamera):
  
  def __init__(self):
    BaseCamera.__init__(self)

    self.__onDraw = None

  def __getOnDraw(self):
    return self.__onDraw

  def __setOnDraw(self, onDraw):
    self.__onDraw = onDraw

  def onUpdate(self, prevTime, curTime):
    if self.__onDraw:
      self.__onDraw(self, prevTime, curTime)
    
  onDraw = property(__getOnDraw, __setOnDraw, None, 'Draw callback')    
  

class SceneNode(BaseSceneNode):

  def __init__(self, scene, parentNode):
    BaseSceneNode.__init__(self, scene, parentNode)

    self.__onDraw = None

  def __getOnDraw(self):
    return self.__onDraw

  def __setOnDraw(self, onDraw):
    self.__onDraw = onDraw

  def onUpdate(self, prevTime, curTime):
    if self.__onDraw:
      self.__onDraw(self, prevTime, curTime)
    
  onDraw = property(__getOnDraw, __setOnDraw, None, 'Draw callback')    
