#include "stdlib.h"
#include "stdio.h"
#include "hdrloader/hdrloader.h"
#include <fstream>
#include <string>

int wmain(int argc, wchar_t* argv[])
{
    if (argc<2)
    {
        printf("Usage: hdr2tga.exe filename.hdr <output.tga>\n");
        return -1;
    }

    HDRLoaderResult result;
    result.cols = NULL;

    if (!HDRLoader::load(argv[1], result))
    {
        printf("Failed to read file\n");
        return -1;
    }
    
    wchar_t output_path[2048];
    _swprintf(output_path, L"%s.tga", argv[1]);

    std::ofstream tgafile(argc<3?output_path:argv[2], std::ios::binary );
    if (!tgafile)
    {
        printf("Failed to write file\n");
        delete result.cols;
        return -1;
    }

    unsigned char header[18] = { 0 };
    header[2] = 2;      // uncompressed rgb
    header[12] = result.width&0xFF;
    header[13] = (result.width>>8)&0xFF;
    header[14] = result.height&0xFF;
    header[15] = (result.height>>8)&0xFF;
    header[16] = 32;    // rgba

    tgafile.write((const char*)header, 18);

    // bottom-to-top/left-to-right, bgra
    for (int y=result.height-1; y>=0; --y)
    for (int x=0; x<result.width; ++x)
    {
        tgafile.put(*(result.cols+(y*result.width+x)*4+2));
        tgafile.put(*(result.cols+(y*result.width+x)*4+1));
        tgafile.put(*(result.cols+(y*result.width+x)*4+0));
        tgafile.put(*(result.cols+(y*result.width+x)*4+3));
    }

    static const char footer[26] =
        "\0\0\0\0"  // no extension area
        "\0\0\0\0"  // no developer directory
        "TRUEVISION-XFILE"
        ".";
    tgafile.write(footer, 26);
    tgafile.close();

    printf("Done.\n");

    delete result.cols;
	return 0;
}

