#include "module.h"
#include "terminal.h"
#include <pspkernel.h>

PSP_MODULE_INFO( "terminal_default", 0x1000, 1, 0 );
PSP_MAIN_THREAD_ATTR( 0 );
PSP_MAIN_THREAD_STACK_SIZE_KB( 32 );
PSP_HEAP_SIZE_KB( 32 );

bool MODULE_ItIsLoaded = false;
bool MODULE_ItIsRunning = false;
bool MODULE_ItHasToStop = false;
bool MODULE_ItHasToUpdate = false;

CTerminal * MODULE_TerminalInstance;

int MODULE_Main( SceSize args, void * argp )
{
    LIBS_Initialize();

    MODULE_TerminalInstance = new CTerminal();

    if( MODULE_TerminalInstance->Initialize() )
    {
        MODULE_ItIsLoaded = true;
    }

    MODULE_ItIsRunning = true;

    while( !MODULE_ItHasToStop )
    {
        sceKernelDelayThread( 100 );

        if( MODULE_ItHasToUpdate )
        {
            MODULE_TerminalInstance->Update();
            MODULE_ItHasToUpdate = false;
        }
    }

    if( MODULE_ItIsLoaded )
    {
        MODULE_TerminalInstance->Finalize();
    }

    delete MODULE_TerminalInstance;

    MODULE_ItIsRunning = false;

    return 0;
}

extern "C"
{

    uint32 MODULE_GetType( void )
    {
        return MODULE_TYPE_KernelTerminal;
    }

    bool MODULE_IsLoaded( void )
    {
        return MODULE_ItIsLoaded;
    }

    bool MODULE_IsRunning( void )
    {
        return MODULE_ItIsRunning;
    }

    void MODULE_Update( void )
    {
        MODULE_ItHasToUpdate = true;
    }

    bool MODULE_IsUpdating( void )
    {
        return MODULE_ItHasToUpdate;
    }

    void MODULE_UpdateLibrary( void )
    {
        LIBS_Update();
    }

    void MODULE_Stop( void )
    {
        MODULE_ItHasToStop = true;
    }

    int module_start( SceSize argc, void * argp )
    {
        int thid;

        thid = sceKernelCreateThread( "terminal_main_thread", MODULE_Main, 8, DEFAULT_THREAD_SIZE, 0, NULL );

        if( thid < 0 || sceKernelStartThread( thid, 0, 0 ) != 0 )
        {
            MODULE_ItIsRunning = true;
        }

        return 0;
    }

    int module_stop( SceSize args, void * argp )
    {
        return 0;
    }

};
