#include "module.h"
#include "keyboard.h"
#include <pspkernel.h>

PSP_MODULE_INFO( "keyboard_palm", 0x1000, 1, 0 );
PSP_MAIN_THREAD_ATTR( 0 );
PSP_MAIN_THREAD_STACK_SIZE_KB( 8 );
PSP_HEAP_SIZE_KB( 16 );

bool MODULE_ItIsLoaded = false;
bool MODULE_ItIsRunning = false;
bool MODULE_ItHasToStop = false;
bool MODULE_ItHasToUpdate = false;

CKeyboard * MODULE_KeyboardInstance;

int MODULE_Main( SceSize args, void * argp )
{
    LIBS_Initialize();

    MODULE_KeyboardInstance = new CKeyboard();

    if( MODULE_KeyboardInstance->Initialize() )
    {
        MODULE_ItIsLoaded = true;
    }

    MODULE_ItIsRunning = true;

    while( !MODULE_ItHasToStop )
    {
        sceKernelDelayThread( 100 );

        if( MODULE_ItHasToUpdate )
        {
            MODULE_KeyboardInstance->Update();
            MODULE_ItHasToUpdate = false;
        }
    }

    if( MODULE_ItIsLoaded )
    {
        MODULE_KeyboardInstance->Finalize();
    }

    delete MODULE_KeyboardInstance;

    MODULE_ItIsRunning = false;

    return 0;
}

extern "C"
{

    uint32 MODULE_GetType( void )
    {
        return MODULE_TYPE_KernelKeyboard;
    }

    bool MODULE_IsLoaded( void )
    {
        return MODULE_ItIsLoaded;
    }

    bool MODULE_IsRunning( void )
    {
        return MODULE_ItIsRunning;
    }

    void MODULE_Update( void )
    {
        MODULE_ItHasToUpdate = true;
    }

    bool MODULE_IsUpdating( void )
    {
        return MODULE_ItHasToUpdate;
    }

    void MODULE_UpdateLibrary( void )
    {
        LIBS_Update();
    }

    void MODULE_Stop( void )
    {
        MODULE_ItHasToStop = true;
    }

    bool MODULE_IsKeyPressed( uint32 key_code )
    {
        if( !MODULE_ItHasToUpdate )
        {
            return MODULE_KeyboardInstance->IsKeyPressed( key_code );
        }

        return false;
    }

    bool MODULE_IsKeyJustPressed( uint32 key_code )
    {
        if( !MODULE_ItHasToUpdate )
        {
            return MODULE_KeyboardInstance->IsKeyJustPressed( key_code );
        }

        return false;
    }

    uint32 MODULE_GetKeyJustPressed( void )
    {
        if( !MODULE_ItHasToUpdate )
        {
            return MODULE_KeyboardInstance->GetKeyJustPressed();
        }

        return 0;
    }

    bool MODULE_GetStringFromKey( char * string, uint32 string_size, uint32 key_code )
    {
        CString key_string;

        key_string = MODULE_KeyboardInstance->GetStringFromKey( key_code );

        if( key_string.GetLength() + 1 > string_size )
            return false;

        memcpy( string, key_string.GetBuffer(), key_string.GetLength() + 1 );
    
        return true;
    }

    void MODULE_GetMetaKeys( int32 * alt_key, int32 * ctrl_key, int32 * shift_key )
    {
        MODULE_KeyboardInstance->GetMetaKeys( alt_key, ctrl_key, shift_key );
    }

    int module_start( SceSize argc, void * argp )
    {
        int thid;

        thid = sceKernelCreateThread( "keyboard_main_thread", MODULE_Main, 8, DEFAULT_THREAD_SIZE, 0, NULL );

        if( thid < 0 || sceKernelStartThread( thid, 0, 0 ) != 0 )
        {
            MODULE_ItIsRunning = true;
        }

        return 0;
    }

    int module_stop( SceSize args, void * argp )
    {
        return 0;
    }

};
