#ifndef _KEYBOARD_H_
    #define _KEYBOARD_H_

    #include "libs.h"
    #include "button/keyboard_button.h"

    class CKeyboard
    {      
    public:

        CKeyboard( void );
        ~CKeyboard( void );

        bool IsKeyPressed( uint32 key_code ) const;
        bool IsKeyJustPressed( uint32 key_code ) const;
        uint32 GetKeyJustPressed( void ) const;
        CString GetStringFromKey( uint32 key_code ) const;
        void GetMetaKeys( int32 * alt_key, int32 * ctrl_key, int32 * shift_key ) const;

        bool Initialize( void );
        void Finalize( void );
        void Update( void );

    private:

        void CreateButtons( void );
        void DestroyButtons( void );

        CString GetStringFromKeyDefault( uint32 key_code ) const;
        CString GetStringFromKeyAlt( uint32 key_code ) const;
        CString GetStringFromKeyShift( uint32 key_code ) const;
        
    private:

        CList< CKeyboardButton * > ButtonArray;
        uint32 CurrentKey;
        int32 MetaKeys[ 3 ];
    };

#endif
