#include "keyboard_button.h"

extern "C"
{
    #include <pikeylib.h>
    #include "pikeytypes.h"
}

CKeyboardButton::CKeyboardButton( void ) :
    KeyCode( 0 ),
    ItIsPressed( false ),
    ItWasPressed( false )
{
}

CKeyboardButton::CKeyboardButton( uint32 key_code ) :
    KeyCode( key_code ),
    ItIsPressed( false ),
    ItWasPressed( false )
{
}

CKeyboardButton::~CKeyboardButton( void )
{
}

bool CKeyboardButton::IsPressed( void ) const
{
    return ItIsPressed;
}

bool CKeyboardButton::WasPressed( void ) const
{
    return ItWasPressed;
}

bool CKeyboardButton::IsJustPressed( void ) const
{
    return IsPressed() && !WasPressed();
}

bool CKeyboardButton::Update( void )
{
    ItWasPressed = ItIsPressed;
    ItIsPressed = isKeyPressed( KeyCode );

    return IsJustPressed();
}
