#include "module.h"
#include "kernel.h"
#include <pspkernel.h>

PSP_MODULE_INFO( "kernel_1_0_0", 0x1000, 1, 0 );
PSP_MAIN_THREAD_ATTR( 0 );
PSP_MAIN_THREAD_STACK_SIZE_KB( 32 );
PSP_HEAP_SIZE_KB( 32 );

bool MODULE_ItIsLoaded = false;
bool MODULE_ItIsRunning = false;
bool MODULE_ItHasToStop = false;

CKernel * MODULE_Kernel;

int MODULE_Main( SceSize args, void * argp )
{
    chdir( CString( ( char * ) argp ).GetFilePath().GetBuffer() );

    LIBS_Initialize();

    MODULE_Kernel = new CKernel();

    MODULE_ItIsLoaded = true;
    MODULE_ItIsRunning = true;

    while( !MODULE_ItHasToStop )
    {
        sceKernelDelayThread( 20000 );

        MODULE_Kernel->Update();
    }

    delete MODULE_Kernel;
    
    MODULE_ItIsRunning = false;

    return 0;
}

extern "C"
{

    uint32 MODULE_GetType( void )
    {
        return MODULE_TYPE_Kernel;
    }

    bool MODULE_IsLoaded( void )
    {
        return MODULE_ItIsLoaded;
    }

    bool MODULE_IsRunning( void )
    {
        return MODULE_ItIsRunning;
    }

    void MODULE_Stop( void )
    {
        MODULE_ItHasToStop = true;
    }

    int module_start( SceSize argc, void * argp )
    {
        int thid;

        thid = sceKernelCreateThread( "kernel_main_thread", MODULE_Main, 8, DEFAULT_THREAD_SIZE, 0, NULL );

        if( thid < 0 || sceKernelStartThread( thid, argc, argp ) != 0 )
        {
            MODULE_ItIsRunning = true;
        }

        return 0;
    }

    int module_stop( SceSize args, void * argp )
    {
        return 0;
    }

    bool MODULE_FILE_SYSTEM_FindFullPath( char * full_path, uint32 size, const char * file_path )
    {
        CString full_path_string;

        if( KERNEL_FileSystem().FindFullPath( full_path_string, file_path ) )
        {
            if( full_path_string.GetLength() + 1 > size )
                return false;

            memcpy( full_path, full_path_string.GetBuffer(), full_path_string.GetLength() + 1 );
            
            return true;
        }

        return false;
    }

    bool MODULE_KERNEL_FindModuleNameByType( char * module_name, uint32 module_name_size, MODULE_TYPE module_type )
    {
        CString module_name_string;

        if( KERNEL_ModuleManager().FindModuleNameByType( module_name_string, module_type ) )
        {
            if( module_name_string.GetLength() + 1 > module_name_size )
                return false;

            memcpy( module_name, module_name_string.GetBuffer(), module_name_string.GetLength() + 1 );

            return true;
        }

        return false;
    }

};
