#include "module.h"
#include "framebuffer.h"
#include <pspkernel.h>
#include "module_print_parameters.h"

PSP_MODULE_INFO( "display_framebuffer", 0x1000, 1, 0 );
PSP_MAIN_THREAD_ATTR( 0 );
PSP_MAIN_THREAD_STACK_SIZE_KB( 32 );
PSP_HEAP_SIZE_KB( 32 );

bool MODULE_ItIsLoaded = false;
bool MODULE_ItIsRunning = false;
bool MODULE_ItHasToStop = false;
bool MODULE_ItHasToUpdate = false;

CFramebuffer * MODULE_FramebufferInstance;
CList< CModulePrintParameters * > * MODULE_PrintParametersArray = NULL;

int MODULE_Main( SceSize args, void * argp )
{
    ulong print_parameters_index;

    LIBS_Initialize();
    
    MODULE_FramebufferInstance = new CFramebuffer();

    if( MODULE_FramebufferInstance->Initialize() )
    {
        MODULE_PrintParametersArray = new CList< CModulePrintParameters * >();
        MODULE_ItIsLoaded = true;
    }

    MODULE_ItIsRunning = true;

    while( !MODULE_ItHasToStop )
    {
        sceKernelDelayThread( 100 );

        if( MODULE_ItHasToUpdate )
        {
            MODULE_FramebufferInstance->Update();
            
            for( print_parameters_index = 0 ; print_parameters_index < MODULE_PrintParametersArray->GetSize() ; print_parameters_index ++ )
            {
                MODULE_FramebufferInstance->Print(
                    (*(*MODULE_PrintParametersArray)[ print_parameters_index ])->GetText(),
                    (*(*MODULE_PrintParametersArray)[ print_parameters_index ])->GetPositionX(),
                    (*(*MODULE_PrintParametersArray)[ print_parameters_index ])->GetPositionY()
                    );

                delete (*(*MODULE_PrintParametersArray)[ print_parameters_index ]);
            }
            
            MODULE_PrintParametersArray->RemoveAll();
            MODULE_ItHasToUpdate = false;
        }
    }

    if( MODULE_ItIsLoaded )
    {
        for( print_parameters_index = 0 ; print_parameters_index < MODULE_PrintParametersArray->GetSize() ; print_parameters_index ++ )
        {
            delete (*(*MODULE_PrintParametersArray)[ print_parameters_index ]);
        }

        delete MODULE_PrintParametersArray;
        MODULE_FramebufferInstance->Finalize();
    }

    delete MODULE_FramebufferInstance;

    MODULE_ItIsRunning = false;

    return 0;
}

extern "C"
{

    uint32 MODULE_GetType( void )
    {
        return MODULE_TYPE_KernelDisplay;
    }

    bool MODULE_IsLoaded( void )
    {
        return MODULE_ItIsLoaded;
    }

    bool MODULE_IsRunning( void )
    {
        return MODULE_ItIsRunning;
    }

    void MODULE_Update( void )
    {
        MODULE_ItHasToUpdate = true;
    }

    bool MODULE_IsUpdating( void )
    {
        return MODULE_ItHasToUpdate;
    }

    void MODULE_UpdateLibrary( void )
    {
        LIBS_Update();
    }

    void MODULE_Stop( void )
    {
        MODULE_ItHasToStop = true;
    }

    void MODULE_Print( const char * text, uint32 position_x, uint32 position_y )
    {
        if( !MODULE_IsUpdating() && MODULE_PrintParametersArray != NULL )
        {
            MODULE_PrintParametersArray->Add(
                new CModulePrintParameters( text, position_x, position_y )
                );
        }
    }

    uint32 MODULE_GetWidth( void )
    {
        if( MODULE_FramebufferInstance != NULL )
            return MODULE_FramebufferInstance->GetTextModeWidth();

        return 0;
    }

    uint32 MODULE_GetHeight( void )
    {
        if( MODULE_FramebufferInstance != NULL )
            return MODULE_FramebufferInstance->GetTextModeHeight();

        return 0;
    }

    int module_start( SceSize argc, void * argp )
    {
        int thid;

        thid = sceKernelCreateThread( "display_main_thread", MODULE_Main, 8, DEFAULT_THREAD_SIZE, 0, NULL );

        if( thid < 0 || sceKernelStartThread( thid, 0, 0 ) != 0 )
        {
            MODULE_ItIsRunning = true;
        }

        return 0;
    }

    int module_stop( SceSize args, void * argp )
    {
        return 0;
    }

};
