#include "loader.h"
#include <pspsdk.h>
#include <sys/types.h>
#include <sys/unistd.h>

PSP_MODULE_INFO( "pspOS", 0x1000, 1, 1 );
PSP_MAIN_THREAD_ATTR( 0 );
PSP_MAIN_THREAD_STACK_SIZE_KB( 32 );
PSP_HEAP_SIZE_KB( 32 );

int CallbackExit( int arg1, int arg2, void *common );
int CallbackThread( SceSize args, void *argp );
int SetupCallbacks( void );

bool ItHasToQuit;
CModule * KERNEL_Module;

int main( int argc, char **argv ) 
{ 
    ItHasToQuit = false;

    pspSdkInstallKernelLoadModulePatch();
    pspSdkInstallNoDeviceCheckPatch();
    pspSdkInstallNoPlainModuleCheckPatch();

    SetupCallbacks();

    CConfig config_file;
    CString kernel_filepath;

    if( config_file.Open( "loader.conf" )
        && config_file.GetParameterValue( kernel_filepath, "KERNEL" )
        )
    {        
        KERNEL_Module = new CModule( kernel_filepath.GetFileName(), kernel_filepath.GetFilePath() );
        
        if( KERNEL_Module->Start() )
        {
            while( !ItHasToQuit && KERNEL_Module->IsRunning() )
            {
                sceKernelDelayThreadCB( 1000000 );
            }

            KERNEL_Module->Stop();
        }

        delete KERNEL_Module;
    }

    sceKernelExitGame();

    return 0;
}

int CallbackExit( int arg1, int arg2, void *common )
{
    ItHasToQuit = true;

    return 0;
}

int CallbackThread( SceSize args, void *argp )
{
    int cbid;

    cbid = sceKernelCreateCallback( "Exit Callback", CallbackExit, NULL );
    sceKernelRegisterExitCallback( cbid );
    sceKernelSleepThreadCB();

    return 0;
}

int SetupCallbacks( void )
{
    int thid = 0;

    thid = sceKernelCreateThread( "update_thread", CallbackThread, 0x11, 0xFA0, 0, 0 );

    if( thid >= 0 )
        sceKernelStartThread( thid, 0, 0 );

    return thid;
}

