#ifndef _LIBS_STRING_H_
    #define _LIBS_STRING_H_

    #include "libs_defs.h"
    #include "list\list.h"
    #include <sys/cdefs.h>
    #include <stdarg.h>
    #include <stdio.h>

    class CString
    {        
    public:

        CString( void );
        CString( char c );
        CString( const CString & text );
        CString( const char * text, ... );
        ~CString( void );

        char operator [] ( uint32 char_index ) const;
        char & operator [] ( uint32 char_index );

        void operator = ( char c );
        void operator = ( const char * text );
        void operator = ( const CString & text );
        CString operator + ( char c ) const;
        CString operator + ( const char * text ) const;
        CString operator + ( const CString & text ) const;
        void operator += ( char c );
        void operator += ( const char * text );
        void operator += ( const CString & text );
        void operator -- ( void );
        void operator -= ( uint32 remove_count );
        bool operator == ( char c ) const;
        bool operator == ( const char * text ) const;
        bool operator == ( const CString & text ) const;
        bool operator != ( char c ) const;
        bool operator != ( const char * text ) const;
        bool operator != ( const CString & text ) const;

        const char * GetBuffer( void ) const;
        char * GetBuffer( void );
        uint32 GetLength( void ) const;

        bool IsContaining( char c ) const;
        bool IsContaining( const char * text ) const;
        bool IsContaining( const CString & text ) const;
        bool IsSuffixed( const char * suffix ) const;
        bool IsSuffixed( const CString & suffix ) const;
        bool IsPrefixed( const char * prefix ) const;
        bool IsPrefixed( const CString & prefix ) const;
        uint32 GetOccurencesCount( char c ) const;
        uint32 GetInteger( void ) const;
        real GetReal( void ) const;
        
        CString GetFileName( void ) const;
        CString GetFilePath( void ) const;

        void Set( const char * text, ... );
        bool GetNextWord( CString & word, int32 & last_index, bool it_has_to_exclude_coma = false ) const;
        void RemoveFirstWord( void );
        void Replace( char new_character, char old_character );

        void Remove( uint32 character_index );
        void Insert( CString text, uint32 character_index );

    private:

        void SetLength( uint32 length );
        
    private:

        char * Buffer;
        uint32 Length;
        uint32 RealLength;
    };

#endif
