#include "module_helpers.h"

bool MODULE_HELPERS_IsThreadRunning( SceUID thread_id )
{
    SceKernelThreadRunStatus status;

    status.size = sizeof( SceKernelThreadRunStatus );

    if( sceKernelReferThreadRunStatus( thread_id, &status ) != 0 )
        return false;

    if( status.status == PSP_THREAD_KILLED
        || status.status == PSP_THREAD_STOPPED
        )
    {
        return false;
    }

    return true;
}

void MODULE_HELPERS_WaitForModuleStart( SceUID module_id )
{
    while( !MODULE_HELPERS_IsModuleRunning( module_id ) )
    {
        sceKernelDelayThread( 1000 );
    }
}

void MODULE_HELPERS_WaitForModuleStop( SceUID module_id )
{
    while( MODULE_HELPERS_IsModuleRunning( module_id ) )
    {
        sceKernelDelayThread( 1000 );
    }
}

bool MODULE_HELPERS_IsModuleRunning( SceUID module_id )
{
    return MODULE_HELPERS_GetModuleFromID( module_id ) != 0;
}

SceModule * MODULE_HELPERS_GetModuleFromID( SceUID module_id )
{
    return sceKernelFindModuleByUID( module_id );
}

bool MODULE_HELPERS_FindModuleByName( SceModule ** module, CString & lib_name, CString module_name )
{
    SceModule * current_module;
    SceUID * module_id_array;
    int32 module_index;
    int32 module_count;
    CString current_module_name;
    CString adapted_module_name;

    adapted_module_name = '\"';
    adapted_module_name += module_name;    
    
    module_count = 200;

    module_id_array = ( SceUID * ) malloc( sizeof( SceUID ) * module_count );

    if( module_id_array == NULL )
        return false;

    if( sceKernelGetModuleIdList( module_id_array, sizeof( SceUID ) * 200, &module_count ) < 0 )
    {
        free( module_id_array );

        return false;
    }

    for( module_index = 0 ; module_index < module_count ; module_index ++ )
    {
        if( module_id_array[ module_index ] != 0 )
        {
            current_module = MODULE_HELPERS_GetModuleFromID( module_id_array[ module_index ] );

            if( current_module != NULL )
            {
                current_module_name = current_module->modname;

                if( current_module_name.IsPrefixed( adapted_module_name ) )
                {
                    current_module_name.Remove( 0 );
                    current_module_name.Remove( current_module_name.GetLength() - 1 );

                    lib_name = current_module_name;
                    *module = current_module;

                    free( module_id_array );

                    return true;
                }
            }
        }
    }

    free( module_id_array );

    return false;
}

u32 * MODULE_HELPERS_FindExportedNidAddr( CString module_name, u32 nid )
{
    SceModule * module;
    CString lib_name;

    if( !MODULE_HELPERS_FindModuleByName( &module, lib_name, module_name ) )
        return ( u32 * ) 0;

    return MODULE_HELPERS_FindExportedNidAddr( module, lib_name.GetBuffer(), nid );
}

u32 * MODULE_HELPERS_FindExportedNidAddr( SceModule * mod, const char * lib, u32 nid )
{
    return MODULE_HELPERS_ModifyExportedFunction( mod, lib, nid, ( u32 ) NULL );
}

u32 * MODULE_HELPERS_ModifyExportedFunction( SceModule * mod, const char * lib, u32 nid, u32 * newProcAddr )
{
    u32 * ent_next = ( u32 * ) mod->ent_top;
    u32 * ent_end = ( u32 * ) mod->ent_top + ( mod->ent_size >> 2 );
    
    while( ent_next < ent_end )
    {
        SceLibraryEntryTable * ent = ( SceLibraryEntryTable * ) ent_next;

        if( ent->libname && strcmp( ent->libname, lib ) == 0 )
        {
            int count = ent->stubcount + ent->vstubcount;
            u32 * nidtable = ( u32 * ) ent->entrytable;
            int i;

            for( i = 0 ; i < count ; i++ )
            {
                if( nidtable[ i ] == nid )
                {
                    u32 * procAddr =( u32 * ) nidtable[ count + i ];

                    if( newProcAddr )
                    {
                        nidtable[ count + i ] = ( u32 ) newProcAddr;
                    }

                    return procAddr;
                }
            }

            return ( u32 * ) 0;
        }
        ent_next += ent->len;
    }

    return ( u32 * ) 0;
}
