#ifndef _MODULE_H_
    #define _MODULE_H_

    #include "libs_defs.h"
    #include "module_type.h"
    #include "module_helpers.h"
    #include <pspsdk.h>

    class CModule
    {      
    public:

        CModule( void );
        CModule( CString name, CString path );
        ~CModule( void );

        const CString & GetName( void ) const;
        SceUID GetModuleID( void ) const;

        MODULE_TYPE GetType( void ) const;
        bool IsLoaded( void );
        bool IsRunning( void );
        
        bool Start( void );
        bool Stop( void );
        void Update( void );
        void UpdateLibrary( void );

        u32 * GetFunctionPointer( u32 function_id );
        bool Load( void );
        bool UnLoad( void );

    private:

        bool ImportFunctions( void );

    private:

        uint32 ( * MODULE_GetType )( void );
        bool ( * MODULE_IsLoaded )( void );
        bool ( * MODULE_IsRunning )( void );
        void ( * MODULE_Update )( void );
        bool ( * MODULE_IsUpdating )( void );
        void ( * MODULE_UpdateLibrary )( void );
        void ( * MODULE_Stop )( void );

    private:

        MODULE_TYPE Type;
        CString Name;
        CString Path;
        SceModule * Module;
        SceUID ModuleID;
        SceUID ThreadID;
        bool ItIsRunning;
    };
#endif
