#ifndef _LIBS_IMPORT_H_
    #define _LIBS_IMPORT_H_

    #include "libs_defs.h"
    #include "list\list.h"
    #include <sys/cdefs.h>
    #include <stdarg.h>
    #include <stdio.h>

    #define LIBS_ModuleImporter() CImport::GetInstance()
    #define LIBS_Initialize() CImport LIBS_Importer;
    #define LIBS_Update() LIBS_ModuleImporter().ImportModules();

    class CImport
    {  
        PSPOS_SingletonH( CImport );

    public:

        CImport( void );
        ~CImport( void );

        void ImportModules( void );

        bool    KERNEL_FindFullPath( CString & full_path, CString file_path ) const;
        bool    KERNEL_FindModuleNameByType( CString & module_name, const MODULE_TYPE & type ) const;
        
        void    DISPLAY_Print( CString text, uint32 position_x, uint32 position_y );
        uint32  DISPLAY_GetWidth( void );
        uint32  DISPLAY_GetHeight( void );
        
        bool    KEYBOARD_IsKeyPressed( uint32 key_code );
        bool    KEYBOARD_IsKeyJustPressed( uint32 key_code );
        uint32  KEYBOARD_GetKeyJustPressed( void );
        CString KEYBOARD_GetStringFromKey( uint32 key_code );
        void    KEYBOARD_GetMetaKeys( int32 * alt_key, int32 * ctrl_key, int32 * shift_key );

    private:

        bool ( *MODULE_KERNEL_FindFullPath )( char * full_path, uint32 size, const char * file_path );
        bool ( *MODULE_KERNEL_FindModuleNameByType )( char * module_name, uint32 module_name_size, uint32 module_type );
        void ( *MODULE_DISPLAY_Print )( const char * text, uint32 position_x, uint32 position_y );
        uint32 ( *MODULE_DISPLAY_GetWidth )( void );
        uint32 ( *MODULE_DISPLAY_GetHeight )( void );
        bool ( *MODULE_KEYBOARD_IsKeyPressed )( uint32 key_code );
        bool ( *MODULE_KEYBOARD_IsKeyJustPressed )( uint32 key_code );
        uint32 ( *MODULE_KEYBOARD_GetKeyJustPressed )( void );
        bool ( *MODULE_KEYBOARD_GetStringFromKey )( char * string, uint32 string_size, uint32 key_code );
        void ( *MODULE_KEYBOARD_GetMetaKeys )( int32 * alt_key, int32 * ctrl_key, int32 * shift_key );
    };
#endif
