#include "import.h"
#include <sys/types.h>
#include <sys/unistd.h>

PSPOS_SingletonCpp( CImport );

CImport::CImport( void )
{
    PSPOS_CreateSingleton( CImport );

    ImportModules();
}

CImport::~CImport( void )
{
    PSPOS_DestroySingleton( CImport );
}

void CImport::ImportModules( void )
{
    SceModule * module;
    CString lib_name;

    MODULE_KERNEL_FindFullPath = NULL;
    MODULE_KERNEL_FindModuleNameByType = NULL;
    MODULE_DISPLAY_Print = NULL;
    MODULE_DISPLAY_GetWidth = NULL;
    MODULE_DISPLAY_GetHeight = NULL;
    MODULE_KEYBOARD_IsKeyPressed = NULL;
    MODULE_KEYBOARD_IsKeyJustPressed = NULL;
    MODULE_KEYBOARD_GetKeyJustPressed = NULL;
    MODULE_KEYBOARD_GetStringFromKey = NULL;
    MODULE_KEYBOARD_GetMetaKeys = NULL;
    
    if( MODULE_HELPERS_FindModuleByName( &module, lib_name, "kernel" ) )
    {
        MODULE_KERNEL_FindFullPath = ( bool ( * )( char *, uint32, const char * ) ) MODULE_HELPERS_FindExportedNidAddr( module, lib_name.GetBuffer(), 0x70DDC904 );
        MODULE_KERNEL_FindModuleNameByType = ( bool ( * )( char *, uint32, uint32 ) ) MODULE_HELPERS_FindExportedNidAddr( module, lib_name.GetBuffer(), 0x4620220E );
    }

    if( MODULE_HELPERS_FindModuleByName( &module, lib_name, "display" ) )
    {
        MODULE_DISPLAY_Print = ( void ( * )( const char *, uint32, uint32 ) ) MODULE_HELPERS_FindExportedNidAddr( module, lib_name.GetBuffer(), 0x1B27F76C );
        MODULE_DISPLAY_GetWidth = ( uint32 ( * )( void ) ) MODULE_HELPERS_FindExportedNidAddr( module, lib_name.GetBuffer(), 0xBF76E690 );
        MODULE_DISPLAY_GetHeight = ( uint32 ( * )( void ) ) MODULE_HELPERS_FindExportedNidAddr( module, lib_name.GetBuffer(), 0x3DCFD758 );
    }

    if( MODULE_HELPERS_FindModuleByName( &module, lib_name, "keyboard" ) )
    {
        MODULE_KEYBOARD_IsKeyPressed = ( bool ( * )( uint32 ) ) MODULE_HELPERS_FindExportedNidAddr( module, lib_name.GetBuffer(), 0xDA4FCAE9 );
        MODULE_KEYBOARD_IsKeyJustPressed = ( bool ( * )( uint32 ) ) MODULE_HELPERS_FindExportedNidAddr( module, lib_name.GetBuffer(), 0x85AD448B );
        MODULE_KEYBOARD_GetKeyJustPressed = ( uint32 ( * )( void ) ) MODULE_HELPERS_FindExportedNidAddr( module, lib_name.GetBuffer(), 0x59C1CFFF );
        MODULE_KEYBOARD_GetStringFromKey = ( bool ( * )( char *, uint32, uint32 ) ) MODULE_HELPERS_FindExportedNidAddr( module, lib_name.GetBuffer(), 0x511B8F0C );
        MODULE_KEYBOARD_GetMetaKeys = ( void ( * )( int32 *, int32 *, int32 * ) ) MODULE_HELPERS_FindExportedNidAddr( module, lib_name.GetBuffer(), 0x05DAEF2F );
    }
}

bool CImport::KERNEL_FindFullPath( CString & full_path, CString file_path ) const
{
    char full_path_buffer[ MAXPATHLEN ];

    if( MODULE_KERNEL_FindFullPath == NULL )
        return false;

    if( (*MODULE_KERNEL_FindFullPath)( full_path_buffer, MAXPATHLEN, file_path.GetBuffer() ) )
    {
        full_path = full_path_buffer;

        return true;
    }

    return false;
}

bool CImport::KERNEL_FindModuleNameByType( CString & module_name, const MODULE_TYPE & type ) const
{
    char module_name_buffer[ MAXPATHLEN ];

    if( MODULE_KERNEL_FindModuleNameByType == NULL )
        return false;

    if( (*MODULE_KERNEL_FindModuleNameByType)( module_name_buffer, MAXPATHLEN, ( uint32 ) type ) )
    {
        module_name = module_name_buffer;

        return true;
    }

    return false;
}

void CImport::DISPLAY_Print( CString text, uint32 position_x, uint32 position_y )
{
    if( MODULE_DISPLAY_Print != NULL )
        (*MODULE_DISPLAY_Print)( text.GetBuffer(), position_x, position_y );
}

uint32 CImport::DISPLAY_GetWidth( void )
{
    if( MODULE_DISPLAY_GetWidth != NULL )
        return (*MODULE_DISPLAY_GetWidth)();

    return 0;
}

uint32 CImport::DISPLAY_GetHeight( void )
{
    if( MODULE_DISPLAY_GetHeight != NULL )
        return (*MODULE_DISPLAY_GetHeight)();

    return 0;
}

bool CImport::KEYBOARD_IsKeyPressed( uint32 key_code )
{
    if( MODULE_KEYBOARD_IsKeyPressed != NULL )
        return (*MODULE_KEYBOARD_IsKeyPressed)( key_code );

    return false;
}

bool CImport::KEYBOARD_IsKeyJustPressed( uint32 key_code )
{
    if( MODULE_KEYBOARD_IsKeyJustPressed != NULL )
        return (*MODULE_KEYBOARD_IsKeyJustPressed)( key_code );

    return false;
}

uint32 CImport::KEYBOARD_GetKeyJustPressed( void )
{
    if( MODULE_KEYBOARD_GetKeyJustPressed != NULL )
        return (*MODULE_KEYBOARD_GetKeyJustPressed)();

    return NONE;
}

CString CImport::KEYBOARD_GetStringFromKey( uint32 key_code )
{
    if( MODULE_KEYBOARD_GetStringFromKey != NULL )
    {
        char key_string[ 12 ];

        if( (*MODULE_KEYBOARD_GetStringFromKey)( key_string, 12, key_code ) )
        {
            return key_string;
        }
    }

    return "";
}

void CImport::KEYBOARD_GetMetaKeys( int32 * alt_key, int32 * ctrl_key, int32 * shift_key )
{
    *alt_key = 0;
    *ctrl_key = 0;
    *shift_key = 0;

    if( MODULE_KEYBOARD_GetMetaKeys != NULL )
    {
        (*MODULE_KEYBOARD_GetMetaKeys)( alt_key, ctrl_key, shift_key );
    }
}
