#include "font_glyph.h"

CFontGlyph::CFontGlyph( void ) :
    Width( 0 ),
    Height( 0 ),
    Bitmap( NULL )
{
}

CFontGlyph::~CFontGlyph( void )
{
    Destroy();
}

uint32 CFontGlyph::GetWidth( void ) const
{
    return Width;
}

uint32 CFontGlyph::GetHeight( void ) const
{
    return Height;
}

const uint8 * CFontGlyph::GetBitmap( void ) const
{
    return Bitmap;
}

uint8 * CFontGlyph::GetBitmap( void )
{
    return Bitmap;
}

void CFontGlyph::Create( uint32 width, uint32 height, uint16 width_byte )
{
    Width = width;
    Height = height;
    Bitmap = ( uint8 * ) malloc( width_byte * Height );
}

void CFontGlyph::Destroy( void )
{
    if( Bitmap != NULL )
    {
        free( Bitmap );
        Bitmap = NULL;
    }
}

