#include "config.h"

CConfig::CConfig( void ) :
    File( NONE )
{
}

CConfig::CConfig( CString config_file_path ) :
    File( NONE )
{
    Open( config_file_path );
}

CConfig::~CConfig( void )
{
    Close();
}

bool CConfig::GetParameterValue( CString & parameter_value, CString parameter_name ) const
{
    uint32 line_index;
    int32 word_index;
    CString word;

    if( File == NONE )
        return false;

    for( line_index = 0 ; line_index < TextFileData.GetLinesCount() ; line_index ++ )
    {
        word_index = NONE;

        if( TextFileData.GetLine( line_index ).GetNextWord( word, word_index )
            && word == parameter_name
            && TextFileData.GetLine( line_index ).GetNextWord( parameter_value, word_index )
            )
        {
            return true;
        }
    }

    return false;
}

const CText & CConfig::GetTextFileData( void ) const
{
    return TextFileData;
}

bool CConfig::Open( CString config_file_path )
{
    if( File != NONE )
        Close();

    File = sceIoOpen( config_file_path.GetBuffer(), PSP_O_RDONLY, 0777 );
    
    if( File < 0 )
    {
        File = NONE;

        return false;
    }

    ParseFile();

    return true;
}

void CConfig::Close( void )
{
    if( File != NONE )
    {
        sceIoClose( File );
        File = NONE;
        TextFileData.SetEmpty();
    }
}

void CConfig::ParseFile( void )
{
    CString data;
    char character;
    bool it_is_in_comment_block( false );

    while( sceIoRead( File, &character, 1 ) > 0 )
    {
        if( it_is_in_comment_block )
        {
            if( character == '\n' )
            {
                it_is_in_comment_block = false;
                data += character;
            }
        }
        else
        {
            if( character == '#' )
            {
                it_is_in_comment_block = true;
            }
            else
            {
                data += character;
            }
        }        
    }

    TextFileData.SetFromTextBuffer( data.GetBuffer() );
}
