#ifndef _LIBS_ARRAY_H_
    #define _LIBS_ARRAY_H_

    #include "libs_defs.h"

    class CArray
    {
    public:            

        CArray( void );
        virtual ~CArray( void );

        virtual ulong GetSize( void ) const;
        ulong GetTotalSize( void ) const;
        ulong GetItemSize( void ) const;
        const void * GetBuffer( void ) const;
        void * GetBuffer( void );
        const void * ArrayGetItem( ulong item_index ) const;
        void * ArrayGetItem( ulong item_index );

    protected:            

        void SetItemSize( ulong item_size );
        const void * ArrayGetBuffer( void ) const;
        void * ArrayGetBuffer( void );
        
        bool ArrayBufferIsEmpty( void ) const;

        void ArrayReserve( ulong item_count, bool it_has_to_resize = false );
        void ArrayResize( ulong item_count, bool it_has_to_resize = false );
        void ArrayErase( void );
        ulong ArrayAddItem( void * item );
        void ArrayInsertItem( ulong item_index, void * item );
        void ArrayRemoveItem( ulong item_index, bool it_has_to_resize = false );
        void ArrayRemoveAllItems( bool it_has_to_resize = false );
        
    protected:

        char * Buffer;
        ulong Size;
        ulong ItemCount;
        ulong ItemReservedCount; 
        ulong ItemSize;
    };

#endif
