#include "array.h"

CArray::CArray( void )
{
    Buffer = NULL;
    Size = 0;
    ItemCount = 0;
    ItemReservedCount = 0;
    ItemSize = 0;
}

CArray::~CArray( void )
{
    ArrayErase();
    ItemSize = 0;
}

ulong CArray::GetSize( void ) const
{
    return ItemCount;
}

ulong CArray::GetTotalSize( void ) const
{
    return ItemReservedCount;
}

ulong CArray::GetItemSize( void ) const
{
    return ItemSize;
}

const void * CArray::GetBuffer( void ) const
{
    return Buffer;
}

void * CArray::GetBuffer( void )
{
    return Buffer;
}

const void * CArray::ArrayGetItem( ulong item_index ) const
{
    return ( void * )( Buffer + item_index * ItemSize ); 
}

void * CArray::ArrayGetItem( ulong item_index )
{
    return ( void * )( Buffer + item_index * ItemSize ); 
}

void CArray::SetItemSize( ulong item_size )
{
    ItemSize = item_size;
}

const void * CArray::ArrayGetBuffer( void ) const
{
    return Buffer;
}

void * CArray::ArrayGetBuffer( void )
{
    return Buffer;
}

bool CArray::ArrayBufferIsEmpty( void ) const
{
    return ( Buffer == NULL );
}

void CArray::ArrayReserve( ulong item_count, bool it_has_to_resize )
{
    if( !it_has_to_resize && item_count <= ItemReservedCount )
        return;

    Size = item_count * ItemSize;
    ItemReservedCount = item_count;
    
    if( ArrayBufferIsEmpty() )
        Buffer = ( char * ) malloc( Size );
    else
        Buffer = ( char * ) realloc( Buffer, Size );        
}

void CArray::ArrayResize( ulong item_count, bool it_has_to_resize )
{
    if( it_has_to_resize || item_count > ItemReservedCount )
        ArrayReserve( item_count, it_has_to_resize );
    
    ItemCount = item_count;
}

void CArray::ArrayErase( void )
{
    if( ArrayBufferIsEmpty() )
        return;

    free( Buffer );
    Buffer = NULL;
    Size = 0;
    ItemReservedCount = 0;
    ItemCount = 0;
}

ulong CArray::ArrayAddItem( void * item )
{
    ulong item_index = ItemCount;

    ArrayResize( ItemCount + 1 );
    memcpy( ( void * )( Buffer + item_index * ItemSize ), item, ItemSize );

    return item_index;
}

void CArray::ArrayInsertItem( ulong item_index, void * item )
{
    ArrayResize( ItemCount + 1 );

    for( ulong index = ItemCount - 1 ; index >= item_index + 1 ; index -- )
        memcpy(
            ( void * )( Buffer + index * ItemSize ),
            ( void * )( Buffer + ( index - 1 ) * ItemSize ),
            ItemSize
            );
            
    memcpy( ( void * )( Buffer + item_index * ItemSize ), item, ItemSize );
}

void CArray::ArrayRemoveItem( ulong item_index, bool it_has_to_resize )
{
    for( ulong index = item_index ; index < ItemCount - 1 ; index ++ )
        memcpy(
            ( void * )( Buffer + index * ItemSize ),
            ( void * )( Buffer + ( index + 1 ) * ItemSize ),
            ItemSize
            );

    if( ItemCount - 1 == 0 )
        ArrayErase();
    else    
        ArrayResize( ItemCount - 1, true );
}

void CArray::ArrayRemoveAllItems( bool it_has_to_resize )
{
    if( it_has_to_resize ) ArrayErase();
    else ItemCount = 0;
}
