#ifndef _KONSOLE_SCREEN_H_
    #define _KONSOLE_SCREEN_H_

    #include "konsole_defs.h"
    #include "list\list.h"
    #include "string\string.h"
    #include "font\font.h"

    #define KONSOLE_Screen()  CScreen::GetInstance()

    class CScreen
    {      
        KONSOLE_SingletonH( CScreen );

    public:

        CScreen( void );
        ~CScreen( void );

        uint32 GetTextModeWidth( void ) const;
        uint32 GetTextModeHeight( void ) const;

        void Print( CString text, uint32 position_x, uint32 position_y );

        void Create( void );
        void Destroy( void );
        void Update( void );

    private:

        void Clear( void );

    private:

        uint32 Width;
        uint32 Height;
        uint32 TextModeWidth;
        uint32 TextModeHeight;
        CFont * Font;

        char * FirstBuffer;
        char * SecondBuffer;
        char * CurrentBuffer;
    };

#endif
