#include "screen.h"
#include "pspdisplay_kernel.h"
#include "pspge.h"

KONSOLE_SingletonCpp( CScreen );

CScreen::CScreen( void ) :
    Width( 512 ),
    Height( 288 ),
    TextModeWidth( 35 ),
    TextModeHeight( 19 )
{
    KONSOLE_CreateSingleton( CScreen );

    Font = new CFont();
    Font->Create( "test.fnt" );
}

CScreen::~CScreen( void )
{
    Font->Destroy();
    delete Font;

    KONSOLE_DestroySingleton( CScreen );
}

uint32 CScreen::GetTextModeWidth( void ) const
{
    return TextModeWidth;
}

uint32 CScreen::GetTextModeHeight( void ) const
{
    return TextModeHeight;
}

void CScreen::Print( CString text, uint32 position_x, uint32 position_y )
{
    uint32 character_index;
    CFontGlyph * glyph;
    uint32 x, y, width, height;
    uint32 x_index, y_index;
    uint32 x_screen_index, y_screen_index;
    uint32 x_glyph_index, y_glyph_index;

    x = ( uint32 ) ( ( ( real ) position_x * Width ) / TextModeWidth );
    y = ( uint32 ) ( ( ( real ) position_y * Height ) / TextModeHeight );

    height = ( uint32 )( ( ( real ) Height ) / ( ( real ) TextModeHeight ) );

    for( character_index = 0 ; character_index < text.GetLength() ; character_index ++ )
    {
        glyph = Font->GetGlyph( text[ character_index ] );

        if( glyph != NULL )
        {
            width = ( uint32 )( ( ( real ) height ) * ( ( ( real ) glyph->GetWidth() ) / ( ( real ) glyph->GetHeight() ) ) );
            
            for( y_index = 0 ; y_index < height ; y_index ++ )
            {
                y_screen_index = y + y_index;
                y_glyph_index = ( uint32 ) ( ( ( real ) y_index * Font->GetHeight() ) / ( ( real ) height ) ); 

                for( x_index = 0 ; x_index < width ; x_index ++ )
                {
                    x_screen_index = x + x_index;                    
                    x_glyph_index = ( uint32 ) ( ( ( real ) x_index * glyph->GetWidth() ) / ( ( real ) width ) ); 

                    if( x_screen_index >= 0 && x_screen_index < Width )
                    if( y_screen_index >= 0 && y_screen_index < Height )
                    if( x_glyph_index >= 0 && x_glyph_index < glyph->GetWidth() )
                    if( y_glyph_index >= 0 && y_glyph_index < glyph->GetHeight() )
                    {
                        int _x = x_glyph_index / 8;
                        int _b = x_glyph_index % 8;

                        uint8 value;

                        value = ( ( glyph->GetBitmap()[ _x * glyph->GetHeight() + y_glyph_index ] & ( 128 >> _b ) ) != 0 ) ? 1 : 0;
                        value *= 255;

                        CurrentBuffer[ ( y_screen_index * Width + x_screen_index ) * 4 + 0 ] = value;
                        CurrentBuffer[ ( y_screen_index * Width + x_screen_index ) * 4 + 1 ] = value;
                        CurrentBuffer[ ( y_screen_index * Width + x_screen_index ) * 4 + 2 ] = value;
                    }
                }
            }

            x += width;
        }
    }
}

void CScreen::Create( void )
{
    pspDebugScreenInit();
    sceDisplaySetMode( 0, Width, Height );

    FirstBuffer = ( char * ) sceGeEdramGetAddr();
    SecondBuffer = ( ( char * ) sceGeEdramGetAddr() ) + Width * Height * 4;
    CurrentBuffer = FirstBuffer;
    Clear();
    sceDisplayWaitVblank();
    sceDisplaySetFrameBuf( CurrentBuffer, Width, PSP_DISPLAY_PIXEL_FORMAT_8888, PSP_DISPLAY_SETBUF_IMMEDIATE );
}

void CScreen::Destroy( void )
{
    CurrentBuffer = SecondBuffer;
    Clear();
    CurrentBuffer = FirstBuffer;
    Clear();
    sceDisplayWaitVblank();
    sceDisplaySetFrameBuf( CurrentBuffer, Width, PSP_DISPLAY_PIXEL_FORMAT_8888, PSP_DISPLAY_SETBUF_IMMEDIATE );
    sceDisplaySetMode( 0, 480, 272 );
}

void CScreen::Update( void )
{    
    sceDisplayWaitVblank();
    sceDisplaySetFrameBuf( CurrentBuffer, Width, PSP_DISPLAY_PIXEL_FORMAT_8888, PSP_DISPLAY_SETBUF_IMMEDIATE );

    if( CurrentBuffer == FirstBuffer )
    {
        CurrentBuffer = SecondBuffer;
    }
    else
    {
        CurrentBuffer = FirstBuffer;
    }

    Clear();
}

void CScreen::Clear( void )
{
    memset( CurrentBuffer, 0, sizeof( char ) * Width * Height * 4 );
}
