#ifndef _KONSOLE_KEYBOARD_H_
    #define _KONSOLE_KEYBOARD_H_

    #include "konsole_defs.h"
    #include "list\list.h"
    #include "string\string.h"
    #include "keyboard_button.h"

    #define KONSOLE_Keyboard()  CKeyboard::GetInstance()

    class CKeyboard
    {      
        KONSOLE_SingletonH( CKeyboard );

    public:

        CKeyboard( void );
        ~CKeyboard( void );

        bool IsKeyPressed( uint32 key_code ) const;
        bool IsKeyJustPressed( uint32 key_code ) const;
        uint32 GetKeyJustPressed( void ) const;
        CString GetStringFromKey( uint32 key_code ) const;

        bool Initialize( void );
        void Finalize( void );
        void Update( void );

    private:

        void CreateButtons( void );
        void DestroyButtons( void );

        CString GetStringFromKeyDefault( uint32 key_code ) const;
        CString GetStringFromKeyAlt( uint32 key_code ) const;
        CString GetStringFromKeyShift( uint32 key_code ) const;
        
    private:

        CList< CKeyboardButton * > ButtonArray;
        uint32 CurrentKey;
    };

#endif
