#ifndef _KONSOLE_CONSOLE_H_
    #define _KONSOLE_CONSOLE_H_

    #include "konsole_defs.h"
    #include "text/text.h"

    class CConsole
    {
    public:

        CConsole( void );
        ~CConsole( void );

        void SetPath( const CString & path );
        const CString & GetPath( void ) const;
        void SetHasEchoOn( bool it_has_echo_on );

        void Update( void );
        void Write( CString string );
        void Clear( void );

    private:

        void CheckInput( void );
        void Render( void );
        
    private:

        CString Path;
        int CursorSpeed;
        ulong MaximumLineCount;
        ulong MaximumCommandCount;
        ulong ScreenLineCount;

        CText LineArray, CommandArray;
        ulong LineIndex, CommandIndex;
        uint32 CursorIndex;
        bool ItHasEchoOn;
    };
#endif
