#include "command/run/run.h"
#include <psploadexec_kernel.h>
#include <pspsdk.h>

CCommandRun::CCommandRun( void ) :
    CCommand( "run" )
{
    pspSdkInstallNoDeviceCheckPatch();
}


CCommandRun::~CCommandRun( void )
{
}

bool COMMAND_RUN_RunElf( char * elf_path, CConsole & console )
{
    SceKernelLoadExecVSHParam exec_param;

    memset( &exec_param, 0, sizeof( SceKernelLoadExecVSHParam ) );
    exec_param.size = sizeof( exec_param );
    exec_param.key = "game";
    exec_param.argp = elf_path;
    exec_param.args = strlen( elf_path ) + 1;

    if( sceKernelLoadExecVSHMs2( elf_path, &exec_param ) < 0 )
        return false;
    
    return true;
}

bool COMMAND_RUN_RunElfAsModule( char * elf_path, CConsole & console )
{
    SceKernelLMOption option;
    SceUID mpid;
    SceUID module;
    int result, status;

    //mpid = 1;   // kernel
    mpid = 2;   // user

    memset( &option, 0, sizeof( option ) );
    option.size = sizeof( option );
    option.mpidtext = mpid;
    option.mpiddata = mpid;
    option.position = 0;
    option.access = 1;

    module = sceKernelLoadModule( elf_path, 0, &option );

    if( module < 0 )
        return false;

    KONSOLE_RunningModuleID = module;

    sceKernelDelayThread( 2000 );

    result = sceKernelStartModule( module, 0, NULL, &status, NULL );
    
    if( result < 0 )
    {
        KONSOLE_RunningModuleID = NONE;
        console.Write( CString( "sceKernelStartModule() failed with %x\n", result ) );
        
        return false;
    }

    sceKernelDelayThread( 2000 );

    return true;
}

bool COMMAND_RUN_RunElfAsModuleUsingHack( char * elf_path, CConsole & console )
{
    SceKernelLMOption option;
    SceUID mpid;
    SceUID module;
    int result, status;
    char * hack_module_path = "ms0:/PSP/GAME150/Konsole/konsole_boot.prx";

  //  return COMMAND_RUN_RunElf( hack_module_path, console );

    mpid = 1;
    
    memset( &option, 0, sizeof( option ) );
    option.size = sizeof( option );
    option.mpidtext = mpid;
    option.mpiddata = mpid;
    option.position = 0;
    option.access = 1;

    module = sceKernelLoadModule( hack_module_path, 0, &option );

    if( module < 0 )
        return false;

    result = sceKernelStartModule( module, sizeof( elf_path ) + 1, elf_path, &status, NULL );

    if( result < 0 )
    {
        console.Write( CString( "sceKernelStartModule() failed with %x\n", result ) );

        return false;
    }

    return true;
}

CString ELF_path;
CConsole * jConsole;

int test_thread( SceSize args, void * argp )
{
    KONSOLE_Screen().Destroy();

    if( !COMMAND_RUN_RunElfAsModule( ELF_path.GetBuffer(), *jConsole ) )
    {
        jConsole->Write( "Failed to load module" );
    }
    else
    {
        while( sceKernelFindModuleByUID( KONSOLE_RunningModuleID ) == 0 )
        {
        }

        while( sceKernelFindModuleByUID( KONSOLE_RunningModuleID ) )
        {
            sceKernelDelayThread( 1000 );
        }
    }

    sceKernelDelayThread( 10000 );

    KONSOLE_RunningModuleID = NONE;

    KONSOLE_Screen().Create();

    return sceKernelExitDeleteThread( 0 );
}

bool CCommandRun::Execute( const CString & command_line, const CString & path, CConsole & console )
{
    int32 parameter_index( NONE );
    CString parameter;
    
    if( command_line.GetNextWord( parameter, parameter_index ) )
    {
        int elf_file;
        CString line;
        
        if( !parameter.IsContaining( "/" ) )
            parameter = path + parameter;

        line = parameter;

        elf_file = sceIoOpen( parameter.GetBuffer(), PSP_O_RDONLY, 0777 );
        
        if( elf_file < 0 )
        {
            console.Write( "File unfound" );

            return true;
        }

        sceIoClose( elf_file );

        int thid;

        ELF_path = line;
        jConsole = &console;

        thid = sceKernelCreateThread( "test_thread", test_thread, 8, 64 * 1024, 0, NULL );

        if( thid >= 0 )
        {
            sceKernelStartThread( thid, 0, 0 );
        }
/*
        if( !COMMAND_RUN_RunElf( line.GetBuffer(), console ) )
        {
            console.Write( "Failed to load module" );

            return true;
        }   */
    }

    return true;
}
