#include "command/echo/echo.h"

CCommandEcho::CCommandEcho( void ) :
    CCommand( "echo" )
{
}


CCommandEcho::~CCommandEcho( void )
{
}

bool CCommandEcho::Execute( const CString & command_line, const CString & path, CConsole & console )
{
    int32 parameter_index( NONE );
    CString parameter;

    if( command_line.GetNextWord( parameter, parameter_index ) )
    {
        if( parameter == "on" )
        {
            console.SetHasEchoOn( true );

            return true;
        }

        if( parameter == "off" )
        {
            console.SetHasEchoOn( false );

            return true;
        }
    }

    console.Write( command_line );

    return true;
}
