#include "command/chdir/chdir.h"
#include "konsole.h"
#include <pspiofilemgr.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/unistd.h>

CCommandChdir::CCommandChdir( void ) :
    CCommand( "cd" )
{
}


CCommandChdir::~CCommandChdir( void )
{
}

bool CCommandChdir::Execute( const CString & command_line, const CString & path, CConsole & console )
{
    char buffer[ MAXPATHLEN ];

    if( chdir( command_line.GetBuffer() ) >= 0
        && getcwd( buffer, MAXPATHLEN ) != 0
        )
    {
        console.SetPath( buffer );
    }
    else
    {
        console.Write( "Invalid directory" );
    }

    return true;
}
