#include "kexplo.h"

extern float FogColor[4] = {0.5f, 0.5f, 0.5f, 1.0f};
extern float FogDepth = 30.0f;


// Rayon du bloc reprsentatif d'un fichier
float Taille_Fichier;



// Chti calcul de couleur
void SetBlend(float deg, CVertex c)
{
	deg = pow(deg,2);

	if(deg>=0.5)
	{
		glEnable(GL_BLEND);					
		glBlendFunc(GL_ONE, GL_SRC_ALPHA);	
		glColor4f(deg*c.x, deg*c.y, deg*c.z, (float)(1.0f-(deg-0.5)*2.));
	}
	else
	{
		glEnable(GL_BLEND);					
		glBlendFunc(GL_ONE, GL_ONE);	
		glColor3f(deg*c.x, deg*c.y, deg*c.z);
	}

//	glColor4f(c.x*deg, c.y*deg, c.z*deg, (1.0f-deg)*2.0f);
}


// Affichage du bloc reprsentatif d'un fichier
void Draw_Fichier(Fichier *fich, float x, float z, float scale, float deg, int tri[5], bool sel)
{
	float y = fich->y;
	float s;
	CVertex c = fich->col; 
//	glEnable(GL_BLEND);
//	glBlendFunc(GL_ONE, GL_SRC_ALPHA);	
	
	y *= scale;
	s = Taille_Fichier * scale / 1.5f;

	glTranslatef(x,0.0f,z);

	glEnable(GL_FOG);					

	glDisable(GL_DEPTH_TEST);

//	glEnable(GL_DEPTH_TEST);
//	glDepthMask(GL_FALSE);

	SetBlend(deg, c);

	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, Textures[0]);
	glDepthMask(GL_TRUE);
	glDisable(GL_DEPTH_TEST);

	if(sel==true)
	{
	glActiveTextureARB(GL_TEXTURE1_ARB);
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, Textures[2]);
	glTexEnvf (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_COMBINE_EXT);
	glTexEnvf (GL_TEXTURE_ENV, GL_COMBINE_RGB_EXT, GL_ADD);
	}	

	for(int i=0 ; i<5 ; i++)
	{
		if(tri[i]==TRI_BACK)
			Dw_Back(y, s, deg, sel, c);
		if(tri[i]==TRI_FRONT)
			Dw_Front(y, s, deg, sel, c);
		if(tri[i]==TRI_LEFT)
			Dw_Left(y, s, deg, sel, c);
		if(tri[i]==TRI_RIGHT)
			Dw_Right(y, s, deg, sel, c);
		if(tri[i]==TRI_TOP)
			Dw_Top(y, s, deg, sel, c);
	}
	
	glTranslatef(-x,0.0f,-z);
	
	glActiveTextureARB(GL_TEXTURE1_ARB);
	glDisable(GL_TEXTURE_2D);
	glActiveTextureARB(GL_TEXTURE0_ARB);

	glDepthMask(GL_TRUE);
	glEnable(GL_DEPTH_TEST);
	glDisable(GL_BLEND);

	glEnable(GL_TEXTURE_2D);

	glDisable(GL_FOG);					
}





// Affichage des attributs d'un fichier
void Draw_Attrib(Fichier *fich, float x, float z, float deg, float r)
{
	float y = fich->y;

	glEnable(GL_BLEND);
	glBlendFunc(GL_ONE, GL_ONE);	

	glPrint(-x, y-1.0f, z, deg, r, "borned - %i/%i/%i - %i:%i:%i", fich->born.wDay, fich->born.wMonth, fich->born.wYear, fich->born.wHour, fich->born.wMinute, fich->born.wSecond);
	glPrint(-x, y-2.0f, z, deg, r, "lastwrited - %i/%i/%i - %i:%i:%i", fich->writ.wDay, fich->writ.wMonth, fich->writ.wYear, fich->writ.wHour, fich->writ.wMinute, fich->writ.wSecond);
	glPrint(-x, y-3.0f, z, deg, r, "lastseen - %i/%i/%i - %i:%i:%i", fich->seen.wDay, fich->seen.wMonth, fich->seen.wYear, fich->seen.wHour, fich->seen.wMinute, fich->seen.wSecond);
	
	if(fich->size<1024)
		glPrint(-x, y-4.0f, z, deg, r, "%lu bytes", fich->size);
	else
	{
		if(fich->size<1024*1024)
			glPrint(-x, y-4.0f, z, deg, r, "%.2f Ko", fich->size/1024.0f);
		else
		{
			if(fich->size<1024*1024*1024)
				glPrint(-x, y-4.0f, z, deg, r, "%.2f Mo", fich->size/(1024.0f*1024.0f));
			else
				glPrint(-x, y-4.0f, z, deg, r, "%.2f Go", fich->size/(1024.*1024.*1024.));
		}
	}
	
	float w = 5.0f;
	
	if(fich->att.dir==true)		  { glPrint(-x, y-w, z, deg, r, "directory");  w++; }
	if(fich->att.file==true)	  { glPrint(-x, y-w, z, deg, r, "normal");     w++; }
	if(fich->att.temporary==true) { glPrint(-x, y-w, z, deg, r, "temporary");  w++; }
	if(fich->att.archive==true)   { glPrint(-x, y-w, z, deg, r, "archive"); 	w++; }
	if(fich->att.system==true)	  { glPrint(-x, y-w, z, deg, r, "system");	    w++; }
	if(fich->att.hidden==true)	  { glPrint(-x, y-w, z, deg, r, "hidden");	    w++; }
	if(fich->att.readonly==true)  { glPrint(-x, y-w, z, deg, r, "readonly");   w++; }

	glDisable(GL_BLEND);
}




// Affichage du nom d'un fichier
void Draw_Name(Fichier *fich, float x, float z, float deg, float r)
{
	float y = fich->y;

	glEnable(GL_BLEND);
	glBlendFunc(GL_ONE, GL_ONE);	

	glPrint_B(-x, y+3.0f, z, deg, r, "%s", fich->name);
	
	glDisable(GL_BLEND);
}





// Affichage complet d'un fichier
void Draw_File(Fichier *fich, float x, float z, float scale, float deg, int tri[5], bool sel)
{
	float ry;
	float r1, float r2;
	float d1, d2;
	float x1, z1;
	float x2, z2;

	CVertex v1, v2;
	
	v1.x = x - cam->m_vPosition.x;
	v1.y = 0.0f;
	v1.z = z - cam->m_vPosition.z;
	v2.x = 0.0f;
	v2.y = 0.0f;
	v2.z = 1.0f;

	ry = (float)(ASMAngleOfSeperation(v1, v2) * 180. / 3.14);
	if(v1.x<0.) ry = -ry;



	if(cam->m_vPosition.z>z)
	{
		r1 = 0.0f;
		x1 = x - Taille_Fichier / 1.5f;
		z1 = z + Taille_Fichier / 1.5f;
	}
	else
	{
		r1 = 180.0f;
		x1 = x + Taille_Fichier / 1.5f;
		z1 = z - Taille_Fichier / 1.5f;
	}
	
	if(cam->m_vPosition.x>x)
	{
		r2 = 90.0f;
		x2 = x + Taille_Fichier / 1.5f;
		z2 = z + Taille_Fichier / 1.5f;
	}
	else
	{
		r2 = 270.0f;
		x2 = x - Taille_Fichier / 1.5f;
		z2 = z - Taille_Fichier / 1.5f;
	}

	if(pow(cam->m_vPosition.z-z,2)<=2000.)
		d1 = deg - ( 2000. - pow(cam->m_vPosition.z-z,2) ) / 2000.0f;
	else d1 = deg;

	if(pow(cam->m_vPosition.x-x,2)<=2000.)
		d2 = deg - ( 2000. - pow(cam->m_vPosition.x-x,2) ) / 2000.0f;
	else d2 = deg;

//	deg = pow(deg, 2);
//	if(deg<=0.05f) return;

	if(tri[0]==TRI_TOP)
		Draw_Name(fich, x, z, deg, ry+180.);
	
	Draw_Fichier(fich, x, z, scale, deg, tri, sel);

	if(tri[0]!=TRI_TOP)
		Draw_Name(fich, x, z, deg, ry+180.);

	Draw_Attrib(fich, x1, z1, d1, r1);
	Draw_Attrib(fich, x2, z2, d2, r2);
}





void Dw_Back(float y, float s, float d, bool sel, CVertex c)
{
	glBegin(GL_QUADS);	
	Set_Fog(0.0f, d);
	glMultiTexCoord2fARB(GL_TEXTURE1_ARB,1.0f+cos(GetTickCount() * 0.0002f), 0.0f+sin(GetTickCount() * 0.0002f));
	glMultiTexCoord2fARB(GL_TEXTURE0_ARB,1.0f, 0.0f);     glVertex3f( s, 0.0f, -s);
	Set_Fog(y, d);
	glMultiTexCoord2fARB(GL_TEXTURE1_ARB,1.0f+cos(GetTickCount() * 0.0002f), 1.0f+sin(GetTickCount() * 0.0002f));
	glMultiTexCoord2fARB(GL_TEXTURE0_ARB,1.0f, 1.0f*y/s); glVertex3f( s,    y, -s); 
	Set_Fog(y, d);
	glMultiTexCoord2fARB(GL_TEXTURE1_ARB,0.0f+cos(GetTickCount() * 0.0002f), 1.0f+sin(GetTickCount() * 0.0002f));
	glMultiTexCoord2fARB(GL_TEXTURE0_ARB,0.0f, 1.0f*y/s); glVertex3f(-s,    y, -s);
	Set_Fog(0.0f, d);
	glMultiTexCoord2fARB(GL_TEXTURE1_ARB,0.0f+cos(GetTickCount() * 0.0002f), 0.0f+sin(GetTickCount() * 0.0002f));
	glMultiTexCoord2fARB(GL_TEXTURE0_ARB,0.0f, 0.0f);	  glVertex3f(-s, 0.0f, -s);
	glEnd();
}

void Dw_Top(float y, float s, float d, bool sel, CVertex c)
{
	glBegin(GL_QUADS);	
	Set_Fog(y, d);
	glMultiTexCoord2fARB(GL_TEXTURE1_ARB,0.0f+cos(GetTickCount() * 0.0002f), 1.0f+sin(GetTickCount() * 0.0002f));
	glMultiTexCoord2fARB(GL_TEXTURE0_ARB,0.0f, 1.0f);     glVertex3f( s, y,  s);
	Set_Fog(y, d);
	glMultiTexCoord2fARB(GL_TEXTURE1_ARB,0.0f+cos(GetTickCount() * 0.0002f), 0.0f+sin(GetTickCount() * 0.0002f));
	glMultiTexCoord2fARB(GL_TEXTURE0_ARB,0.0f, 0.0f);     glVertex3f( s, y, -s); 
	Set_Fog(y, d);
	glMultiTexCoord2fARB(GL_TEXTURE1_ARB,1.0f+cos(GetTickCount() * 0.0002f), 0.0f+sin(GetTickCount() * 0.0002f));
	glMultiTexCoord2fARB(GL_TEXTURE0_ARB,1.0f, 0.0f);     glVertex3f(-s, y, -s);
	Set_Fog(y, d);
	glMultiTexCoord2fARB(GL_TEXTURE1_ARB,1.0f+cos(GetTickCount() * 0.0002f), 1.0f+sin(GetTickCount() * 0.0002f));
	glMultiTexCoord2fARB(GL_TEXTURE0_ARB,1.0f, 1.0f);     glVertex3f(-s, y,  s);
	glEnd();
}

void Dw_Front(float y, float s, float d, bool sel, CVertex c)
{
	glBegin(GL_QUADS);	
	Set_Fog(0.0f, d);
	glMultiTexCoord2fARB(GL_TEXTURE1_ARB,1.0f+cos(GetTickCount() * 0.0002f), 0.0f+sin(GetTickCount() * 0.0002f));
	glMultiTexCoord2fARB(GL_TEXTURE0_ARB,1.0f, 0.0f);     glVertex3f(-s, 0.0f,  s);
	Set_Fog(y, d);
	glMultiTexCoord2fARB(GL_TEXTURE1_ARB,1.0f+cos(GetTickCount() * 0.0002f), 1.0f+sin(GetTickCount() * 0.0002f));
	glMultiTexCoord2fARB(GL_TEXTURE0_ARB,1.0f, 1.0f*y/s); glVertex3f(-s,    y,  s);
	Set_Fog(y, d);
	glMultiTexCoord2fARB(GL_TEXTURE1_ARB,0.0f+cos(GetTickCount() * 0.0002f), 1.0f+sin(GetTickCount() * 0.0002f));
	glMultiTexCoord2fARB(GL_TEXTURE0_ARB,0.0f, 1.0f*y/s); glVertex3f( s,    y,  s); 
	Set_Fog(0.0f, d);
	glMultiTexCoord2fARB(GL_TEXTURE1_ARB,0.0f+cos(GetTickCount() * 0.0002f), 0.0f+sin(GetTickCount() * 0.0002f));
	glMultiTexCoord2fARB(GL_TEXTURE0_ARB,0.0f, 0.0f);     glVertex3f( s, 0.0f,  s);
	glEnd();
}

void Dw_Left(float y, float s, float d, bool sel, CVertex c)
{
	glBegin(GL_QUADS);	
	Set_Fog(y, d);
	glMultiTexCoord2fARB(GL_TEXTURE1_ARB,1.0f+cos(GetTickCount() * 0.0002f), 1.0f+sin(GetTickCount() * 0.0002f));
	glMultiTexCoord2fARB(GL_TEXTURE0_ARB,1.0f, 1.0f*y/s); glVertex3f(-s,  y, -s);	
	Set_Fog(y, d);
	glMultiTexCoord2fARB(GL_TEXTURE1_ARB,0.0f+cos(GetTickCount() * 0.0002f), 1.0f+sin(GetTickCount() * 0.0002f));
	glMultiTexCoord2fARB(GL_TEXTURE0_ARB,0.0f, 1.0f*y/s); glVertex3f(-s,  y,  s); 
	Set_Fog(0.0f, d);
	glMultiTexCoord2fARB(GL_TEXTURE1_ARB,0.0f+cos(GetTickCount() * 0.0002f), 0.0f+sin(GetTickCount() * 0.0002f));
	glMultiTexCoord2fARB(GL_TEXTURE0_ARB,0.0f, 0.0f);     glVertex3f(-s, 0.0f,  s);
	Set_Fog(0.0f, d);
	glMultiTexCoord2fARB(GL_TEXTURE1_ARB,1.0f+cos(GetTickCount() * 0.0002f), 0.0f+sin(GetTickCount() * 0.0002f));
	glMultiTexCoord2fARB(GL_TEXTURE0_ARB,1.0f, 0.0f);     glVertex3f(-s, 0.0f, -s);		
	glEnd();
}


void Dw_Right(float y, float s, float d, bool sel, CVertex c)
{
	glBegin(GL_QUADS);	
	Set_Fog(0.0f, d);
	glMultiTexCoord2fARB(GL_TEXTURE1_ARB,0.0f+cos(GetTickCount() * 0.0002f), 0.0f+sin(GetTickCount() * 0.0002f));
	glMultiTexCoord2fARB(GL_TEXTURE0_ARB,0.0f, 0.0f);     glVertex3f( s, 0.0f, -s);
	Set_Fog(0.0f, d);
	glMultiTexCoord2fARB(GL_TEXTURE1_ARB,1.0f+cos(GetTickCount() * 0.0002f), 0.0f+sin(GetTickCount() * 0.0002f));
	glMultiTexCoord2fARB(GL_TEXTURE0_ARB,1.0f, 0.0f);     glVertex3f( s, 0.0f,  s);
	Set_Fog(y, d);
	glMultiTexCoord2fARB(GL_TEXTURE1_ARB,1.0f+cos(GetTickCount() * 0.0002f), 1.0f+sin(GetTickCount() * 0.0002f));
	glMultiTexCoord2fARB(GL_TEXTURE0_ARB,1.0f, 1.0f*y/s); glVertex3f( s,    y,  s); 
	Set_Fog(y, d);
	glMultiTexCoord2fARB(GL_TEXTURE1_ARB,0.0f+cos(GetTickCount() * 0.0002f), 1.0f+sin(GetTickCount() * 0.0002f));
	glMultiTexCoord2fARB(GL_TEXTURE0_ARB,0.0f, 1.0f*y/s); glVertex3f( s,    y, -s);
	glEnd();
}



void Set_Fog(float y, float d)
{
	glFogCoordfEXT((-(y-FogDepth))*d-5.0f);
}