#include "kexplo.h"


CCamera *cam;
GLuint Textures[6];
char Current_Path[4000];

Disk DiskList;

CRepertoire *Rep;


bool Enable_DiskList = false;
int Index_DiskList = 0;

int FileSelected;


void Look_Keyb();
void Test_Fichier(Fichier *fich);



void Explo()
{
	MSG msg;
	int i;
	int n = -1;

	List_Drives(&DiskList);
	
	if(DiskList.nb_drives<=0)
	{
		Error("Unable to find drives");
		return;
	}

	for(i=0 ; i<DiskList.nb_drives ; i++)
		if(DiskList.drives[i].name[0]=='c')
			n = i;

	if(n!=-1)
	{
		for(i=0 ; i<3 ; i++)
			Current_Path[i] = DiskList.drives[n].name[i]; 
		Current_Path[2] = '/';
		Current_Path[3] = '\0';
		Index_DiskList = n;
	}
	else
	{
		Current_Path[0] = '/';
		Current_Path[1] = '\0';
	}

	CreateTexture(Textures, "data/tex0.jpg", 0);
	CreateTexture(Textures, "data/tex1.jpg", 1);
	CreateTexture(Textures, "data/sel.jpg",  2);

	CreateTexture(TexSky, "data/sky.jpg",		0);

	Init_Colors();

	Rep = new CRepertoire(Current_Path);

	frustum = new CFrustum();


	CTimer time(20.0f);
	
	cam = new CCamera();
	cam->time = &time;
	cam->m_vPosition.x = -50.0f;
	cam->m_vPosition.y = 100.0f;
	cam->m_vPosition.z = -50.0f;
	cam->m_vView.x = -49.0f;
	cam->m_vView.y = 99.8f;
	cam->m_vView.z = -49.0f;
			

	while(K_EXIT==false)
	{
		if (PeekMessage (&msg, Konsole, 0, 0, PM_REMOVE) != 0)
		{	
			TranslateMessage(&msg); 
			DispatchMessage(&msg);
		}
		else
		{
			if(WActive==false)
			{
				WaitMessage ();	
			}
			else
			{
				glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);	
				
				time.Loop(false);
			
				glLoadIdentity();

				cam->Look();
				frustum->CalculateFrustum();
	
				FileSelected = Rep->Draw(1.0f);
				
				
				Look_Keyb();


				_print(10.0f, 11.0f, -30.0f, 1.0f, " %s", Current_Path);

				cam->Update();

				SwapBuffers(g_hDC);
			}
		}
	}
	
	Rep->~CRepertoire();

	cam->~CCamera();
}



bool KUP_    = false;
bool KDOWN_  = false;
bool KRIGHT_ = false;
bool KLBUT_  = false;


void Look_Keyb()
{
	int i;
	char newrep[512];
	int k = 0;
	int n = 0;
				

	// Affiche le curseur
	glLoadIdentity();
	glDisable(GL_DEPTH_TEST);
	glDisable(GL_TEXTURE_2D);
	glColor3f(0.2f, 0.2f, 0.2f);
	glEnable(GL_BLEND);
	glBlendFunc(GL_ONE, GL_ONE);
	glBegin(GL_QUADS);
	glVertex3f(-0.5f,  0.5f, -40.0f);
	glVertex3f( 0.5f,  0.5f, -40.0f);
	glVertex3f( 0.5f, -0.5f, -40.0f);
	glVertex3f(-0.5f, -0.5f, -40.0f);
	glEnd();
	glEnable(GL_DEPTH_TEST);
	glEnable(GL_TEXTURE_2D);
	glDisable(GL_BLEND);


	if(Mouse_Active==false)
	{
		if(Enable_DiskList==false)
		if( (GetKeyState(VK_UP) & 0x80) || (GetKeyState(VK_DOWN) & 0x80) )
		{
			Enable_DiskList = true;
			KUP_   = true;
			KDOWN_ = true;

			if(GetKeyState(VK_RIGHT) & 0x80)
				KRIGHT_ = true;
		}
	}
	else
	{
		Enable_DiskList = false;

		if( (GetKeyState(VK_LBUTTON) & 0x80) && KLBUT_ == false)
		{
			KLBUT_ = true;

		if(FileSelected!=-1)
		{
			// Changement de rpertoire
			if(Rep->Fichiers[FileSelected].att.dir==true)
			{
				k = 0;
				n = 0;

				while(Current_Path[k]!='\0')
				{
					newrep[k] = Current_Path[k];
					k++;
				}

				while(Rep->Fichiers[FileSelected].name[n]!='\0')
				{
					newrep[k] = Rep->Fichiers[FileSelected].name[n];
					n++;
					k++;
					if(k+1>=512) { Error("Too long path name"); K_EXIT = true; return; }
				}
				
				newrep[k] = '/';
				newrep[k+1] = '\0';

				if(chdir(newrep)==0)
				{
					k = 0;
					while(newrep[k]!='\0')
					{
						Current_Path[k] = newrep[k];
						k++;
					}

					Current_Path[k] = '\0';
					Rep->~CRepertoire();
					Rep = new CRepertoire(Current_Path);
					cam->m_vView -= cam->m_vPosition;	
					cam->m_vPosition.x = -50.0f;
					cam->m_vPosition.y = 100.0f;
					cam->m_vPosition.z = -50.0f;
					cam->m_vView += cam->m_vPosition;
				}
			}
			else
			{
				// Test des fichiers ( executer, lire ou autre...)
			
				Test_Fichier(&Rep->Fichiers[FileSelected]);
			}
		}
		}
	}



	if(Enable_DiskList==true)
	{
		// Affiche le chti cadre
		glLoadIdentity();
		glDisable(GL_DEPTH_TEST);
		glDisable(GL_TEXTURE_2D);
		glColor3f(0.1f, 0.0f, 0.3f);
		glEnable(GL_BLEND);
		glBlendFunc(GL_ONE, GL_ONE);
		glBegin(GL_QUADS);
		glVertex3f(-14.0f, 11.0f, -30.0f);
		glVertex3f(-10.0f, 11.0f, -30.0f);
		glVertex3f(-10.0f, 10.0f-DiskList.nb_drives*0.6f, -30.0f);
		glVertex3f(-14.0f, 10.0f-DiskList.nb_drives*0.6f, -30.0f);
		glEnd();
		glEnable(GL_DEPTH_TEST);
		glEnable(GL_TEXTURE_2D);
		glDisable(GL_BLEND);
		
		for(i=0 ; i<DiskList.nb_drives ; i++)
		{
			if(Index_DiskList!=i)
				_print(14.0f, 10.0f - i*0.6f, -30.0f, 1.0f, "  %s", DiskList.drives[i].name);
			else
				_print(14.0f, 10.0f - i*0.6f, -30.0f, 1.0f, "> %s", DiskList.drives[i].name);
		}

		if( (GetKeyState(VK_UP) & 0x80) && KUP_ == false )
		{
			Index_DiskList --;
			KUP_ = true;
		}

		if( (GetKeyState(VK_DOWN) & 0x80) && KDOWN_ == false )
		{
			Index_DiskList ++;
			KDOWN_ = true;
		}

		if(Index_DiskList<0) Index_DiskList = DiskList.nb_drives-1;
		if(Index_DiskList>DiskList.nb_drives-1) Index_DiskList = 0;

		
		if((GetKeyState(VK_RIGHT) & 0x80) && KRIGHT_ == false)
		{
			if(chdir(DiskList.drives[Index_DiskList].name)==0)
			{
				Enable_DiskList = false;
				for(i=0 ; i<3 ; i++)
					Current_Path[i] = DiskList.drives[Index_DiskList].name[i];
				Current_Path[2] = '/';
				Current_Path[3] = '\0';
				Rep->~CRepertoire();
				Rep = new CRepertoire(Current_Path);
				cam->m_vView -= cam->m_vPosition;
				cam->m_vPosition.x = -50.0f;
				cam->m_vPosition.y = 100.0f;
				cam->m_vPosition.z = -50.0f;
				cam->m_vView += cam->m_vPosition;
				Mouse_Active = true;
				ShowCursor(false);
				KRIGHT_ = true;
			}
		}
	}


	if( !(GetKeyState(VK_UP) & 0x80) )
		KUP_ = false;

	if( !(GetKeyState(VK_DOWN) & 0x80) )
		KDOWN_ = false;

	if( !(GetKeyState(VK_RIGHT) & 0x80) )
		KRIGHT_ = false;

	if( !(GetKeyState(VK_LBUTTON) & 0x80))
		KLBUT_ = false;

	if(cam->m_vPosition.y<100.0f)
		cam->kSpeed = 30.0f;
	else
		cam->kSpeed = 30.0f + pow((cam->m_vPosition.y-100.0f)/3., 2)/50.0f;

	if(cam->m_vPosition.y>1000.0f)
	{
		k = 0;
		while(Current_Path[k]!='\0') k++;
		n = k-2;
		while(Current_Path[n]!='/' && n-1 >= 0) n--;
		
		for(k=0 ; k<=n ; k++)
			newrep[k] = Current_Path[k];
		newrep[k] = '\0';

		if(chdir(newrep)==0 && n>1)
		{
			k=0;
			while(newrep[k]!='\0')
			{
				Current_Path[k] = newrep[k];
				k++;
			}
			
			Current_Path[k] = '\0';
		}
		else
		{
			if(n>0)
				Error("Directory error");
			n = -1;

			for(k=0 ; k<DiskList.nb_drives ; k++)
			if(DiskList.drives[k].name[0]=='c')
				n = k;

			if(n!=-1)
			{
				for(k=0 ; k<3 ; k++)
					Current_Path[k] = DiskList.drives[n].name[k]; 
				Current_Path[2] = '/';
				Current_Path[3] = '\0';
				Index_DiskList = n;
			}
			else
			{
				Current_Path[0] = '/';
				Current_Path[1] = '\0';
			}
		}	

		Rep->~CRepertoire();
		Rep = new CRepertoire(Current_Path);
		cam->m_vView -= cam->m_vPosition;
		cam->m_vPosition.x = -50.0f;
		cam->m_vPosition.y = 100.0f;
		cam->m_vPosition.z = -50.0f;
		cam->m_vView += cam->m_vPosition;
		cam->kSpeed = 30.0f;
	}
}






// Test des fichiers suivant les association
void Test_Fichier(Fichier *fich)
{
	int n = 0;
	
	// Calcul de la longueur du nom
	while(fich->name[n]!='\0') n++;
	
	// Y a t'il une extension win
	if(n<5) return;
	if(fich->name[n-4]!='.') return;
	

	// Executable normal
	if(fich->name[n-3]=='e') if(fich->name[n-2]=='x') if(fich->name[n-1]=='e')
	{
		ShellExecute(NULL, NULL, Rep->Fichiers[FileSelected].name, NULL, Current_Path, 1);
		Mouse_Active = false;
		ShowCursor(true);
		return;
	}

	// Command
	if(fich->name[n-3]=='c') if(fich->name[n-2]=='o') if(fich->name[n-1]=='m')
	{
		ShellExecute(NULL, NULL, Rep->Fichiers[FileSelected].name, NULL, Current_Path, 1);
		Mouse_Active = false;
		ShowCursor(true);
		return;
	}

	// Batch
	if(fich->name[n-3]=='b') if(fich->name[n-2]=='a') if(fich->name[n-1]=='t')
	{
		ShellExecute(NULL, NULL, Rep->Fichiers[FileSelected].name, NULL, Current_Path, 1);
		Mouse_Active = false;
		ShowCursor(true);
		return;
	}

	// Et les autres
	FILE *fic;
	char ligne[256];
	char soft[256];
	char param[256];

	fic = fopen("e:/prog/kexplo/data/kexplo.ini", "rt");
	
	fgets(ligne, 256, fic);

	int g,p,s;
			
	while(fgets(ligne, 256, fic)!=NULL)
	{
		if(ligne[0]==fich->name[n-3])
		if(ligne[1]==fich->name[n-2])
		if(ligne[2]==fich->name[n-1])
		{
			// Recherche du path du logiciel
			g = 4;
			p = strlen(ligne);

			while( g<p && ligne[g]!=' ')
			{
				soft[g-4] = ligne[g];
				if(soft[g-4]=='_')		// changement de caractre d'espacement
					soft[g-4] = ' ';
				g++;
			}
			soft[g-4] = '\0';
			
			// Recherche du/des paramtre/s
			
			if(g+1<p)
			{
				g++;
				s = 0;

				while(g<p)
				{
					param[s] = ligne[g];
					s++;
					g++;
				}
				param[s] = '\0';
			}
			else param[0] = '\0';

			g = 0;
			
			while(param[g]!='\0') g++;

			param[g] = '"';
			g++;
			p = 0;
			while(Current_Path[p]!='\0')
			{
				param[g] = Current_Path[p];
				g++;
				p++;
			}
			

			p = 0;
			while(fich->name[p]!='\0')
			{
				param[g] = fich->name[p];
				g++;
				p++;
			}

			param[g] = '"';
			param[g+1] = '\0';

			ShellExecute(NULL, NULL, soft, param, Current_Path, 1);
			
			if(!(ligne[0]=='m' && ligne[1]=='p' && ligne[2]=='3'))
			{
				Mouse_Active = false;
				ShowCursor(true);
			}

			return;
		}
	}

	fclose(fic);
}

