#include "kexplo.h"


CVertex C_READONLY;
CVertex C_HIDDEN;
CVertex C_SYSTEM;
CVertex C_ARCH;
CVertex C_TEMP;

CVertex C_DIR;
CVertex C_FILE;


// Initialisation des couleurs suivant les types
void Init_Colors()
{
	C_READONLY.x = 0.0f;	C_READONLY.y = 0.8f;	C_READONLY.z = 1.0f;
	C_HIDDEN.x   = 0.6f;	C_HIDDEN.y   = 0.2f;	C_HIDDEN.z   = 1.0f;
	C_SYSTEM.x   = 0.8f;	C_SYSTEM.y   = 0.0f;	C_SYSTEM.z   = 1.0f;
	C_ARCH.x     = 0.4f;	C_ARCH.y     = 0.4f;	C_ARCH.z     = 1.0f;	
	C_TEMP.x     = 0.6f;	C_TEMP.y     = 0.0f;	C_TEMP.z     = 1.0f;
	C_DIR.x      = 0.0f;	C_DIR.y      = 0.6f;	C_DIR.z      = 1.0f;
	C_FILE.x     = 0.0f;	C_FILE.y     = 0.0f;	C_FILE.z     = 1.0f;	
}


// Creer une couleur suivant les diffrents attributs
CVertex Calc_color(Attrib *att)
{
	CVertex c1 = 0.0f;
	CVertex c2 = 0.0f;

	if(att->dir==true) c1 = C_DIR;
	else c1 = C_FILE;

	if(att->archive==true)		c1 = C_ARCH;
	if(att->temporary==true)	c1 = C_TEMP;
	if(att->readonly==true)		c1 = C_READONLY;
	if(att->hidden==true)		c1 = C_HIDDEN;
	if(att->system==true)		c1 = C_SYSTEM;

	return c1;

	/*
	if(att->archive==true)		c2 += C_ARCH;
	if(att->hidden==true)		c2 += C_HIDDEN;
	if(att->readonly==true)		c2 += C_READONLY;
	if(att->system==true)		c2 += C_SYSTEM;
	if(att->temporary==true)	c2 += C_TEMP;

	if(c2.x>1.0f) c2.x = 1.0f;
	if(c2.y>1.0f) c2.y = 1.0f;
	if(c2.z>1.0f) c2.z = 1.0f;

	return ( c1 + c2 / 2.0f );
*/
}



// Creer une structure en triant les attributs 
Attrib Make_Attrib(unsigned long att)
{
	long a = att;
	Attrib attrib;
	
	attrib.archive   = false;
	attrib.dir	     = false;
	attrib.file		 = false;
	attrib.hidden	 = false;
	attrib.readonly	 = false;
	attrib.system	 = false;
	attrib.temporary = false;

	if(a-FILE_ATTRIBUTE_TEMPORARY>=0) { attrib.temporary = true; a -= FILE_ATTRIBUTE_TEMPORARY;	}
	if(a-FILE_ATTRIBUTE_NORMAL>=0)	  { attrib.file = true;		 a -= FILE_ATTRIBUTE_NORMAL;	}
	if(a-FILE_ATTRIBUTE_ARCHIVE>=0)	  { attrib.archive = true;   a -= FILE_ATTRIBUTE_ARCHIVE;	}
	if(a-FILE_ATTRIBUTE_DIRECTORY>=0) { attrib.dir = true;	     a -= FILE_ATTRIBUTE_DIRECTORY;	}
	if(a-FILE_ATTRIBUTE_SYSTEM>=0)    { attrib.system = true;	 a -= FILE_ATTRIBUTE_SYSTEM;	}
	if(a-FILE_ATTRIBUTE_HIDDEN>=0)    { attrib.hidden = true;	 a -= FILE_ATTRIBUTE_HIDDEN;	}
	if(a-FILE_ATTRIBUTE_READONLY>=0)  { attrib.readonly = true;	 a -= FILE_ATTRIBUTE_READONLY;	}

	return attrib;
}