#include "kexplo.h"


float g_FrameInterval = 0.0f;
float time;
float times;

bool rpress = false;

void CalculateFrameRate()
{
	static float framesPerSecond    = 0.0f;		// This will store our fps
    static float lastTime			= 0.0f;		// This will hold the time from the last frame
	static char strFrameRate[50] = {0};			// We will store the string here for the window title

	static float frameTime = 0.0f;				// This stores the last frame's time

    float currentTime = GetTickCount() * 0.01f;	//	timeGetTime() * 0.001f	
 	time = currentTime;
	if(times==0.0f) times = currentTime;

	g_FrameInterval = currentTime - frameTime;
	frameTime = currentTime;
    ++framesPerSecond;

    if( currentTime - lastTime > 1.0f )
    {
	    lastTime = currentTime;
		//sprintf(strFrameRate, "Current Frames Per Second: %d", int(framesPerSecond));
		//SetWindowText(g_hWnd, strFrameRate);
		framesPerSecond = 0;
    }
}


CCamera::CCamera()
{
	CVertex vZero = CVertex(0.0, 0.0, 1.0);		// Init a vVector to 0 0 0 for our position
	CVertex vView = CVertex(0.0, 0.0, 0.0);		// Init a starting view vVector (looking up and out the screen) 
	CVertex vUp   = CVertex(0.0, 1.0, 0.0);		// Init a standard up vVector (Rarely ever changes)

	m_vPosition	= vZero;					// Init the position to zero
	m_vView		= vView;					// Init the view to a std starting view
	m_vUpVector	= vUp;						// Init the UpVector

	col = true;

	kSpeed = 20.0f;
}


CCamera::~CCamera()
{
	int i;
}




void CCamera::PositionCamera(float positionX, float positionY, float positionZ,
				  		     float viewX,     float viewY,     float viewZ,
							 float upVectorX, float upVectorY, float upVectorZ)
{
	CVertex vPosition	= CVertex(positionX, positionY, positionZ);
	CVertex vView		= CVertex(viewX, viewY, viewZ);
	CVertex vUpVector	= CVertex(upVectorX, upVectorY, upVectorZ);

	m_vPosition = vPosition;					// Assign the position
	m_vView     = vView;						// Assign the view
	m_vUpVector = vUpVector;					// Assign the up vector

	RECT rec;
	GetClientRect(Konsole, &rec);				

	if(Mouse_Active==true)
		SetCursorPos(rec.right/2., rec.bottom/2.);
}


void CCamera::SetViewByMouse()
{
	RECT rec;
	GetClientRect(Konsole, &rec);				

	if(Mouse_Active==false) return;

	POINT mousePos;									// This is a window structure that holds an X and Y
	int middleX = rec.right >> 1;				// This is a binary shift to get half the width
	int middleY = rec.bottom >> 1;				// This is a binary shift to get half the height
	static float currentRotX = 0.0f;
	
	GetCursorPos(&mousePos);						
	
	if( (mousePos.x == middleX) && (mousePos.y == middleY) ) return;

	
	SetCursorPos(middleX, middleY);							

	angleY = (float)( (middleX - mousePos.x) ) / 300.0f;		
	angleZ = (float)( (middleY - mousePos.y) ) / 300.0f;		

	currentRotX -= angleZ;  
	
	if(currentRotX > PI / 2.0f)
		currentRotX = (float)PI / 2.0f;

	else if(currentRotX < -PI / 2.0f)
		currentRotX = -(float)PI / 2.0f;
	else
	{
		CVertex vAxis;
		ASMCrossProduct(m_vView - m_vPosition, m_vUpVector, vAxis);
		vAxis = Normalize(vAxis);
		
		RotateView(angleZ, vAxis.x, vAxis.y, vAxis.z);
		RotateView(angleY, 0, 1, 0);
	}

}



void CCamera::RotateView(float angle, float x, float y, float z)
{
	CVertex vNewView;

	CVertex vView = m_vView - m_vPosition;		

	float cosTheta = (float)cos(angle);
	float sinTheta = (float)sin(angle);

	vNewView.x  = (cosTheta + (1 - cosTheta) * x * x)		* vView.x;
	vNewView.x += ((1 - cosTheta) * x * y - z * sinTheta)	* vView.y;
	vNewView.x += ((1 - cosTheta) * x * z + y * sinTheta)	* vView.z;

	vNewView.y  = ((1 - cosTheta) * x * y + z * sinTheta)	* vView.x;
	vNewView.y += (cosTheta + (1 - cosTheta) * y * y)		* vView.y;
	vNewView.y += ((1 - cosTheta) * y * z - x * sinTheta)	* vView.z;

	vNewView.z  = ((1 - cosTheta) * x * z - y * sinTheta)	* vView.x;
	vNewView.z += ((1 - cosTheta) * y * z + x * sinTheta)	* vView.y;
	vNewView.z += (cosTheta + (1 - cosTheta) * z * z)		* vView.z;

	m_vView = m_vPosition + vNewView;
}



void CCamera::StrafeCamera(float speed)
{	
	m_vPosition.x += m_vStrafe.x * speed;
	m_vPosition.z += m_vStrafe.z * speed;

	m_vView.x += m_vStrafe.x * speed;
	m_vView.z += m_vStrafe.z * speed;
}



void CCamera::MoveCamera(float speed)
{
	CVertex vVector = m_vView - m_vPosition;
	vVector = Normalize(vVector);

	m_vPosition.x += vVector.x * speed;		
	m_vPosition.y += vVector.y * speed;		
	m_vPosition.z += vVector.z * speed;		
	m_vView.x += vVector.x * speed;			
	m_vView.y += vVector.y * speed;			
	m_vView.z += vVector.z * speed;			
}




void CCamera::CheckForMovement()
{	
	float speed = kSpeed * g_FrameInterval;

	if((GetKeyState(VK_RBUTTON) & 0x80) && rpress==false) {
		if(Mouse_Active==true)
			Mouse_Active = false;
		else Mouse_Active = true;
		rpress = true;
	
		if(Mouse_Active==true)
			ShowCursor(false);
		else
			ShowCursor(true);
	}

	if(!(GetKeyState(VK_RBUTTON) & 0x80)) rpress = false;

	
	if(Mouse_Active==false)
		return;


	if(GetKeyState(VK_UP) & 0x80) {				
		MoveCamera(speed);				
	}

	if(GetKeyState(VK_DOWN) & 0x80) {			

		MoveCamera(-speed);				
	}
	
	if(GetKeyState(VK_LEFT) & 0x80) {			

		StrafeCamera(-speed);
	}

	if(GetKeyState(VK_RIGHT) & 0x80) {			

		StrafeCamera(speed);
	}
}



void CCamera::Update() 
{
	CVertex vCross;
	
	ASMCrossProduct(m_vView - m_vPosition, m_vUpVector, vCross);

	m_vStrafe = Normalize(vCross);

	if(Mouse_Active==true)
		SetViewByMouse();

	CheckForMovement();

	CalculateFrameRate();
}


void CCamera::Look()
{
	gluLookAt(m_vPosition.x, m_vPosition.y, m_vPosition.z,	
			  m_vView.x,	 m_vView.y,     m_vView.z,	
			  m_vUpVector.x, m_vUpVector.y, m_vUpVector.z);

}


float CCamera::Ry()
{
	CVertex v1, v2;

	v1.x = m_vView.x - m_vPosition.x;
	v1.y = 0.0f;
	v1.z = m_vView.z - m_vPosition.z;
	v2.x = 0.0f;
	v2.y = 0.0f;
	v2.z = 1.0f;

	return (float)( - AngleBetweenVectors(v1, v2) * 180. / 3.14 + 180. );
}




