#include "ptc.h"
#include "fmod.h"
#include "stdio.h"
#include "gfx/head/sound.h"
#include "gfx/head/buf.h"
#include "gfx/head/video.h"
#include "gfx/head/map.h"
#include "world/head/world.h"
#include "gfx/head/sprite.h"
#include "world/head/effect.h"
#include "world/head/weapon.h"
#include "world/head/item.h"
#include "world/head/entity.h"


Entity *Player2;
Entity *Player;


State::State()
{
	jump = 0;
	up = 0;
	fire = 0;
	weap_ud = 0;
	right = 0;
	jetpack = FALSE;
	telep = 0;
}

State::Init()
{
	jump = 0;
	up = 0;
	fire = 0;
	weap_ud = 0;
	right = 0;
	jetpack = FALSE;
	telep = 0;
}


Pack::Pack()
{
	health = 100;
	frags = 0;
	reload = 0;
	weap_sel = -1;
	_weapon[0] = TRUE;
	_weapon[1] = FALSE;
	_weapon[2] = FALSE;
	_weapon[3] = FALSE;
	_weapon[4] = FALSE;
	_weapon[5] = FALSE;
	_weapon[6] = FALSE;
	_weapon[7] = FALSE;
	_weapon[8] = FALSE;
	_weapon[9] = FALSE;
	_ammo[0] = 50;
	_ammo[1] = 0;
	_ammo[2] = 0;
	_ammo[3] = 0;
	_ammo[4] = 0;
}


Pack::Init()
{
	health = 100;
	reload = 0;
	weap_sel = -1;
	_weapon[0] = TRUE;
	_weapon[1] = FALSE;
	_weapon[2] = FALSE;
	_weapon[3] = FALSE;
	_weapon[4] = FALSE;
	_weapon[5] = FALSE;
	_weapon[6] = FALSE;
	_weapon[7] = FALSE;
	_weapon[8] = FALSE;
	_weapon[9] = FALSE;
	_ammo[0] = 50;
	_ammo[1] = 0;
	_ammo[2] = 0;
	_ammo[3] = 0;
	_ammo[4] = 0;
}


Entity::Entity(char filename[])
{
	FILE *fich;	
	char chaine[200];

	xe = 0.;
	ye = 0.;
	speed = 1.;
	gravity = 1.;
	
	fich = fopen(filename,"rt");
	fscanf(fich,"%s",&name);
	fscanf(fich,"%s",&chaine);
	skin  = new Sprite(25, 40, chaine);
	fscanf(fich,"%s",&chaine);
	BSounds->smpls[BSounds->n_snd].snd = FSOUND_Sample_Load(FSOUND_UNMANAGED, chaine, FSOUND_NORMAL, 0);	
	sample = BSounds->n_snd;
	BSounds->n_snd++;
	fclose(fich);

	state = new State();
	pack  = new Pack();
	nume = num_ent;
	num_ent++;
}


Entity::~Entity()
{
	skin->~Sprite();
}


Entity::Start()
{
	int s;
	s = rnd(Items->nsp);
	xe = (float)(Items->Item[s].x);
	ye = (float)(Items->Item[s].y);

	speed = 1.;
	gravity = 1.;
	state->Init();
	pack->Init();
}



Entity::ChangeWeap(int n)
{
	pack->weap_sel+=n;
	if(pack->weap_sel>LIGHTNING_GUN) pack->weap_sel=-1;
	if(pack->weap_sel<-1) pack->weap_sel=LIGHTNING_GUN;
	
	if(pack->weap_sel>-1)
	if(pack->_weapon[pack->weap_sel]==FALSE)
		ChangeWeap(n);
}



Entity::Move()
{
	int b,d;
	float up, right;
	
	if(state->telep>0.)
		state->telep-=world_speed;

	skin->xs = (int)(xe);
	skin->ys = (int)(ye);
	

	if(state->weap_ud==1)
	{
		ChangeWeap(1);
		if(pack->weap_sel>-1)
		{
			if(pack->_ammo[Weaps->weaps[pack->weap_sel].ammotype]>0)
				BSounds->Add((int)(xe), (int)(ye), SND_CHANGE);
			else BSounds->Add((int)(xe), (int)(ye), SND_NOAMMO);
		}
	}

	if(state->weap_ud==2)
	{
		ChangeWeap(-1);
		if(pack->weap_sel>-1)
		{
			if(pack->_ammo[Weaps->weaps[pack->weap_sel].ammotype]>0)
				BSounds->Add((int)(xe), (int)(ye), SND_CHANGE);
			else BSounds->Add((int)(xe), (int)(ye), SND_NOAMMO);
		}
	}
	

	if(pack->reload>0.) pack->reload-=world_speed;
	else if(state->fire==1 && pack->weap_sel>-1)
		{
			if(pack->_ammo[Weaps->weaps[pack->weap_sel].ammotype]>=Weaps->weaps[pack->weap_sel].mun)
			{
				pack->reload = (float)(Weaps->weaps[pack->weap_sel].treload);
		
				if(Weaps->num<1000)
				{
					if(skin->framey==2)
					{
						Weaps->Proj[Weaps->num].x = (float)(xe-30.);
						Weaps->Proj[Weaps->num].ax = (float)(-Weaps->weaps[pack->weap_sel].speed);
					}
					else
					{
						Weaps->Proj[Weaps->num].x = (float)(xe+35.);
						Weaps->Proj[Weaps->num].ax = (float)(Weaps->weaps[pack->weap_sel].speed);
					}
				
					Weaps->Proj[Weaps->num].y = (float)(ye - 20.);
					Weaps->Proj[Weaps->num].ay = 0;
					Weaps->Proj[Weaps->num].atype = Weaps->weaps[pack->weap_sel].ammotype;
					Weaps->Proj[Weaps->num].ent = nume;
					Weaps->num++;
				
					if(pack->weap_sel==SHOTGUN)
					{
						Weaps->Proj[Weaps->num] = Weaps->Proj[Weaps->num-1];
						Weaps->Proj[Weaps->num-1].y -= 3;
						Weaps->Proj[Weaps->num].y += 3;
						Weaps->Proj[Weaps->num].ent = nume;
						Weaps->num++;
					}
					
					if(pack->weap_sel==LIGHTNING_GUN)
					{
						if(skin->framey==3)
							Effect_Foudre((int)(ye-map->ym-25), (int)(xe-map->xm)+40, (int)(xe-map->xm)+100+rnd(60), 4, 1, 50, 100, 100);
						else
							Effect_Foudre((int)(ye-map->ym-25), (int)(xe-map->xm)-20, (int)(xe-map->xm)-100-rnd(60), 4, 1, 50, 100, 100);
					}

					BSounds->Add((int)(xe), (int)(ye), pack->weap_sel+3);
			
					pack->_ammo[Weaps->weaps[pack->weap_sel].ammotype]-=Weaps->weaps[pack->weap_sel].mun;
				}
			}
		}

	


	if(state->jetpack)
	{
		if(state->up==0)
		if(!skin->Contact(2)) state->up=-1;
	}
	else
	{
		if(state->jump>0.)
		{
			state->up=(int)(state->jump/10.);
			state->jump-=speed * world_speed;
			if(skin->Contact(0))
			{
				state->jump=0.;
				state->up=0;
			}
		}
		else 
		{
			if(skin->Contact(2))
			{
				if(state->up==1)
				{
					state->jump = 30.;
					BSounds->Add((int)(xe), (int)(ye), sample);
				}
			}
			else state->up=-1;	
		}
	
	}

	right = (float)(state->right*2.) * speed * world_speed;
	up = (float)(state->up) * gravity * world_gravity; //(world_speed*speed);

	if((float)((int)(right))>0.)
	{
		d=(int)(right);
		for(b=0 ; b<d ; b++)
			if(!skin->Contact(1))
			{
				xe+=right/((float)(d));
				skin->xs = (int)(xe);
				skin->ys = (int)(ye);
				if(skin->anim<9.5) skin->anim+=.07*world_speed*speed;
				else skin->anim=0.;
			}
		skin->framey = 1;
	}
	
	if((float)((int)(right))<0.)
	{
		d=-(int)(right);
		for(b=0 ; b<d ; b++)
			if(!skin->Contact(3))
			{
				xe+=right/((float)(d));
				skin->xs = (int)(xe);
				skin->ys = (int)(ye);
				if(skin->anim<9.5) skin->anim+=.07*world_speed*speed;
				else skin->anim=0.;
			}
		skin->framey = 0;
	}
	
	if((float)((int)(up))>0.)
	{
		d=(int)(up);
		for(b=0 ; b<d*speed*world_speed ; b++)
			if(!skin->Contact(0))
			{
				ye-=up/((float)(d));
				skin->ys = (int)(ye);
				skin->xs = (int)(xe);
			}
	}
	if((float)((int)(up))<0.)
	{
		d=-(int)(up);
		for(b=0 ; b<d*speed*world_speed ; b++)
			if(!skin->Contact(2))
			{
				ye-=up/((float)(d));
				skin->ys = (int)(ye);
				skin->xs = (int)(xe);
			}
	}
	
	if(pack->weap_sel>-1 && skin->framey<2) skin->framey+=2;
	if(pack->weap_sel==-1 && skin->framey>1) skin->framey-=2;
	skin->framex = (int)(skin->anim);
	if(skin->framex>9) skin->framex=0;
}



Entity::Draw()
{
	skin->xs = (int)(xe)-map->xm;
	skin->ys = (int)(ye)-map->ym;
	skin->Show();
	
	if(pack->weap_sel>-1)
	{
		if(skin->framey==2)	Weaps->sprite->xs = (int)(xe)-map->xm-15;
		else Weaps->sprite->xs = (int)(xe)-map->xm+20;
		Weaps->sprite->ys = (int)(ye)-map->ym-20;
		Weaps->sprite->framex = pack->weap_sel;
		Weaps->sprite->framey = skin->framey;
		Weaps->sprite->Show();
	}
}


Entity::Eyes()
{
	map->xm = (int)(xe)-160;
	map->ym = (int)(ye)-100;
	map->Eye();
}


