#include "ptc.h"
#include "fmod.h"
#include "gfx/head/sound.h"
#include "gfx/head/buf.h"
#include "gfx/head/video.h"
#include "gfx/head/map.h"
#include "world/head/world.h"
#include "gfx/head/sprite.h"
#include "world/head/effect.h"
#include "world/head/weapon.h"
#include "world/head/item.h"
#include "world/head/entity.h"
#include "gfx/head/police.h"
#include "world/head/bot.h"


Bots *bots;
Scores *scores;



Bots::Bots()
{
	bot = new Bot[20];
	num = 0;
}


Bots::~Bots()
{
	delete[] bot;
	num = 0;
}


Bots::Add(char filename[])
{
	bot[num].ent = new Entity(filename);
	num++;
}


Bots::Remove()
{
	for(int i=0 ; i<num ; i++)
		bot[i].ent->~Entity();
}


Bots::BMove()
{
	for(int i=0 ; i<num ; i++)
	{
		BImpulse(i);
		bot[i].ent->Move();
		Items->Update(bot[i].ent);
		Weaps->UpdateEnt(bot[i].ent);
	}	
}


Bots::Draw()
{
	for(int i=0 ; i<num ; i++)
	{
		bot[i].ent->Draw();
	}
}



Bots::BStart()
{
	for(int i=0 ; i<num ; i++)
	{
		bot[i].ent->Start();
		bot[i].ent->state->right = -1;
		bot[i].j = 0;
	}
}



Bots::BImpulse(int i)
{
	bot[i].ent->state->up = 0;
	bot[i].ent->state->weap_ud = 0;
	bot[i].ent->state->fire = 0;


	bot[i].ent->skin->xs = (int)(bot[i].ent->xe);
	bot[i].ent->skin->ys = (int)(bot[i].ent->ye);

	BFire(i, *Player);
				
	if(dplayer==1)
		BFire(i, *Player2);

	for(int j=0 ; j<num ; j++)
		if(j!=i)
			BFire(i, *bot[j].ent);
	

	if(bot[i].ent->state->right==0)
		bot[i].ent->state->right = -1;

	if(bot[i].ent->state->right==-1)
	{
		if(bot[i].j==1 && bot[i].ent->state->jump<=0)
		{
			bot[i].j=0;
			if(bot[i].ent->skin->Contact(3) && rnd(10)>5)
				bot[i].ent->state->right = 1;
		}
		else	if(bot[i].ent->skin->Contact(3) && bot[i].j==0)
				{
					bot[i].ent->state->up = 1;
					bot[i].j=1;
				}
	}

	
	if(bot[i].ent->state->right==1)
	{
		if(bot[i].j==1 && bot[i].ent->state->jump<=0)
		{
			bot[i].j=0;
			if(bot[i].ent->skin->Contact(1) && rnd(10)>5)
				bot[i].ent->state->right = -1;
		}
		else	if(bot[i].ent->skin->Contact(1) && bot[i].j==0)
				{
					bot[i].ent->state->up = 1;
					bot[i].j=1;
				}
	}

	if(rnd(200)>195)
		bot[i].ent->state->up = 1;
	//if(rnd(20)>15 && bot[i].ent->pack->weap_sel<PLASMAGUN)
	//	bot[i].ent->state->fire = 1;
	if(rnd(200)>195)
		bot[i].ent->state->right = -bot[i].ent->state->right;

	for(int m=0 ; m<=LIGHTNING_GUN ; m++)
		if(bot[i].ent->pack->_weapon[m])
		if(bot[i].ent->pack->_ammo[Weaps->weaps[m].ammotype]>=Weaps->weaps[m].mun)
			bot[i].ent->pack->weap_sel = m;
}



Bots::BFire(int i, Entity & ent)
{
	if(ent.xe>bot[i].ent->xe+25)
	if(ent.xe<bot[i].ent->xe+250)
	if(ent.ye>bot[i].ent->ye-50)
	if(ent.ye<bot[i].ent->ye+50)
	{
		if(bot[i].ent->state->right==1)
			bot[i].ent->state->fire = 1;
		else	if(SKILL>HURT_ME_PLENTY)
				{
					bot[i].ent->state->right = -1;
				}	
	}

	if(ent.xe<bot[i].ent->xe-5)
	if(ent.xe>bot[i].ent->xe-250)
	if(ent.ye>bot[i].ent->ye-50)
	if(ent.ye<bot[i].ent->ye+50)
	{
		if(bot[i].ent->state->right==-1)
			bot[i].ent->state->fire = 1;
		else	if(SKILL>HURT_ME_PLENTY)
				{
					bot[i].ent->state->right = 1;
				}	
	}	
}





Scores::Scores()
{
	ns = 0;

	dat = new score[22];

	dat[ns].n = Player->nume;
	dat[ns].frag = 0;
	dat[ns].name = Player->name;
	ns++;

	if(dplayer==1)
	{
		dat[ns].n = Player2->nume;
		dat[ns].frag = 0;
		dat[ns].name = Player2->name;
		ns++;
	}

	for(int m=0 ; m<bots->num ; m++)
	{
		dat[ns].n = bots->bot[m].ent->nume;
		dat[ns].name = bots->bot[m].ent->name;
		dat[ns].frag = 0;
		ns++;
	}
}


Scores::~Scores()
{
	delete[] dat;
	ns = 0;
}


Scores::Update(int n, int f)
{
	int k;
	score tmp;

	for(int p=0 ; p<ns ; p++)
		if(n==dat[p].n)
			k = p;

	dat[k].frag+=f;
	if(dat[k].frag==17) BSounds->Add(-1, -1, SND_THREFRAGS);
	if(dat[k].frag==18) BSounds->Add(-1, -1, SND_TWOFRAGS);
	if(dat[k].frag==19) BSounds->Add(-1, -1, SND_ONEFRAG);
	if(dat[k].frag==20)
	{
		BSounds->Add(-1, -1, SND_PERFECT);
		endmatch = 1;
	}		

	if(f>0 && k>0)
	{
		while(dat[k].frag>=dat[k-1].frag && k-1>=0)
		{
			tmp = dat[k-1];
			dat[k-1] = dat[k];
			dat[k] = tmp;
			k--;
		}
		if(k==0)
		{
			if(dplayer==0)
			{
				if(n==Player->nume)
					BSounds->Add(-1, -1, SND_TAKELEAD);
				else if(dat[1].n==Player->nume)
						BSounds->Add(-1, -1, SND_LOSTLEAD);
			}
			else
			{
				if(n==Player->nume || n==Player2->nume)
					BSounds->Add(-1, -1, SND_TAKELEAD);
				else if(dat[1].n==Player->nume || dat[1].n==Player2->nume)
						BSounds->Add(-1, -1, SND_LOSTLEAD);
			}
		}
	}

	if(f<0 && k<ns-1)
	{
		while(dat[k].frag<=dat[k+1].frag && k+1<=ns-1)
		{
			tmp = dat[k+1];
			dat[k+1] = dat[k];
			dat[k] = tmp;
			k++;
		}
	}
}


Scores::Show()
{
	int max, p;
	
	if(ns<5) max = ns;
	else max = 5;

	for(p=0 ; p<max ; p++)
	{
		police->BlitTxt(dat[p].name, 10, 30+p*25, 10);
		police->BlitInt(dat[p].frag, 190, 30+p*25, 15);
	}
}



