#include "ptc.h"
#include "stdio.h"
#include "string.h"
#include "fstream.h"
#include "gfx/head/buf.h"
#include "gfx/head/video.h"
#include "inter/head/pol.h"


BPolice *bpolice;
BSkin *bskins;
BMaps *bmaps;


BSprite::BSprite(int w, int h, char filename[], int t)
{
	width = w;
	height = h;
	xs = 0;
	ys = 0;
	framex = 0;
	framey = 0;
	anim = 0.;
	buf = new Buf(640-320*t, 400-200*t, filename);
}


BSprite::~BSprite()
{
	buf->~Buf();
}


BSprite::BShow(Buf & out, int t)
{
	int i,j;
	int sx,sy;
	int ex,ey;
	int poso, poss;
	int l;
	
	sx = xs;
	sy = ys-height;
	ex = xs+width;
	ey = ys;
	
	if(t==0)
	{
		poss = Smu640[Sln640[framey*height]+framex*width];
		l = 640*3-(ex-sx)*3;
	}
	else
	{
		poss = PAdr(framex*width, framey*height);
		l = 320*3-(ex-sx)*3;
	}
	

	for(j=sy ; j<ey ; j++)
	{
		for(i=sx ; i<ex ; i++)
		{
			poso = Smu640[Sln640[j]+i];
			if(!(buf->dat[poss+RED]==0 && buf->dat[poss+GREEN]==0 && buf->dat[poss+BLUE]==0))
			{
				out.dat[poso+RED] = buf->dat[poss+RED];
				out.dat[poso+GREEN] = buf->dat[poss+GREEN];
				out.dat[poso+BLUE] = buf->dat[poss+BLUE];
			}
			poss+=3;
		}
		poss+=l;
	}	
}




	

BPolice::BPolice(char filename[])
{
	bmp = new BSprite(20, 50, filename, 0);
	polh = 50;
}


BPolice::~BPolice()
{
	bmp->~BSprite();
	polh = 0;
}



BPolice::BBlitTxt(char texte[], int x, int y, Buf & out, int m)
{
	int i;

	bmp->width = 20;
	bmp->height = 50;
	bmp->framey = m;

	for(i=0 ; i<int(strlen(texte)) ; i++)
	{
		if(texte[i]!=' ')
		{
			bmp->xs = x + (20*i);
			bmp->ys = y;
			bmp->framex = texte[i] - 'a';
			bmp->BShow(out, 0);
		}
	}
}




BSkin::BSkin(char filename[])
{
	FILE *fichier;
	char chaine[50];
	int n;

	fichier = fopen(filename,"rt");
	fscanf(fichier,"%i",&num);
	
	skins = new Skin[num];

	for(n=0 ; n<num ; n++)
	{
		fscanf(fichier,"%s",&skins[n].name);
		fscanf(fichier,"%s",&chaine);
		skins[n].screen = new BSprite(50, 80, chaine, 1);
		fscanf(fichier,"%s",&skins[n].spath);
	}

	fclose(fichier);
}


BSkin::~BSkin()
{
	delete[] skins;
	num = 0;
}



BMaps::BMaps(char filename[])
{
	FILE *fichier;
	char chaine[50];
	int n;

	fichier = fopen(filename,"rt");
	fscanf(fichier,"%i",&num);
	
	bmap = new BMap[num];

	for(n=0 ; n<num ; n++)
	{
		fscanf(fichier,"%s",&bmap[n].name);
		fscanf(fichier,"%s",&chaine);
		bmap[n].screen = new BSprite(100, 100, chaine, 1);
		fscanf(fichier,"%s",&bmap[n].spath);
	}

	fclose(fichier);
}


BMaps::~BMaps()
{
	delete[] bmap;
	num = 0;
}

