/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.net.AssetURLContext;
import com.jogamp.common.nio.Buffers;
import com.jogamp.common.os.MachineDescription;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.JarUtil;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.common.util.SecurityUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.security.Permission;
import java.util.regex.Pattern;
import jogamp.common.Debug;
import jogamp.common.os.AndroidUtils;
import jogamp.common.os.PlatformPropsImpl;

public class IOUtil {
    public static final boolean DEBUG = Debug.debug("IOUtil");
    public static final String SCHEME_SEPARATOR = ":";
    public static final String FILE_SCHEME = "file";
    public static final String HTTP_SCHEME = "http";
    public static final String HTTPS_SCHEME = "https";
    public static final String JAR_SCHEME = "jar";
    public static final char JAR_SCHEME_SEPARATOR = '!';
    private static final String java_io_tmpdir_propkey = "java.io.tmpdir";
    private static final String user_home_propkey = "user.home";
    private static final String XDG_CACHE_HOME_envkey = "XDG_CACHE_HOME";
    public static final String tmpSubDir = "jogamp";
    private static final Pattern patternSpaceRaw = Pattern.compile(" ");
    private static final Pattern patternSpaceEnc = Pattern.compile("%20");
    private static final Pattern patternSingleBS = Pattern.compile("\\\\{1,}");
    private static final Pattern patternSingleFS = Pattern.compile("/{1,}");
    private static File tempRootExec = null;
    private static File tempRootNoexec = null;
    private static volatile boolean tempRootSet = false;

    private IOUtil() {
    }

    private static final Constructor<?> getFOSCtor() {
        Throwable throwable;
        Constructor<?> constructor;
        try {
            constructor = ReflectionUtil.getConstructor("java.io.FileOutputStream", new Class[]{File.class}, IOUtil.class.getClassLoader());
            throwable = null;
        }
        catch (Throwable throwable2) {
            constructor = null;
            throwable = throwable2;
        }
        if (DEBUG) {
            System.err.println("IOUtil: java.io.FileOutputStream available: " + (null != constructor));
            if (null != throwable) {
                throwable.printStackTrace();
            }
        }
        return constructor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyURLConn2File(URLConnection uRLConnection, File file) throws IOException {
        uRLConnection.connect();
        int n = 0;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        try {
            n = IOUtil.copyStream2File(bufferedInputStream, file, uRLConnection.getContentLength());
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyStream2File(InputStream inputStream, File file, int n) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        try {
            n = IOUtil.copyStream2Stream(inputStream, bufferedOutputStream, n);
        }
        finally {
            ((OutputStream)bufferedOutputStream).close();
        }
        return n;
    }

    public static int copyStream2Stream(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        return IOUtil.copyStream2Stream(Platform.getMachineDescription().pageSizeInBytes(), inputStream, outputStream, n);
    }

    public static int copyStream2Stream(int n, InputStream inputStream, OutputStream outputStream, int n2) throws IOException {
        int n3;
        byte[] byArray = new byte[n];
        int n4 = 0;
        while ((n3 = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n3);
            n4 += n3;
        }
        return n4;
    }

    public static byte[] copyStream2ByteArray(InputStream inputStream) throws IOException {
        byte[] byArray;
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        int n = 0;
        int n2 = inputStream.available();
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        do {
            if (n + n2 > byArray2.length) {
                byArray = new byte[n + n2];
                System.arraycopy(byArray2, 0, byArray, 0, n);
                byArray2 = byArray;
            }
            if ((n3 = inputStream.read(byArray2, n, n2)) < 0) continue;
            n += n3;
        } while ((n2 = inputStream.available()) > 0 && n3 >= 0);
        if (n != byArray2.length) {
            byArray = new byte[n];
            System.arraycopy(byArray2, 0, byArray, 0, n);
            byArray2 = byArray;
        }
        return byArray2;
    }

    public static ByteBuffer copyStream2ByteBuffer(InputStream inputStream) throws IOException {
        return IOUtil.copyStream2ByteBuffer(inputStream, -1);
    }

    public static ByteBuffer copyStream2ByteBuffer(InputStream inputStream, int n) throws IOException {
        int n2;
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        if (n < (n2 = inputStream.available())) {
            n = n2;
        }
        MachineDescription machineDescription = Platform.getMachineDescription();
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(machineDescription.pageAlignedSize(n));
        byte[] byArray = new byte[machineDescription.pageSizeInBytes()];
        int n3 = Math.min(machineDescription.pageSizeInBytes(), n2);
        int n4 = 0;
        do {
            if (n2 > byteBuffer.remaining()) {
                ByteBuffer byteBuffer2 = Buffers.newDirectByteBuffer(machineDescription.pageAlignedSize(byteBuffer.position() + n2));
                byteBuffer2.put(byteBuffer);
                byteBuffer = byteBuffer2;
            }
            if ((n4 = inputStream.read(byArray, 0, n3)) > 0) {
                byteBuffer.put(byArray, 0, n4);
            }
            n2 = inputStream.available();
            n3 = Math.min(machineDescription.pageSizeInBytes(), n2);
        } while (n4 > 0);
        byteBuffer.flip();
        return byteBuffer;
    }

    public static String slashify(String string, boolean bl, boolean bl2) throws URISyntaxException {
        String string2 = string.replace('\\', '/');
        if (bl && !string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        if (bl2 && !string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        return IOUtil.cleanPathString(string2);
    }

    public static URI toURISimple(File file) throws URISyntaxException {
        return new URI(FILE_SCHEME, null, IOUtil.slashify(file.getAbsolutePath(), true, file.isDirectory()), null);
    }

    public static URI toURISimple(String string, String string2, boolean bl) throws URISyntaxException {
        return new URI(string, null, IOUtil.slashify(new File(string2).getAbsolutePath(), true, bl), null);
    }

    public static String getFileSuffix(File file) {
        return IOUtil.getFileSuffix(file.getName());
    }

    public static String getFileSuffix(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return null;
        }
        return IOUtil.toLowerCase(string.substring(n + 1));
    }

    private static String toLowerCase(String string) {
        if (string == null) {
            return null;
        }
        return string.toLowerCase();
    }

    public static FileOutputStream getFileOutputStream(File file, boolean bl) throws IOException {
        Constructor<?> constructor = IOUtil.getFOSCtor();
        if (null == constructor) {
            throw new IOException("Cannot open file (" + file + ") for writing, FileOutputStream feature not available.");
        }
        if (file.exists() && !bl) {
            throw new IOException("File already exists (" + file + ") and overwrite=false");
        }
        try {
            return (FileOutputStream)constructor.newInstance(file);
        }
        catch (Exception exception) {
            throw new IOException("error opening " + file + " for write. ", exception);
        }
    }

    public static String getClassFileName(String string) {
        return string.replace('.', '/') + ".class";
    }

    public static URL getClassURL(String string, ClassLoader classLoader) throws IOException {
        URL uRL = classLoader.getResource(IOUtil.getClassFileName(string));
        if (null == uRL) {
            throw new IOException("Cannot not find: " + string);
        }
        return uRL;
    }

    public static String getBasename(String string) throws URISyntaxException {
        int n = (string = IOUtil.slashify(string, false, false)).lastIndexOf(47);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public static String getDirname(String string) throws URISyntaxException {
        int n = (string = IOUtil.slashify(string, false, false)).lastIndexOf(47);
        if (n >= 0) {
            string = string.substring(0, n + 1);
        }
        return string;
    }

    public static URI getURIDirname(URI uRI) throws IllegalArgumentException, URISyntaxException {
        if (null == uRI) {
            throw new IllegalArgumentException("URI is null");
        }
        String string = uRI.toString();
        if (DEBUG) {
            System.err.println("getURIDirname " + uRI + ", extForm: " + string);
        }
        return new URI(IOUtil.getURIDirname(string));
    }

    public static String getURIDirname(String string) throws IllegalArgumentException, URISyntaxException {
        if (null == string) {
            throw new IllegalArgumentException("uriS is null");
        }
        int n = string.lastIndexOf(47);
        if (0 > n && 0 > (n = string.lastIndexOf(58))) {
            throw new IllegalArgumentException("URI does not contain protocol terminator ':', in <" + string + ">");
        }
        string = string.substring(0, n + 1);
        if (DEBUG) {
            System.err.println("getJarURIDirname res: " + string);
        }
        return string;
    }

    public static URL toURL(URI uRI) throws IOException, IllegalArgumentException, URISyntaxException {
        int n;
        URL uRL;
        block20: {
            block19: {
                boolean bl;
                uRL = null;
                String string = uRI.getScheme();
                boolean bl2 = JAR_SCHEME.equals(string);
                URI uRI2 = bl2 ? JarUtil.getJarSubURI(uRI) : uRI;
                boolean bl3 = bl = uRI2 != uRI;
                if (DEBUG) {
                    System.err.println("IOUtil.toURL.0: isJAR " + bl2 + ", hasSubURI " + bl + PlatformPropsImpl.NEWLINE + "\t, uri " + uRI + PlatformPropsImpl.NEWLINE + "\t str -> " + uRI2.toString() + PlatformPropsImpl.NEWLINE + "\t ascii -> " + uRI2.toASCIIString() + PlatformPropsImpl.NEWLINE + "\t ssp -> " + uRI2.getSchemeSpecificPart() + PlatformPropsImpl.NEWLINE + "\t frag -> " + uRI2.getFragment() + PlatformPropsImpl.NEWLINE + "\t path -> " + uRI2.getPath() + PlatformPropsImpl.NEWLINE + "\t path.decoded -> " + IOUtil.decodeFromURI(uRI2.getPath()));
                }
                n = 0;
                if (FILE_SCHEME.equals(uRI2.getScheme())) {
                    File file;
                    try {
                        file = new File(IOUtil.decodeFromURI(uRI2.getPath()));
                    }
                    catch (Exception exception) {
                        if (DEBUG) {
                            System.err.println("Catched " + exception.getClass().getSimpleName() + ": new File(" + IOUtil.decodeFromURI(uRI2.getPath()) + ") failed: " + exception.getMessage());
                            exception.printStackTrace();
                        }
                        file = null;
                    }
                    if (null != file) {
                        String string2 = null;
                        try {
                            Object object;
                            Object object2;
                            String string3 = file.getPath();
                            String string4 = IOUtil.encodeFilePathToURI(string3);
                            if (DEBUG) {
                                try {
                                    object2 = file.toURI();
                                    object = ((URI)object2).toURL();
                                    System.err.println("IOUtil.toURL.1b: fUri " + object2 + PlatformPropsImpl.NEWLINE + "\t, fUrl " + object);
                                }
                                catch (Exception exception) {
                                    System.err.println("Catched " + exception.getClass().getSimpleName() + ": f.toURI().toURL() failed: " + exception.getMessage());
                                    exception.printStackTrace();
                                }
                            }
                            if (!bl) {
                                string2 = "file:" + string4;
                                if (DEBUG) {
                                    System.err.println("IOUtil.toURL.1: fPath " + string3 + PlatformPropsImpl.NEWLINE + "\t -> " + string4 + PlatformPropsImpl.NEWLINE + "\t -> " + string2);
                                }
                                uRL = new URL(string2);
                                n = 1;
                            } else {
                                object2 = JarUtil.getJarEntry(uRI);
                                object = bl2 ? '!' + (String)object2 : "";
                                string2 = string + SCHEME_SEPARATOR + FILE_SCHEME + SCHEME_SEPARATOR + string4 + (String)object;
                                if (DEBUG) {
                                    System.err.println("IOUtil.toURL.2: fPath " + string3 + PlatformPropsImpl.NEWLINE + "\t -> " + string4 + PlatformPropsImpl.NEWLINE + "\t, jarEntry " + (String)object2 + PlatformPropsImpl.NEWLINE + "\t, post " + (String)object + PlatformPropsImpl.NEWLINE + "\t -> " + string2);
                                }
                                uRL = new URL(string2);
                                n = 2;
                            }
                        }
                        catch (Exception exception) {
                            if (!DEBUG) break block19;
                            System.err.println("Catched " + exception.getClass().getSimpleName() + ": new URL(" + string2 + ") failed: " + exception.getMessage());
                            exception.printStackTrace();
                        }
                    }
                }
            }
            if (null == uRL) {
                try {
                    uRL = uRI.toURL();
                    n = 3;
                }
                catch (Exception exception) {
                    if (!DEBUG) break block20;
                    System.err.println("Catched " + exception.getClass().getSimpleName() + ": " + uRI + ".toURL() failed: " + exception.getMessage());
                    exception.printStackTrace();
                }
            }
        }
        if (DEBUG) {
            System.err.println("IOUtil.toURL.X: mode " + n + ", " + uRI + PlatformPropsImpl.NEWLINE + "\t -> " + uRL);
        }
        return uRL;
    }

    public static URLConnection getResource(Class<?> clazz, String string) {
        if (null == string) {
            return null;
        }
        ClassLoader classLoader = null != clazz ? clazz.getClassLoader() : IOUtil.class.getClassLoader();
        URLConnection uRLConnection = null;
        if (null != clazz) {
            String string2 = clazz.getName().replace('.', '/');
            int n = string2.lastIndexOf(47);
            if (n >= 0) {
                String string3 = string2.substring(0, n + 1);
                uRLConnection = IOUtil.getResource(string3 + string, classLoader);
                if (DEBUG) {
                    System.err.println("IOUtil: found <" + string + "> within class package <" + string3 + "> of given class <" + clazz.getName() + ">: " + (null != uRLConnection));
                }
            }
        } else if (DEBUG) {
            System.err.println("IOUtil: null context");
        }
        if (null == uRLConnection) {
            uRLConnection = IOUtil.getResource(string, classLoader);
            if (DEBUG) {
                System.err.println("IOUtil: found <" + string + "> by classloader: " + (null != uRLConnection));
            }
        }
        return uRLConnection;
    }

    public static URLConnection getResource(String string, ClassLoader classLoader) {
        if (null == string) {
            return null;
        }
        if (DEBUG) {
            System.err.println("IOUtil: locating <" + string + ">, has cl: " + (null != classLoader));
        }
        if (string.startsWith("asset:")) {
            try {
                return AssetURLContext.createURL(string, classLoader).openConnection();
            }
            catch (IOException iOException) {
                if (DEBUG) {
                    System.err.println("IOUtil: Catched Exception:");
                    iOException.printStackTrace();
                }
                return null;
            }
        }
        try {
            return AssetURLContext.resolve(string, classLoader);
        }
        catch (IOException iOException) {
            if (DEBUG) {
                System.err.println("IOUtil: Catched Exception:");
                iOException.printStackTrace();
            }
            return null;
        }
    }

    public static String getRelativeOf(File file, String string) throws URISyntaxException {
        if (null == string) {
            return null;
        }
        if (file != null) {
            File file2 = new File(file, string);
            return IOUtil.slashify(file2.getPath(), false, false);
        }
        return null;
    }

    public static String getParentOf(String string) throws URISyntaxException {
        int n;
        int n2 = n = null != string ? string.length() : 0;
        if (n == 0) {
            throw new IllegalArgumentException("path is empty <" + string + ">");
        }
        int n3 = string.lastIndexOf("/");
        if (n3 < 0) {
            throw new URISyntaxException(string, "path contains no '/'");
        }
        if (n3 == 0) {
            throw new URISyntaxException(string, "path has no parents");
        }
        if (n3 < n - 1) {
            return string.substring(0, n3 + 1);
        }
        int n4 = string.lastIndexOf("!") + 1;
        int n5 = string.lastIndexOf("/", n3 - 1);
        if (n5 >= n4) {
            return string.substring(0, n5 + 1);
        }
        throw new URISyntaxException(string, "parent of path contains no '/'");
    }

    public static String cleanPathString(String string) throws URISyntaxException {
        int n;
        while ((n = string.indexOf("../")) >= 0) {
            string = IOUtil.getParentOf(string.substring(0, n)) + string.substring(n + 3);
        }
        while ((n = string.indexOf("./")) >= 0) {
            string = string.substring(0, n) + string.substring(n + 2);
        }
        return string;
    }

    public static URI getRelativeOf(URI uRI, String string) throws URISyntaxException {
        return IOUtil.compose(uRI.getScheme(), uRI.getSchemeSpecificPart(), string, uRI.getFragment());
    }

    public static URL getRelativeOf(URL uRL, String string) throws IOException {
        try {
            return IOUtil.getRelativeOf(uRL.toURI(), string).toURL();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IOException(uRISyntaxException);
        }
    }

    public static URI compose(String string, String string2, String string3, String string4) throws URISyntaxException {
        String string5;
        int n = string2.lastIndexOf(63);
        if (n >= 0) {
            string5 = string2.substring(n + 1);
            string2 = string2.substring(0, n);
        } else {
            string5 = null;
        }
        if (null != string3) {
            if (!string2.endsWith("/")) {
                string2 = IOUtil.getParentOf(string2);
            }
            string2 = string2 + string3;
        }
        string2 = IOUtil.cleanPathString(string2);
        return new URI(string, null == string5 ? string2 : string2 + "?" + string5, string4);
    }

    public static String encodeToURI(String string) {
        return patternSpaceRaw.matcher(string).replaceAll("%20");
    }

    public static String decodeFromURI(String string) {
        return patternSpaceEnc.matcher(string).replaceAll(" ");
    }

    public static String encodeFilePathToURI(String string) {
        if (!File.separator.equals("/")) {
            String string2 = patternSingleBS.matcher(string).replaceAll("/");
            if (!string2.startsWith("/")) {
                return "/" + string2;
            }
            return string2;
        }
        return string;
    }

    public static String decodeURIToFilePath(String string) {
        String string2 = IOUtil.decodeFromURI(string);
        if (!File.separator.equals("/")) {
            String string3 = patternSingleFS.matcher(string2).replaceAll("\\\\");
            if (string3.startsWith("\\")) {
                return string3.substring(1);
            }
            return string3;
        }
        return string2;
    }

    public static String decodeURIIfFilePath(URI uRI) {
        if (FILE_SCHEME.equals(uRI.getScheme())) {
            return IOUtil.decodeURIToFilePath(uRI.getPath());
        }
        return uRI.toASCIIString();
    }

    public static URLConnection openURL(URL uRL) {
        return IOUtil.openURL(uRL, ".");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static URLConnection openURL(URL uRL, String string) {
        if (null != uRL) {
            try {
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.connect();
                if (!DEBUG) return uRLConnection;
                System.err.println("IOUtil: urlExists(" + uRL + ") [" + string + "] - true");
                return uRLConnection;
            }
            catch (IOException iOException) {
                if (!DEBUG) return null;
                System.err.println("IOUtil: urlExists(" + uRL + ") [" + string + "] - false - " + iOException.getClass().getSimpleName() + ": " + iOException.getMessage());
                iOException.printStackTrace();
                return null;
            }
        } else {
            if (!DEBUG) return null;
            System.err.println("IOUtil: no url - urlExists(null) [" + string + "]");
        }
        return null;
    }

    private static String getShellSuffix() {
        switch (PlatformPropsImpl.OS_TYPE) {
            case WINDOWS: {
                return ".bat";
            }
        }
        return ".sh";
    }

    private static boolean getOSHasNoexecFS() {
        switch (PlatformPropsImpl.OS_TYPE) {
            case WINDOWS: 
            case OPENKODE: {
                return false;
            }
        }
        return true;
    }

    private static boolean getOSHasFreeDesktopXDG() {
        switch (PlatformPropsImpl.OS_TYPE) {
            case WINDOWS: 
            case OPENKODE: 
            case ANDROID: 
            case MACOS: {
                return false;
            }
        }
        return true;
    }

    public static boolean testFile(File file, boolean bl, boolean bl2) {
        if (!file.exists()) {
            if (DEBUG) {
                System.err.println("IOUtil.testFile: <" + file.getAbsolutePath() + ">: does not exist");
            }
            return false;
        }
        if (bl && !file.isDirectory()) {
            if (DEBUG) {
                System.err.println("IOUtil.testFile: <" + file.getAbsolutePath() + ">: is not a directory");
            }
            return false;
        }
        if (bl2 && !file.canWrite()) {
            if (DEBUG) {
                System.err.println("IOUtil.testFile: <" + file.getAbsolutePath() + ">: is not writable");
            }
            return false;
        }
        return true;
    }

    public static boolean testDirExec(File file) throws SecurityException {
        int n;
        File file2;
        block13: {
            if (!IOUtil.testFile(file, true, true)) {
                if (DEBUG) {
                    System.err.println("IOUtil.testDirExec: <" + file.getAbsolutePath() + ">: Not writeable dir");
                }
                return false;
            }
            if (!IOUtil.getOSHasNoexecFS()) {
                if (DEBUG) {
                    System.err.println("IOUtil.testDirExec: <" + file.getAbsolutePath() + ">: Always executable");
                }
                return true;
            }
            try {
                file2 = File.createTempFile("jogamp_exe_tst", IOUtil.getShellSuffix(), file);
            }
            catch (SecurityException securityException) {
                throw securityException;
            }
            catch (IOException iOException) {
                if (DEBUG) {
                    iOException.printStackTrace();
                }
                return false;
            }
            n = -1;
            if (file2.setExecutable(true, true)) {
                try {
                    Process process = Runtime.getRuntime().exec(file2.getCanonicalPath());
                    process.waitFor();
                    n = process.exitValue();
                }
                catch (SecurityException securityException) {
                    throw securityException;
                }
                catch (Throwable throwable) {
                    n = -2;
                    if (!DEBUG) break block13;
                    System.err.println("IOUtil.testDirExec: <" + file2.getAbsolutePath() + ">: Catched " + throwable.getClass().getSimpleName() + ": " + throwable.getMessage());
                }
            }
        }
        file2.delete();
        if (DEBUG) {
            System.err.println("IOUtil.testDirExec(): <" + file.getAbsolutePath() + ">: res " + n);
        }
        return 0 == n;
    }

    private static File testDirImpl(File file, boolean bl, boolean bl2, String string) throws SecurityException {
        File file2;
        if (bl && !file.exists()) {
            file.mkdirs();
        }
        if (bl2) {
            file2 = IOUtil.testDirExec(file) ? file : null;
        } else {
            File file3 = file2 = IOUtil.testFile(file, true, true) ? file : null;
        }
        if (DEBUG) {
            System.err.println("IOUtil.testDirImpl(" + string + "): <" + file.getAbsolutePath() + ">, create " + bl + ", exec " + bl2 + ": " + (null != file2));
        }
        return file2;
    }

    public static File testDir(File file, boolean bl, boolean bl2) throws SecurityException {
        return IOUtil.testDirImpl(file, bl, bl2, "testDir");
    }

    private static boolean isStringSet(String string) {
        return null != string && 0 < string.length();
    }

    private static File getSubTempDir(File file, String string, boolean bl, String string2) throws SecurityException {
        File file2 = null;
        if (null != IOUtil.testDirImpl(file, true, bl, string2)) {
            for (int i = 0; null == file2 && i <= 9999; ++i) {
                String string3 = String.format("_%04d", i);
                file2 = IOUtil.testDirImpl(new File(file, string + string3), true, bl, string2);
            }
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static File getTempDir(boolean bl) throws SecurityException, RuntimeException {
        Object object;
        Object object2;
        if (!tempRootSet) {
            object2 = IOUtil.class;
            // MONITORENTER : com.jogamp.common.util.IOUtil.class
            if (!tempRootSet) {
                String string;
                tempRootSet = true;
                object = AndroidUtils.getTempRoot();
                if (null != object) {
                    tempRootExec = tempRootNoexec = IOUtil.getSubTempDir((File)object, tmpSubDir, false, "Android.ctxTemp");
                    // MONITOREXIT : object2
                    return tempRootExec;
                }
                object = PropertyAccess.getProperty(java_io_tmpdir_propkey, false);
                String string2 = System.getenv("TMPDIR");
                if (!IOUtil.isStringSet(string2)) {
                    string2 = System.getenv("TEMP");
                }
                String string3 = IOUtil.isStringSet(string2) && !string2.equals(object) ? string2 : null;
                string2 = PropertyAccess.getProperty(user_home_propkey, false);
                if (IOUtil.getOSHasFreeDesktopXDG()) {
                    string = System.getenv(XDG_CACHE_HOME_envkey);
                    if (!IOUtil.isStringSet(string) && IOUtil.isStringSet(string2)) {
                        string = string2 + File.separator + ".cache";
                    }
                } else {
                    string = null;
                }
                String string4 = string;
                if (null == tempRootExec && IOUtil.isStringSet((String)object)) {
                    tempRootExec = Platform.OSType.MACOS == PlatformPropsImpl.OS_TYPE ? IOUtil.getSubTempDir(new File((String)object), tmpSubDir, false, "tempX1") : IOUtil.getSubTempDir(new File((String)object), tmpSubDir, true, "tempX1");
                }
                if (null == tempRootExec && IOUtil.isStringSet(string4)) {
                    tempRootExec = IOUtil.getSubTempDir(new File(string4), tmpSubDir, true, "tempX2");
                }
                if (null == tempRootExec && IOUtil.isStringSet(string3)) {
                    tempRootExec = IOUtil.getSubTempDir(new File(string3), tmpSubDir, true, "tempX3");
                }
                if (null == tempRootExec && IOUtil.isStringSet(string2)) {
                    tempRootExec = IOUtil.getSubTempDir(new File(string2), ".jogamp", true, "tempX4");
                }
                if (null != tempRootExec) {
                    tempRootNoexec = tempRootExec;
                } else {
                    if (null == tempRootNoexec && IOUtil.isStringSet((String)object)) {
                        tempRootNoexec = IOUtil.getSubTempDir(new File((String)object), tmpSubDir, false, "temp01");
                    }
                    if (null == tempRootNoexec && IOUtil.isStringSet(string4)) {
                        tempRootNoexec = IOUtil.getSubTempDir(new File(string4), tmpSubDir, false, "temp02");
                    }
                    if (null == tempRootNoexec && IOUtil.isStringSet(string3)) {
                        tempRootNoexec = IOUtil.getSubTempDir(new File(string3), tmpSubDir, false, "temp03");
                    }
                    if (null == tempRootNoexec && IOUtil.isStringSet(string2)) {
                        tempRootNoexec = IOUtil.getSubTempDir(new File(string2), ".jogamp", false, "temp04");
                    }
                }
                if (DEBUG) {
                    string = null != tempRootExec ? tempRootExec.getAbsolutePath() : null;
                    String string5 = null != tempRootNoexec ? tempRootNoexec.getAbsolutePath() : null;
                    System.err.println("IOUtil.getTempRoot(): temp dirs: exec: " + string + ", noexec: " + string5);
                }
            }
            // MONITOREXIT : object2
        }
        Object object3 = object2 = bl ? tempRootExec : tempRootNoexec;
        if (null == object2) {
            throw new RuntimeException("Could not determine a temporary directory");
        }
        object = new FilePermission(((File)object2).getAbsolutePath(), "read,write,delete");
        SecurityUtil.checkPermission((Permission)object);
        return object2;
    }

    public static File createTempFile(String string, String string2, boolean bl) throws IllegalArgumentException, IOException, SecurityException {
        return File.createTempFile(string, string2, IOUtil.getTempDir(bl));
    }

    public static void close(Closeable closeable, boolean bl) throws RuntimeException {
        block4: {
            if (null != closeable) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {
                    if (bl) {
                        throw new RuntimeException(iOException);
                    }
                    if (!DEBUG) break block4;
                    System.err.println("Catched Exception: ");
                    iOException.printStackTrace();
                }
            }
        }
    }

    public static class ClassResources {
        public final Class<?> contextCL;
        public final String[] resourcePaths;

        public final int resourceCount() {
            return this.resourcePaths.length;
        }

        public ClassResources(Class<?> clazz, String[] stringArray) {
            for (int i = stringArray.length - 1; i >= 0; --i) {
                if (null != stringArray[i]) continue;
                throw new IllegalArgumentException("resourcePath[" + i + "] is null");
            }
            this.contextCL = clazz;
            this.resourcePaths = stringArray;
        }

        public URLConnection resolve(int n) throws ArrayIndexOutOfBoundsException {
            return IOUtil.getResource(this.contextCL, this.resourcePaths[n]);
        }
    }
}

