#version 450

#extension GL_ARB_separate_shader_objects : enable
#extension GL_ARB_shading_language_420pack : enable

layout (location = 0) in vec3 inPos;
layout (location = 1) in vec2 inUV;

layout (binding = 0) uniform UBO 
{
	mat4 projection;
	mat4 model;
	float time;
} ubo;

layout (location = 0) out vec2 outUV;
layout (location = 1) out float outTime;

void main() 
{
	outUV = inUV;
	outTime = ubo.time;
	gl_Position = (ubo.projection*vec4(abs(tan(ubo.time*0.1+inUV.y*1.1)))) * ubo.model * vec4(inPos.xyz*vec3(tan(ubo.time*1.1),tan(ubo.time*0.1),cos(ubo.time*0.1)), ubo.time*0.01);
}
