unit fonts;
interface
uses graph;

procedure LoadTheFont( ProcedurePointer : pointer );
procedure PrepareTheFonts;
procedure LoadTheDriver( ProcedurePointer : pointer );
procedure PrepareTheDrivers;

implementation

procedure GOTHfont;             external;       {$L GOTH.OBJ}
procedure TRIPfont;             external;       {$L TRIP.OBJ}
procedure LITTfont;             external;       {$L LITT.OBJ}
procedure EGAVGADriver;         external;       {$L EGAVGA.OBJ}

procedure LoadTheFont;
begin
      if RegisterBGIFont( ProcedurePointer ) < 0 then begin
         writeln( 'Error registering font: ', GraphErrorMsg( GraphResult ) );
         halt;
      end;
end;

procedure PrepareTheFonts;
begin
     LoadTheFont( @GOTHfont );
     LoadTheFont( @TRIPfont );
     LoadTheFont( @LITTfont );
end;

procedure LoadTheDriver;
begin
     if RegisterBGIdriver( ProcedurePointer ) < 0 then begin
        writeln( 'Error registering driver: ', GraphErrorMsg( Graphresult ) );
        halt;
     end;
end;

procedure PrepareTheDrivers;
begin
     LoadTheDriver( @EGAVGADriver );
end;

end.