//////////////////////////////////////////////////////////////////////
//                                                                  //
//   Playstation Movie Finder MS-DOS Source ver 1.0 by              //
//                      SM0N sman007@hotmail.com                    //
//   FreeWare version (Comments not included, str & iso structures  //
//                     not included)                                //
//                                                                  //
//////////////////////////////////////////////////////////////////////
#include <stdio.h>
#include <dos.h>
#include <mem.h>
#include <conio.h>

typedef unsigned char       CHAR;
typedef unsigned short      WORD;
typedef unsigned long       DWORD;

//===========================================================

typedef struct tagRequestHdr{
   CHAR  LenOfHdr;
   CHAR  SubInitCode;
   CHAR  CommandCode;
   WORD  Status;
   CHAR	resrvd[8];
}RequestHdr; //13

typedef struct tagReadL{
          RequestHdr			reqhdr;
          CHAR 	addrmode  ;
          DWORD 	transfaddr;
          WORD 	numsec;
          DWORD 	startsec;
          CHAR 	datareadmode;
          CHAR 	intrlsize;
          CHAR 	intrlskipfctr;
}ReadL;    //27

typedef struct tag_iso_dir_entry {
    CHAR      len_dr;
    CHAR      XAR_len;
    DWORD      loc_extentI;
    DWORD      loc_extentM;
    DWORD      data_lenI;
    DWORD      data_lenM;
    CHAR      record_time[7];
    CHAR      file_flags_iso;
    CHAR      il_size;
    CHAR      il_skip;
    WORD      VSSNI;
    WORD      VSSNM;
    CHAR      len_fi;
    CHAR      file_id[32];
    CHAR      padding;
} iso_dir_entry;

//Global variables
WORD DRVLETTER;
CHAR  RAWSector[2352];
const  long MovieId=0x80010160L;
iso_dir_entry  DirEntry;

// Prototype functions
WORD   CDReadLongSec(DWORD , CHAR far*,char);
CHAR   CharToDrvLtr(CHAR );
CHAR   CheckDrvLetter(void);
WORD   CDFileOpen(char far*);
CHAR   WriteRiffHeader (FILE *);

//==============================================================
CHAR CharToDrvLtr(CHAR letter)
 {
   if (letter >= 'A' && letter <='Z') return (letter-'A');
   if (letter >= 'a' && letter <='z') return (letter-'a');
   return 25;
 };
//==============================================================
CHAR CheckDrvLetter(void)
{
  union REGS inregs,outregs;

  inregs.h.ah = 0x15;
  inregs.h.al = 0x0B;
  inregs.x.bx = 0xADAD;
  inregs.x.cx = DRVLETTER;
  int86( 0x2F, &inregs, &outregs );

  return (outregs.x.ax != 0);
};
//==================================================================
WORD CDFileOpen(char far *fname)
{
 	union REGS inregs;
	struct SREGS segregs;

	 segread(&segregs);
    printf("%s\n",fname);
    inregs.x.ax = 0x150F;
    inregs.x.cx = DRVLETTER;

     while(*(++fname) != '\\');
     inregs.x.bx = FP_OFF(fname);
     segregs.es =  FP_SEG(fname);

     DirEntry.len_dr = sizeof(iso_dir_entry);
     inregs.x.si = FP_SEG(&DirEntry);
     inregs.x.di = FP_OFF(&DirEntry);
     int86x(0x2F, &inregs, &inregs,&segregs);
     if ( ! (inregs.x.ax) )
     {
       printf("Error: disc must be ISO-9660 format.\n");
       return -1;
     };

     return (inregs.x.flags & 1 );
};
//===================================================================
// 0-ok , FFFF - error
WORD CDReadLongSec(DWORD SectorNum, CHAR far* buf,char mode)
{
 ReadL ReadLongReqHdr;
 union REGS inregs;
 struct SREGS segregs;

 segread(&segregs);
	 inregs.x.ax = 0x1510;
	 inregs.x.bx = FP_OFF(&ReadLongReqHdr);
    segregs.es = segregs.ss;
    inregs.x.cx = DRVLETTER;

 memset(&ReadLongReqHdr, 0, sizeof (ReadLongReqHdr));

   ReadLongReqHdr.reqhdr.LenOfHdr = sizeof (ReadLongReqHdr);
   ReadLongReqHdr.reqhdr.SubInitCode = 0;
   ReadLongReqHdr.reqhdr.CommandCode = 128;
   ReadLongReqHdr.reqhdr.Status      = 0;
	ReadLongReqHdr.addrmode  = 0;
	ReadLongReqHdr.transfaddr = buf;
	ReadLongReqHdr.numsec = 1;
	ReadLongReqHdr.startsec = SectorNum;
	ReadLongReqHdr.datareadmode = mode;
	ReadLongReqHdr.intrlsize = 0;
	ReadLongReqHdr.intrlskipfctr = 0;

 int86x(0x2F, &inregs, &inregs, &segregs);
 if(ReadLongReqHdr.reqhdr.Status & 0x8000)
 {
  printf("Error: CD-ROM read error. code=%01X\n",ReadLongReqHdr.reqhdr.Status & 0xF);
  return -1;
 }
 return 0;
}
//====================================================================
CHAR  WriteRiffHeader (FILE *fdest)
{
 char rifhdr[44];
 memset(rifhdr,0,44);
 rifhdr[0]='R';
 rifhdr[1]='I';
 rifhdr[2]='F';
 rifhdr[3]='F';
 rifhdr[8]='C';
 rifhdr[9]='D';
 rifhdr[10]='X';
 rifhdr[11]='A';
 rewind(fdest);
 return fwrite(rifhdr,44,1,fdest);
};

//====================================================================
//
//
int main(int argc, char * argv[])
{
   CHAR  far *srcname;
   CHAR  fdestname[12];
   CHAR  ScanChar;
   CHAR  MovCount;
   DWORD PrevFrame;
   DWORD CurSector;
   DWORD TopSector;
   DWORD Lenght;
   DWORD FrameCounter;
   DWORD MovFoundFlag;
   FILE *fdest = NULL;


	printf("Playstation Movie Finder for MSCDEX ver 1.0 (C) SM0N sman007@hotmail.com\n");
   if (argc < 3)
    {
      printf("Usage: STRFIND CDXAfile WriteFilePrefix\n");
      return 1;
    };
   srcname = argv[1];
   if (srcname[1] != ':')
   {
     printf("Error: CD-ROM drive name is necessary.\n");
     return 1;
   };
   if((DRVLETTER=CharToDrvLtr(srcname[0])) == 25)
   {
     printf("Error: Illegal drive name.\n");
     return 1;
   };
   if(!CheckDrvLetter())
   {
     printf("Error: %c is not CDROM drive.\n",DRVLETTER+'A');
     return 1;
   };
   if(CDFileOpen((char far *)srcname))
   {
     printf("Error: File open error.[%s]\n",srcname);
     return 1;
   };


  MovCount = 0;
  MovFoundFlag = 0;
  FrameCounter = 0;
  PrevFrame = 0;
  Lenght =  DirEntry.data_lenI>>11;
  TopSector = DirEntry.loc_extentI;
  CurSector = TopSector;

  printf("Top sector = %ld\n",DirEntry.loc_extentI);
  printf("Lenght = %ld sectors \n", Lenght);

  while(CurSector < TopSector + Lenght)
   {
     if (kbhit())
     {
        ScanChar = getch();
        if (ScanChar == 27 )
        {
            printf("Stop.\n");
            fclose(fdest); return 1;
        }
     };

     if(CDReadLongSec(CurSector,RAWSector,1))
     {
      printf("Error: File read error.[%s]\n",srcname);
      fclose(fdest);return 1;
     };

     if(MovFoundFlag==0)
     {
       if(!memcmp(&RAWSector[24],&MovieId,4))
       {
         MovFoundFlag=1;
         MovCount++;
         FrameCounter = 1;
         PrevFrame = 1;
         printf("Movie Found!!!\n");
         printf("Start sector = %ld\n",CurSector);
         if ( fdest ) fdest = fclose(fdest);
         sprintf(fdestname,"%s%03d.str",argv[2],MovCount)   ;
         printf("Writing movie: %s\n",fdestname);
         if(!(fdest=fopen(fdestname,"wb")))
         {
          printf("Error: File open error.[%s]\n",fdestname); return 1;
         }
         if(!WriteRiffHeader(fdest))
         {
           printf("Error: File write error.[%s]\n",fdestname);
           fclose(fdest); return 1;
         };
         if(!fwrite(RAWSector,2352,1,fdest))
         {
           printf("Error: File write error.[%s]\n",fdestname);
           fclose(fdest); return 1;
         };
       }
       CurSector++;
        if(CurSector > (TopSector + Lenght))
        {
         printf("Number of frames = %ld\n",PrevFrame);
         fclose(fdest);
         return 1;
        }
     }
     else
     {
       CurSector++;

       if(!memcmp(&RAWSector[24],&MovieId,4))
       {
          PrevFrame = FrameCounter;
 	       memcpy(&FrameCounter,&RAWSector[32],4);

	        if(CurSector == TopSector + Lenght)
	        printf("Number of frames = %ld\n",PrevFrame);

	       if( FrameCounter < PrevFrame )
	       {
	         MovFoundFlag = 0;
            CurSector--;
	         printf("Number of frames = %ld\n",PrevFrame);
  		      fclose(fdest);
	       }
          else
          {
            if(!fwrite(RAWSector,2352,1,fdest))
       		  {
      		     printf("Error: File write error.[%s]\n",fdestname);
       		     fclose(fdest); return 1;
     		     };
          }
      }
      else
      {
        if(!fwrite(RAWSector,2352,1,fdest))
         {
           printf("Error: File write error.[%s]\n",fdestname);
           fclose(fdest); return 1;
         };
        if(CurSector == TopSector + Lenght)
	        printf("Number of frames = %ld\n",PrevFrame);

      }
     };
   };
  printf("Done.\n");
  return 0;
}

